% -*- Prolog -*- 
%    File:	current_op.pl  
%    Author:	Johan Bevemyr
%    Created:	Fri Nov  8 14:51:43 1991
%    Purpose:   Same as in SICStus.

current_op((+),yfx,500).
current_op((+),fx,500).
current_op((','),xfy,1000).
current_op((-),yfx,500).
current_op((-),fx,500).
current_op((*),yfx,400).
current_op((/),yfx,400).
current_op((;),xfy,1100).
current_op((=),xfx,700).
current_op((<),xfx,700).
current_op((>),xfx,700).
current_op((^),xfy,200).
current_op((//),yfx,400).
current_op((->),xfy,1050).
current_op((:-),xfx,1200).
current_op((:-),fx,1200).
current_op((?-),fx,1200).
current_op((<<),yfx,400).
current_op((==),xfx,700).
current_op((=<),xfx,700).
current_op((/\),yfx,500).
current_op((@<),xfx,700).
current_op((@>),xfx,700).
current_op((>>),yfx,400).
current_op((>=),xfx,700).
current_op((\+),fy,900).
current_op((\/),yfx,500).
current_op((#),yfx,500).
current_op((dynamic),fx,1150).
current_op((is),xfx,700).
current_op((-->),xfx,1200).
current_op(('=..'),xfx,700).
current_op((nospy),fy,900).
current_op((multifile),fx,1150).
current_op((=:=),xfx,700).
current_op((@=<),xfx,700).
current_op((@>=),xfx,700).
current_op((=\=),xfx,700).
current_op((\==),xfx,700).
current_op((mode),fx,1150).
current_op((wait),fx,1150).
current_op((parallel),fx,1150).
current_op((mod),xfx,300).
current_op((spy),fy,900).
current_op((public),fx,1150).

current_infixop(Op, xfx, LPrec, Prec, RPrec) :-
	current_op(Op, xfx, Prec), !,
	LPrec is Prec - 1,
	RPrec is LPrec.
current_infixop(Op, xfy, LPrec, Prec, RPrec) :-
	current_op(Op, xfy, Prec), !,
	LPrec is Prec - 1,
	eq(RPrec, Prec).
current_infixop(Op, yfx, LPrec, Prec, RPrec) :-
	current_op(Op, yfx, Prec), !,
	RPrec is Prec - 1,
	eq(LPrec ,Prec).

current_prefixop(Op, fy, Prec, RPrec) :-
	current_op(Op, fy, Prec), !,
	eq(RPrec, Prec).

current_prefixop(Op, fx, Prec, RPrec) :-
	current_op(Op, fx, Prec), !,
	RPrec is Prec - 1.

current_postfixop(Op, yf, LPrec, Prec) :-
	current_op(Op, yf, Prec), !,
	eq(LPrec , Prec).

current_postfixop(Op, xf, LPrec, Prec) :-
	current_op(Op, xf, Prec), !,
	LPrec is Prec - 1.

