/*    File:	 worker.h  (~bevemyr/Luther2/SharedEmulator/worker.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Thu Oct  8 08:37:39 1992
 *    Purpose:   
 */ 

/**********************************************************************
 *   Environment
 */

typedef struct environment {
    struct environment *cont_env;        /* (CE) cont. environment        */
    code               *next_instr;      /* (CP) cont. code               */
    TAGGED yreg[ANY];
} environment;

/**********************************************************************
 *   Choicepoint
 */

typedef struct choicepoint {
    TAGGED             *trail_top;       /* (TR) top of trail stack        */
    TAGGED             *global_top;      /* (H)  top of global stack       */
    struct choicepoint *last_choice;     /* (B)  previous choice pt.       */
    struct environment *cont_env;        /* (CE) cont. environment         */
    code               *next_instr;      /* (CP) cont. code                */
    code               *next_clause;     /* (BP) next clause to try        */
    indx               arity;            /* (n)  number of saved aregs     */
#if defined(TIMESTAMP) || defined(UNBOUND)
    s32                timestamp;        /* current timestamp              */
#else
#ifdef LOWTAGS
    TAGGED             dummy;
#endif /* LOWTAGS */
#endif 
    TAGGED             areg[ANY];        /* (Ai) saved argument registers  */
} choicepoint;

/**********************************************************************
 *   Worker support
 */

/****************************************
 *   Statistics
 */

typedef struct {
    double user_start_walltime;
    double user_last_walltime;
#ifdef PARALLEL
    double in_parallel_walltime;
    double in_parallel_walltime_last;
    int current_user_time;
#ifdef STAT_AWAIT
    int await;
    int await_count;
#endif /* STAT_AWAIT */
#endif /* PARALLEL */
    int user_start_time;
    int user_last_time;
    int user_last_gctime;
    int user_last_gcnr;
    int user_last_gcbytes;
    int sys_start_time;
    int calls;
    int fails;
    int builtin_calls;
    int heap_gc_nr;
    int heap_gc_bytes;
    int heap_gc_time;
#ifdef TIMESTAMP
    int hva_init_count;
    int sva_init_count;
#endif
#ifdef LOCKING
    int lock_grab;
    int lock_attempt;
#endif
#ifdef SWAP_BIND
    int swap_fail;
#endif
} statistics;

/****************************************
 *   Worker command structure
 */

#ifdef PARALLEL

enum {
  W_EXECUTE_CODE,
  W_RESET,
  W_BACKTRACK,
  W_DEBUG,
  W_REDUCE_PLUS,
  W_REDUCE_TIMES
  };

typedef struct worker_command {
  s32 type;
  code *code;
} worker_command;

#endif /* PARALLEL */

/****************************************
 *   Prolog flags
 */

typedef struct prologflag {
  BOOL gc_verbose;
  BOOL load_verbose;
} prologflag;

/****************************************
 *   Global worker variables
 */

/* Types declared in storage.c */
typedef char heap;

typedef struct globalvar {
    heap *atom_start, *atom_end, *atom_current, *atomoffset;
    heap *patch_start, *patch_current, *patch_end;
    code *code_start, *code_end, *code_current;
    struct definition **predtable;
    atom_bucket **atomtable;
    s32 active_workers;
    prologflag flags;
    struct definition *interrupt_code;
#ifdef PARALLEL
    TAGGED *global_regs;
    worker_command parallel_start;
    BOOL global_fail;
    s32 scheduling;
    s32 scheduling_mode;
    s32 sched_level;
    double *reduction_results;
    TAGGED *collect;
    s32 debugsig;
#endif /* PARALLEL */
#ifdef SPIN_LOCK
    u32 semaphores[MAX_SEM_NR];
#endif    
} globalvar;

/*************************************************************
 *   Information needed for each worker by the GC-algorithm
 */

typedef struct gc_info_t {
  int total_marked,
      arity, 
      envsize;
} gc_info_t;

/****************************************
 *   Local worker variables
 */

typedef struct worker {
    int         pid;
    code 	*pc;
    code 	*next_instr;
#if defined(TIMESTAMP) || defined(UNBOUND)
    s32         time;
    s32         uncond;
#else
    TAGGED      *uncond;
#endif /* TIMESTAMP | UNBOUND */    
    choicepoint *choice;
    choicepoint *choice0;
    environment *frame;
    u32 	event_flag;
    int 	lut_trace;
    TAGGED 	*s;
    TAGGED 	*regs;
#ifdef CACHE_G
    TAGGED      *g_regs;
#endif
#ifdef NEW_READ
    TAGGED 	*rdstack;
#endif
    TAGGED 	*trail_top, *trail_start, *trail_end; 
    TAGGED 	*heap_top, *heap_start, *heap_end, *heap_margin;
#ifdef COPY_GC
    TAGGED 	*heap_copy_top, *heap_copy_start, *heap_copy_end, 
                *heap_copy_margin;
#endif /* COPY_GC */
    TAGGED 	*stack_start, *stack_end;
    statistics  *stats;
    globalvar   *global;

#ifdef PARALLEL
    s32         *level;
    s32         direction;
#endif /* PARALLEL */

    gc_info_t	gc_info;
} worker;


/**********************************************************************
 *   Macros for cacheing of worker variables in machine registers
 */

#define SetPC        pc = w->pc
#define SetArity     arity = w->arity
#define FlushPC      w->pc = pc
#define FlushArity   w->arity = arity
#define SetY(Y)      yreg = Y
#define StoreHeap    w->heap_top = hp
#define LoadHeap     hp = w->heap_top
#define H            hp

/**********************************************************************
 *   Prototypes
 */

#define Arg          w
#define Argdecl      register worker *w
#define Argproto     worker *

#define InArg        w, regs
#define InArgdecl    register worker *w; register s32 *regs
#define InArgproto   worker *, s32 *

extern int worker_nr;
extern worker *worker_set;
