/*    File:	 wam-main.c 
 *    Author:	 Johan Bevemyr
 *    Created:	 Sun Jun  2 17:06:23 1991
 */ 

#include "include.h"
#include "engine.h"
#include "expand_file_name.h"
#include "load.h"
#include "qload.h"
#include "inline.h"
#include "debug.h"
#include "wam-main.h"

extern int _fmode;

typedef enum {
    FILE_WAM,
    FILE_BINARY
} filetype;

typedef struct {
    char *name;
    filetype  type;
} bootfile_t;


void wam_main(argc,argv)
     int argc;
     char **argv;
{
    int i;
    int number_of_workers;
    int bootnr;
    int listingflag = 0;
    bootfile_t bootfiles[BOOTMAX];
    FILE *bootfile;
    char pathBuf[MAXPATHLEN+1];
    worker *w;

#ifdef DEBUG
    debugflag = FALSE;
#endif

#ifdef PARALLEL
    /* Default number_of_workers are 2 */
    number_of_workers = 2;
#else
    /* Default number_of_workers are 1 */
    number_of_workers = 1;
#endif /* PARALLEL */

#ifdef THREADED_CODE
    (void) wam(NULL,NULL); /* initiate lab_table */
#endif /* THREADED_CODE */

    /* Process commands */

    for(bootnr = 0, i = 1 ; i < argc ; i++)
      {
	if(strcmp(argv[i],"-ql") == SAME)                     /* bootfile */
	  {    
	    bootfiles[bootnr].name = argv[++i];
	    bootfiles[bootnr++].type = FILE_BINARY;
	  }
	else if (strcmp(argv[i],"-wam") == SAME)               /* bootfile */
	  { 
	    bootfiles[bootnr].name = argv[++i];
	    bootfiles[bootnr++].type = FILE_WAM;
#ifndef LOAD
	    FatalError("luther not compiled with wam code format");
#endif /* LOAD */
	  }
	else if (strcmp(argv[i],"-list_all") == SAME) /* database listing */
	  { 
	    listingflag = 1;
	  }
	else if(strcmp(argv[i],"-list") == SAME)      /* database listing */
	  {
	    listingflag = 2;
	  }
	else if (strcmp(argv[i],"-verbose") == SAME)   /* verbose loading */
	  {
	    verbose = 1;
	  }
	else if (strcmp(argv[i],"-memory") == SAME)       /* total memory */
	  {
	    i++;
	    total_size = atol(argv[i]);
	  }
	else if (strcmp(argv[i],"-wmemory") == SAME) /* mem. per worker */
	  {
            i++;
#ifdef PARALLEL
	    worker_size = atol(argv[i]);
#endif /* PARALLEL */
	  }
	else if (strcmp(argv[i],"-n") == SAME)    /* number of processes */
	  {
	    i++;
#ifdef PARALLEL
	    number_of_workers = atoi(argv[i]);
#endif /* PARALLEL */
	  }
	else if (strcmp(argv[i],"-w") == SAME)    /* number of workers */
	  {
	    i++;
#ifdef PARALLEL
	    number_of_workers = atoi(argv[i])+1;
#endif /* PARALLEL */
	  }
	else if (strcmp(argv[i],"-debug") == SAME)     /* wam debugger on */
	  {
#ifdef DEBUG
	    debugflag = TRUE;
#endif
	  }
	else if(strcmp(argv[i],"-opcode") == SAME)  /* display inline table */
	  {
	    int i;
	    printf("\n\ninline_opcode(Name,Arity,Op,Type,Ret) :- ");
	    printf("inline_op_code(Name,Arity,Op,Type,Ret),!.\n");
	    printf("inline_opcode(Name,_,_,_,_) :- \n\twrite(user_error,");
	    printf("['inst has no inline opcode: ',Name]),");
	    printf("\n\tnl(user_error), !, fail.\n\n");
	    
	    for(i=0 ; i < INLINE_TABLE_SIZE ; i++ ) {
	      printf("inline_op_code('%s',%d,%d,%s,%d).\n",GetInlineName(i),
		     GetInlineArity(i),i,
		     (GetInlineType(i)==I_FUNC ? "function" : "predicate"),
		     GetInlineRetarg(i));
	    }
	    printf("/* Opcodes for the Luther WAM emulator.\n");
	    printf("   Generated by the C program 'opcode'. */\n\n");
	    printf("opcode(X,Y) :- op_code(X,Y),!.\n");
	    printf("opcode(X,_) :- \n\twrite(user_error,");
	    printf("['inst has no opcode: ',X]),");
	    printf("\n\tnl(user_error), !, fail.\n\n");
	    
	    for(i=0 ; i <= END_OF_PRED ; i++) {
	      printf("op_code('%s',%d).\n",GetOpString(i),i);
	    }
	    
	    printf("\n\nqload_opcode(X,Y) :- qload_op_code(X,Y),!.\n");
	    printf("qload_opcode(X,_) :- \n\twrite(user_error,");
	    printf("['inst has no qload opcode: ',X]),");
	    printf("\n\tnl(user_error), !, fail.\n\n");
	    
	    for(i=0 ; i <= QLOAD_PRED_END ; i++ ) {
	      printf("qload_op_code('%s',%d).\n",qload_opcode_names[i],i);
	    }
	    
	    exit(0);
	  }
	else
	  {
	    printf("usage: %s [-wam <bootfile> -ql <bootfile> ",argv[0]);
	    printf("-n <nr of processes> -w <nr of workers> ");
	    printf("-debug -opcode -verbose ");
	    printf("-list_all -list -memory <bytes> -wmemory <bytes>\n");
	    exit(0);
	  }
      }

    /* Proceed with boot process */
    PL_Print1(stderr,"Booting...");
    fflush(stderr);

    if(bootnr == 0)
      {
	PL_Print1(stderr,"No bootfile!\n");
	exit(0);
      }

    w = initialize(number_of_workers);
    
    if(verbose) PL_Print1(stderr,"\n");

    /* Loading boot files */
    for(i=0 ; i < bootnr; i++)
      {
	if (expand_file_name(bootfiles[i].name, pathBuf) == FALSE) 
	  {
	    PL_Print2(stderr,"Strange bootfile path -- %s!\n",
		      bootfiles[i].name);
	    luther_exit(0);
	  }
	else if((bootfile = fopen(pathBuf,"r")) == NULL)
	  {
	    PL_Print2(stderr,"Cannot find bootfile -- %s!\n", pathBuf);
	    luther_exit(0);
	  }
	
	if(bootfiles[i].type == FILE_WAM)
	  load(bootfile,&(w[0]));
	else
	  quickload(bootfile,&(w[0]));
	fclose(bootfile);
      }

    PL_Print1(stderr,"done\n");
    
    if(listingflag == 1) {
	PL_Print1(stderr,"The database contains the following predicates\n");
	PL_Print1(stderr,"--------------------\n");
	listing(&(w[0]));
	PL_Print1(stderr,"--------------------\n");
	luther_exit(0);
    }
    
    if(listingflag == 2) {
	PL_Print1(stderr,"The database contains the following emulated predicates\n");
	PL_Print1(stderr,"--------------------\n");
	emulated_listing(&(w[0]));
	PL_Print1(stderr,"--------------------\n");
	luther_exit(0);
    }
 
    orig_nr_of_workers = number_of_workers - 1;

    worker_set = &w[0];

#ifdef PARALLEL
    {
      int pid;
      nr_children = 0;
     
      for(i = 1 ; i < number_of_workers ; i++) {
	pid = fork();
	if(pid == 0) {
	  worker_nr = i;
	  wam(NULL,&w[i]);
	  luther_exit(1);
	} else {
	  if(pid == -1) {
	    nr_children = i - 1;
	    perror("can't fork");
	    luther_exit(1);
	  }
	  child_pid[i-1] = pid;
	}
      }
      nr_children = number_of_workers - 1;
    }
#endif
    wam(get_definition(StoreFunctor(atom_table_tagged[ATOM_START],0),&(w[0])),
	&w[0]);
    luther_exit(1);
}
