/*    File:	 unix.c  (~bevemyr/Luther2/SharedEmulator/unix.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Oct  6 10:20:44 1992
 *    Purpose:   Code inspired by muse (Roland Karlsson).
 */ 


#include "include.h"
#ifdef SHARED
#ifdef UNIX
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/vfs.h>
#include <sys/mman.h>

void get_mmap_filename(name,size)
     char *name;
     long size;
{
  struct stat sb;
  struct statfs sfb;
  char *dir;
  char *mapdirs[4];
  int whichdir;
  int fd;

  
  mapdirs[0] = "/usr/tmp";
  mapdirs[1] = "/tmp";
  mapdirs[2] = ".";
  mapdirs[3] = 0;

  dir = mapdirs[0];
  whichdir = 0;

  for(dir = mapdirs[0], whichdir = 0 ;
      dir != 0 ;
      dir = mapdirs[++whichdir])
    {
      if(statfs(dir, &sfb) == -1)
	{
	  PL_Print2(stderr,"Can't find paging dir %s\n",dir);
	}
      else if(size > sfb.f_bfree*sfb.f_bsize)
	{
	  PL_Print2(stderr,"Not enough memory at %s\n",dir);
	}
      else
	break;
    }
  
  if(dir == 0) {
    FatalError("can't find paging file directory");
  }

  strcpy(name,dir);
  strcat(name,"/luther_paging_file_XXXXXX");

  mktemp(name);
  
  if ((fd = open(mmap_filename, O_RDWR | O_CREAT | O_EXCL, 0666)) == -1) {
    perror("can't open paging file");
    luther_exit(1);
  }
  
#ifndef SEQUENT
  if (ftruncate(fd, size) < 0) {
    perror("can't truncate paging file");
    luther_exit(1);
  }
#endif

  close(fd);

  return;
}
#endif /* UNIX */
#endif /* SHARED */

  
