/*    File:	 unify.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Thu May 23 18:06:42 1991
 */ 

#include "bind.h"
#include "trail.h"
#include "deref.h"

/**********************************************************************
 *
 *
 */

#ifdef CONSTR
#define RefHVAorCVA(To,X) RefVAR(To,X)
#else
#define RefHVAorCVA(To,X) RefHVA(To,X)
#endif /* CONSTR */

/**********************************************************************
 *
 */
#define RefVAR(To, X) To = *TagToPointer(X)
#define RefHVA(To, X) To = *Var(OffsetBase(X))

#define IsBoundHVA(X) (((TAGGED) X) != *OffsetBase(X))
#define IsUnbound(X)  (X == *TagToPointer(X))

/**********************************************************************
 *
 */

#define Unify(X,Y)  {                                         \
    register TAGGED tmp1,tmp2;                                \
    DerefNLL(tmp1,X); DerefNLL(tmp2,Y);                       \
    if(!unify(tmp1,tmp2,w)) goto fail;                        \
} 
 
#define UnifyPop(X,Y)  {                                      \
    register TAGGED tmp1,tmp2;                                \
    DerefNLL(tmp1,X); DerefNLL(tmp2,Y);                       \
    if(!unify(tmp1,tmp2,w)) goto fail;                        \
    s = PopCont;                                              \
} 
 
#define Unify1(X,Y)  {                                        \
    register TAGGED tmp1;                                     \
    DerefNLL(tmp1,X);                                         \
    if(!unify(tmp1,Y,w)) goto fail;                           \
}

/**********************************************************************
 *
 */

#define IsUnsafe(V)  (((environment *) RemoveTag(V,SVA)) > w->frame)

#define RefStackUnsafe(H,To, X) {                             \
    register TAGGED tmp1;                                     \
    DerefNLL(tmp1,X);                                         \
    if(IsSVA(tmp1) && IsUnsafe(tmp1)) {                       \
	LoadHVA(H,To,w);                                      \
	SetVar(tmp1, To);                                     \
    } else {                                                  \
	To = tmp1;                                            \
    }                                                         \
}

#define WriteLocalValue(S,X) {                                \
    register TAGGED tmp1,tmp2;                                \
    DerefNLL(tmp1,X);                                         \
    if(IsSVA(tmp1)) {                                         \
	LoadHVA(S,tmp2,w);                                    \
	SetVar(tmp1,tmp2);                                    \
    } else {                                                  \
	*(S) = tmp1; (S) += VARSIZE;                          \
    }                                                         \
}

/**********************************************************************
 *
 */
extern BOOL unify PROTO((TAGGED, TAGGED, worker *));
extern BOOL unify_deref PROTO((TAGGED, TAGGED, worker *));
