/*    File:	 trail.h  (~bevemyr/Luther2/SharedEmulator/trail.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Fri Nov  6 11:07:41 1992
 *    Purpose:   
 */ 

#define PopFromTrail(T,V)   V =  *(--(T)) 
#define PushOnTrail(T,V)    *((T)++) = V

#ifdef CONSTR
/**********************************************************************
 *
 * constrained variables
 *
 */
#define Trail(V,VAL) {                                        \
			register TAGGED VR = (V);             \
			switch(TagOf(VR)) {                   \
			case HVA:                             \
			  Trail_HVA(VR);                      \
			  break;                              \
			case SVA:                             \
			  Trail_SVA(VR);                      \
			  break;                              \
			case CVA:                             \
			  Trail_CVA(VR);                      \
                          break;                              \
			}                                     \
		      }

#else /* CONSTR */
/**********************************************************************
 *
 * NO CONSTR
 *
 */
#define Trail(V,VAL) {  register TAGGED VR = (V);             \
			switch(TagOf(VR)) {                   \
			case HVA:                             \
			  Trail_HVA(VR);                      \
			  break;                              \
			case SVA:                             \
			  Trail_SVA(VR);                      \
			  break;                              \
			}                                     \
		      }

#endif /* CONSTR */

#ifdef TRAIL_ALL
/**********************************************************************
 *
 * Trail every binding.
 *
 */

#define Trail_GEN(V)       PushOnTrail(w->trail_top,V)
#define Trail_HVA(V)       PushOnTrail(w->trail_top,V)
#define Trail_SVA(V)       PushOnTrail(w->trail_top,V)
#define Trail_CVA(V)       /* no-op */

#else /* TRAIL_ALL */
/**********************************************************************
 *
 * Trail only conditional bindings 
 *
 */

#define Trail_GEN(V)       PushOnTrail(w->trail_top,V)
#define Trail_CVA(V)       { if(GetCVATime(V) < w->uncond)         \
                               Error("trail_cva: conditional CVA");}
#ifdef UNBOUND
#define Trail_HVA(V,T)     { if(GetHVATime(T) < w->uncond) {       \
			       PushOnTrail(w->trail_top, T);       \
			       PushOnTrail(w->trail_top, V);} }
#else  /* UNBOUND */
#define Trail_HVA(V)       { if(GetHVATime(V) < w->uncond)         \
			       PushOnTrail(w->trail_top, V); }
#endif /* UNBOUND */

#if (defined(TIMESTAMP) & !defined(SHORT_SVA))
/**********************************************************************
 *
 * Check conditional Stack variables using TIMESTAMP
 *
 */

#define Trail_SVA(V)       { if(GetSVATime(V) < w->uncond)         \
			       PushOnTrail(w->trail_top, V); }
#else
#define Trail_SVA(V)       { if(GetSVATime(V) < (TAGGED *) w->choice) \
			       PushOnTrail(w->trail_top, V); }
#endif /* TIMESTAMP ... */
#endif /* TRAIL_ALL */

/**********************************************************************
 *
 *
 */

#ifdef UNBOUND
#define AlwaysTrail(V) 	    { PushOnTrail(w->trail_top,*TagToPointer(V)); \
                              PushOnTrail(w->trail_top,                   \
					  (TAGGED) BaseOffset(TagToPointer(V))); }
#define UnBind_HVA(V)       { *((TAGGED *) OffsetBase(*V)) = *(V-1); \
                              (V)--; }
#else  /* UNBOUND */

#define AlwaysTrail(V) 	    PushOnTrail(w->trail_top,V)
#define UnBind_HVA(V)       *((TAGGED *) OffsetBase(*V)) = (*V)

#endif /* UNBOUND */

#define UnBind_SVA(V)       *((TAGGED *) RemoveTag(*V,SVA)) = (*V)

#define IsValueTrail(T)     IsLST(*(T))
#define UndoValue(T)        { *TagToPointer(*T) = *(T-1); (T)--; }
#define ValueTrail(Var,Val) { *(w->trail_top)++=(TAGGED) Val;     \
                              *(w->trail_top)++=Tagify(Var,LST); }

#ifndef PARALLEL
#define TidyTrail                                                 \
{                                                                 \
  register TAGGED *stop = w->choice->trail_top;                   \
  register TAGGED *curr = w->trail_top;                           \
  register TAGGED *dest = curr;                                   \
  register TAGGED *heaplim = w->choice->global_top;               \
  register TAGGED *stacklim =  (TAGGED *)                         \
    EnvTop(w->choice->cont_env,FrameSize(w->choice->next_instr)); \
                                                                  \
  while(curr > stop)                                              \
    {                                                             \
      curr--;                                                     \
      switch(TagOf(*curr))                                        \
	{                                                         \
	case HVA:                                                 \
	  if(TagToPointer(*curr) > heaplim)                       \
	    *curr = 0;                                            \
	  break;                                                  \
	case SVA:                                                 \
	  if(TagToPointer(*curr) > stacklim)                      \
	    *curr = 0;                                            \
	  break;                                                  \
	case NUM:                                                 \
	  break;                                                  \
	case LST:                                                 \
	  curr--;                                                 \
	  break;                                                  \
	case STR:                                                 \
	  break;                                                  \
	case GEN:                                                 \
	default:                                                  \
	}                                                         \
      curr--;                                                     \
    }                                                             \
                                                                  \
  stop = w->trail_top;                                            \
  curr = w->choice->trail_top;                                    \
  dest = w->choice->trail_top;                                    \
                                                                  \
  while(curr < stop)                                              \
    {                                                             \
      if(*curr == 0)                                              \
	{                                                         \
	  curr++;                                                 \
	}                                                         \
      else                                                        \
	{                                                         \
	  *dest = *curr;                                          \
	  curr++;                                                 \
	  dest++;                                                 \
	}                                                         \
    }                                                             \
                                                                  \
  w->trail_top = dest;                                            \
}  
#else

#define TidyTrail /* no op */

#endif /* PARALLEL */

#define Unwind_Trail(T)                                           \
{                                                                 \
  register TAGGED *stop = (T);                                    \
                                                                  \
  while(w->trail_top > stop)                                      \
    {                                                             \
      w->trail_top--;                                             \
      switch(TagOf(*(w->trail_top)))                              \
	{                                                         \
	case HVA:                                                 \
	  UnBind_HVA(w->trail_top);                               \
	  break;                                                  \
	case SVA:                                                 \
	  UnBind_SVA(w->trail_top);                               \
	  break;                                                  \
	case NUM: /* Only on workers, ignore here */              \
	  break;                                                  \
	case LST:                                                 \
	  UndoValue(w->trail_top);                                \
	  break;                                                  \
	case STR: /* Only in Parallel */                          \
	  UnwindWorkers;                                          \
	  break;                                                  \
	case GEN:                                                 \
	  GetMethod(undo,*(w->trail_top))(*(w->trail_top));       \
	  break;                                                  \
	default:                                                  \
	  UnBind_SVA(w->trail_top);                               \
	}                                                         \
    }                                                             \
}
#ifdef PARALLEL

#define UnwindWorkers                                             \
{                                                                 \
  w->global->parallel_start.type = W_BACKTRACK;                   \
  ActivateWorkers(w);                                             \
}

#define Worker_Unwind_Trail                                       \
{                                                                 \
  register TAGGED *stop = w->trail_start;                         \
                                                                  \
  while(w->trail_top > stop)                                      \
    {                                                             \
      w->trail_top--;                                             \
      switch(TagOf(*(w->trail_top)))                              \
	{                                                         \
	case HVA:                                                 \
	  UnBind_HVA(w->trail_top);                               \
	  break;                                                  \
	case SVA:                                                 \
	  UnBind_SVA(w->trail_top);                               \
	  break;                                                  \
	case NUM: /* Only on workers */                           \
	  stop = w->trail_top;                                    \
          w->heap_top = TagToPointer(*(w->trail_top));            \
	  break;                                                  \
	case LST:                                                 \
	  UndoValue(w->trail_top);                                \
	  break;                                                  \
	case GEN:                                                 \
	  GetMethod(undo,*(w->trail_top))(*(w->trail_top));       \
	  break;                                                  \
	default:                                                  \
	  UnBind_SVA(w->trail_top);                               \
	}                                                         \
    }                                                             \
}

#else
#define UnwindWorkers
#endif

