/*    File:	 time.c 
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Jun 10 11:51:29 1991
 */ 

#include "include.h"
#include "initial.h"
#ifndef THINK_C
#include <sys/stat.h>
#endif

#if defined(BSD_UNIX) || defined(APOLLO)

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>

struct rusage t;

long usertime()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    OsError("getrusage error");
    return 0;
  }
  return t.ru_utime.tv_sec*1000 + t.ru_utime.tv_usec / 1000;
}
    
long systime()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    OsError("getrusage error");
    return 0;
  }
  return t.ru_stime.tv_sec*1000 + t.ru_stime.tv_usec / 1000;
}

double walltime()
{
    struct timeval tp;
    struct timezone tzp;

    gettimeofday(&tp,&tzp);
    return (double) tp.tv_sec +(double) tp.tv_usec/1.0e6;
}

long pagefaults_no_io()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    OsError("getrusage error");
    return 0;
  }
  return t.ru_minflt;
}

long pagefaults_ph_io()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    OsError("getrusage error");
    return 0;
  }
  return t.ru_majflt;
}

#endif /* BSD_UNIX */

#if HP_UX

#include <sys/times.h>

long usertime()
{
    struct tms buffer;

    if(times(&buffer) == -1) {
	Error("usertime: can't read user time");
	return 0;
    }

    return (long) (buffer.tms_utime / ticks_per_msecond);
}

long systime()
{
    struct tms buffer;

    if(times(&buffer) == -1) {
	Error("systime: can't read system time");
	return 0;
    }

    return (buffer.tms_stime / ticks_per_msecond);
}

double walltime()
{
    return 0.0;
}

long pagefaults_no_io()
{
    return 0;
}

long pagefaults_ph_io()
{
    return 0;
}


#endif /* TIMES */

#ifndef THINK_C
long file_mod_time(name)
    char *name;
{
    struct stat buf;

    if(stat(name,&buf) != 0) {
	Error("can't get file modification time");
	return 0;
    }

    return buf.st_mtime;
}

#else
long file_mod_time(char *name)
{
    Error("can't get file modification time");
    return 0;
}
#endif

