/*    File:	 term.c 
 *    Author:	 Johan Bevemyr
 *    Created:	 Sat May 25 19:10:47 1991
 *    Purpose:   To make various data structures.
 */ 


#include "include.h"
#include "engine.h"
#include "unify.h"

TAGGED make_atom(str,w)
    char *str;
    worker *w;
{
    register char *cp,c;
    atom res;
    register int len;
    BOOL seen_alpha  = FALSE;
    BOOL seen_symbol = FALSE;
    BOOL has_dquote  = FALSE;
    BOOL has_squote  = FALSE;
    BOOL has_special = FALSE;

    res = (atom) aligned_atom_alloc(sizeof(struct atom),w);

    for(cp = str, len = 0 ;c = *cp++ ; len++)
      {
	if(c == '\'')
	  has_squote =  has_special = TRUE;
	else if  (IsLowerChar(c) || IsUpperChar(c) || IsDigitChar(c) || c=='_')
	    seen_alpha = TRUE;
	else if (IsSymbolChar(c))
	    seen_symbol = TRUE;
	else has_special = TRUE;
      }

    has_dquote = (!has_special & !seen_alpha);
    has_special |= (seen_alpha==seen_symbol);


    if (has_special && !has_squote &&
	((str[0] == '!' && str[1] == 0) ||
	 (str[0] == ';' && str[1] == 0) ||
	 (str[0] == '[' && str[1] == ']' && str[2] == 0) ||
	 (str[0] == '{' && str[1] == '}' && str[2] == 0)))
      {
	has_special=FALSE;
	has_squote=TRUE;
      }
    else if(!has_special &&
	    (str[0] == '_' ||
	     IsUpperChar(str[0]) ||
	     IsDigitChar(str[0]) ||
	     (str[0] == '.' && str[1] == 0) ||
	     (str[0] == '*' && str[1] == '/')))
      has_special = TRUE;

    res->pname = (char *) atom_alloc((sizeof(char) * (len + 1)) +
				     (sizeof(TAGGED) - (sizeof(char) *
							(len + 1)) %
				      sizeof(TAGGED)),w);

    (void) strcpy(res->pname,str);

    if (has_special)
      res->mode = Make_Integer(1);
    else if (has_dquote)
      res->mode = Make_Integer(2);
    else if (has_squote)
      res->mode = Make_Integer(4);
    else
      res->mode = Make_Integer(0);

    return Tagify(DeOffsetAtom(res), ATM);
}

TAGGED make_float(w,val)
    worker *w;
    double val;
{
    register TAGGED *f, *p;

    f = (TAGGED *) &val;
    p = (TAGGED *) w->heap_top;

    p[0] = MakeDynBoxSize(FLOATSIZE);
    p[1] = f[0];
    p[2] = f[1];
    p[3] = MakeDynBoxSize(FLOATSIZE);

    w->heap_top += FLOATSIZE;

    return Tagify(p,FLT);
}

TAGGED make_atomspace_float(v,w)
    double v;
    worker *w;
{
    TAGGED  *res, *f;

    f = (TAGGED *) &v;
    res = (TAGGED *) atom_alloc(FLOATSIZE * sizeof(TAGGED),w);

    res[0] = MakeStatBoxSize(FLOATSIZE);
    res[1] = f[0];
    res[2] = f[1];
    res[3] = MakeStatBoxSize(FLOATSIZE);

    return Tagify(res,FLT);
}

double get_float(t)
    TAGGED t;
{
    double res;
    register TAGGED *p = (TAGGED *) &res;
    register TAGGED *f = RemoveTag(t,FLT);
    
    p[0] = f[1];
    p[1] = f[2];

    return res;
}


TAGGED make_string_list(w,str)
    char *str;
    worker *w;
{
    register TAGGED res;
    
    if(*str == '\0') return atom_nil;

    Make_LST(w->heap_top, res);
    PushOnHeap(w->heap_top, Make_Integer((int) *str));
    str++;

    for( ; *str != '\0' ; str++ ) {
	PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));
	PushOnHeap(w->heap_top, Make_Integer((int) *str));
    }
    PushOnHeap(w->heap_top,atom_nil);

    return res;
}
