/*    File:	 sun.h  (~bevemyr/Luther2/SharedEmulator/sun.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Jul 21 11:59:09 1992
 *    Purpose:   Sun specific stuff.
 */ 

#ifdef SUN

#define MAXSEMOPS 20

/* The code for swam_il() is copied from muse.14.06 by Roland Karlsson
   at SICS */

#ifdef __GNUC__
#ifdef SEMILOCK

#define swap_il(adr,reg) ({ int _ret; _ret = (int *) *adr; *adr = reg; _ret; })

#else

#define swap_il(adr,reg)					          \
({ int _ret;							          \
   asm volatile ("swap %1,%0"					          \
	: "=r" (_ret), "=m" (*(adr))	/* Output %0,%1 */	          \
	: "m"  (*(adr)), "0" (reg));	/* Input (%2),%0 */	          \
   _ret;							          \
})                                                              

#endif
#endif /* __GNUC__ */

extern char mmap_filename[];
extern char *mmap_global PROTO((long));
extern void remove_shared_memory PROTO((void));

#endif /* SUN */

