/*    File:	 sun.c  (~bevemyr/Luther2/SharedEmulator/sun.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Jul 21 11:59:36 1992
 *    Purpose:   Sun specific definitions.
 */ 

#include "include.h"

#ifdef SUN

#include "sun.h"
#include "unix.h"

#ifdef SHARED

char mmap_filename[MAXPATHLEN];

#ifdef HAS_SHMGET

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

static int shmid;

char *mmap_global(globalsize)
    long globalsize;
{
    char *globalstart = (char *) 0x02000000L;

    printf("globalsize = %d\n", globalsize);

    globalsize +=  (globalsize % getpagesize() == 0 ? 0 :
		    getpagesize() - globalsize % getpagesize());

    printf("globalsize = %d\n", globalsize);
    

    if((shmid = shmget(IPC_PRIVATE, globalsize, 200 | 400 | IPC_CREAT))==-1)
      {
	perror("can't get shared memory");
	luther_exit(1);
      }

    if(shmat(shmid, globalstart, 0) == -1) {
      perror("can't at shared memory");
      luther_exit(1);
    }
    
    return globalstart;
}

void remove_shared_memory()
{
    if(shmctl(shmid, IPC_RMID, 0) == -1) {
	perror("can't remove shared memory");
    }
}

#else /* HAS_SHMGET */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/mman.h>

char *mmap_global(globalsize)
     long globalsize;
{
    int fd;
    char *buf;
    char *globalstart;
  
    get_mmap_filename(mmap_filename, globalsize);

    if ((fd = open(mmap_filename, O_RDWR | O_CREAT, 0666)) == -1) {
        perror("can't open paging file");
	luther_exit(1);
    }

    globalstart = (char *) 0x02000000L;

    if((((long) globalstart) + globalsize) & TAGMASK ) {
      FatalError("To much memory allocated, tag is nibbled\n");
    }

    if ((globalstart = (char *) mmap((long) globalstart, globalsize,
				     PROT_READ | PROT_WRITE,
				     MAP_SHARED | MAP_FIXED, fd, 0))
	== (caddr_t) -1) {
        perror("can't map shared memory");
	luther_exit(1);
    }

    close(fd);

    return globalstart;
}

void remove_shared_memory()
{
  unlink(mmap_filename);
  return;
}

#endif /* HAS_SHMGET */
#endif /* SHARED */
#endif /* SUN */

