/*    File:	 storage.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Sat May 25 15:41:26 1991
 *    Purpose:   Initfile for use of storage.c.
 */ 

#ifdef __GNUC__
#include <malloc.h>
#endif

#ifdef ALIGN_MALLOC /* ------------------------------ */

extern char *aligned_malloc PROTO((s32));
#define Malloc(c)                  aligned_malloc(c)

#else  /* ALIGN_MALLOC ------------------------------ */

#define Malloc(c)                  malloc(c)

#endif /* ALIGN_MALLOC ------------------------------ */

extern char *getenv();
#define GETENV(VALUE,NAME,DEFAULT) { char *cp;                            \
			             if (cp = getenv(NAME))               \
					 VALUE = atoi(cp);                \
				     else                                 \
					 VALUE = DEFAULT;                 \
				   } 

#define AlignTagged(I)           { I += (((I) % sizeof(TAGGED)) == 0 ? 0 :\
					 sizeof(TAGGED) -                 \
					 ((I) % sizeof(TAGGED))); }

#define AlignDouble(I)           { I += (((u32) (I)) % sizeof(double)==0 ?\
				         0 :                              \
					 sizeof(double) -                 \
					 ((u32)(I)) % sizeof(double)); }


#ifdef TIMESTAMP /* ------------------------------ */

#define InitHVA(S,V,W)           { V = *(S) = (TAGGED) BaseOffset(S);     \
			           *((S)+1) = (W)->time;                  \
				   HVAInitStat(W); }

#ifdef SHORT_SVA
#define LoadSVA(V,W)             { V = Tagify((TAGGED) &(V),SVA); }
#else
#define LoadSVA(V,W)             { V = Tagify((TAGGED) &(V),SVA);         \
			           *((&(V))+1) = (W)->time;               \
				   SVAInitStat(W); }

#endif /* SHORT_SVA */
#else /* TIMESTAMP  ------------------------------ */

#ifdef UNBOUND
#define InitHVA(S,V,W)           { *(S) = Tagify((W)->time,UVA);         \
				   V = (TAGGED) BaseOffset(S);}
#else
#define InitHVA(S,V,W)           { V = *(S) = (TAGGED) BaseOffset(S); }
#endif
#define LoadSVA(V,W)             { V = Tagify((TAGGED) &(V),SVA); }

#endif /* TIMESTAMP ------------------------------ */

#define LoadHVA(S,V,W)           { InitHVA(S,V,W); (S)+=VARSIZE; }

#ifdef UNBOUND
#define CreateHVA(S,W)           { register TAGGED foo;            \
				   InitHVA(S,foo,W); (S)+=VARSIZE; }
#else /* UNBOUND */
#define CreateHVA(S,W)           { InitHVA(S,*S,W); (S)+=VARSIZE; }
#endif /* UNBOUND */

#define Make_LST(H,L)            { L = Tagify(H,LST); }

#define Make_LST_S(H,S,To)       { To = Tagify(H,LST);                    \
                                   S = H;                                 \
			           H += 2*VARSIZE; }

#define Make_STR(H,S,F)          { S = Tagify(H,STR); PushOnHeapF(H,F); }

#define Make_STR_Alloc(H,S,To,F) { To = Tagify(H,STR);                    \
			           PushOnHeapF(H,F);                      \
			           S = H;                                 \
			           H += ArityOf(F)*VARSIZE;               \
			         }
			   

#ifdef NEW_READ

#define Make_STR_A(H,S,N,F)      Make_STR_Alloc(H,S,N,F)
#define Make_LST_A(H,S,L)        Make_LST_S(H,S,L)

#else  /* NEW_READ */

#define Make_STR_A(H,S,N,F)      Make_STR(H,N,F)
#define Make_LST_A(H,S,L)        Make_LST(H,L)

#endif /* NEW_READ */

#define PopOnHeap(H,T)           { *(H) = (T); (H) -= VARSIZE; }
#define PushOnHeap(H,T)          { *(H) = (T); (H)+=VARSIZE; }
#define PushOnHeap1(H,T)         { *(H) = (T); (H)+=1; }

#define PushOnHeapF(H,T)         { *(H) = (T); (H)+=FUNCSIZE; }

#define IsInHeap(T)              ((TagToPointer(T) > w->heap_start) &&    \
		                  (TagToPointer(T) < w->heap_end))

/* functions declared in storage.c */

extern void reset_heap PROTO((worker *));
extern void init_localstack PROTO((long, worker *));
extern void reset_backpatchheap PROTO((worker *));
extern heap *atom_alloc PROTO((unsigned long,worker *));
extern heap *aligned_atom_alloc PROTO((unsigned long,worker *));
extern heap *patch_alloc PROTO((unsigned long, worker *));
extern void init_temporary_registers PROTO((long, worker *));
extern void init_read_stack PROTO((long, worker *));
extern worker *init_global_memory PROTO((int));
extern void init_local_memory PROTO((worker *));

static worker *init_worker_global_storage PROTO((char *, int));

#ifdef ALIGN_DOUBLE

extern heap *float_atom_alloc PROTO((unsigned long,worker *));

#endif /* ALIGN_DOUBLE */

#ifdef PARALLEL
extern long worker_size;
#endif
extern long total_size;
