/*    File:	 statistics.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Jun 10 11:45:17 1991
 */ 

#ifdef STATISTICS
#define BuiltinCallStatistics w->stats->builtin_calls += 1
#define CallStatistics        w->stats->calls += 1
#define FailStatistics        w->stats->fails += 1
#ifdef TIMESTAMP
#define HVAInitStat(W)        (W)->stats->hva_init_count += 1     
#define SVAInitStat(W)        (W)->stats->sva_init_count += 1     
#endif
#ifdef LOCKING
#define LCKGrabStat(W)        (W)->stats->lock_grab += 1
#define LCKAttStat(W)         (W)->stats->lock_attempt += 1
#endif
#ifdef SWAP_BIND
#define SwapFailStat(W)       (W)->stats->swap_fail += 1
#endif
#else /* STATISTICS */
#define BuiltinCallStatistics 
#define CallStatistics 
#define FailStatistics 
#define HVAInitStat(W)
#define SVAInitStat(W)
#define LCKGrabStat(W)
#define LCKAttStat(W)
#define SwapFailStat(W) 
#endif /* STATISTICS */

#ifdef STAT_AWAIT
#define AwaitStat(W)          (W)->stats->await += 1;
#define AwaitCountStat(W)     (W)->stats->await_count += 1;
#else /* STAT_AWAIT */
#define AwaitStat(W)
#define AwaitCountStat(W)
#endif /* STAT_AWAIT */

extern BOOL luther_statistics PROTO((Argproto));
extern BOOL luther_statistics_n PROTO((Argproto));
extern BOOL luther_statistics_runtime PROTO((Argproto));
extern BOOL luther_statistics_gctime PROTO((Argproto));
extern BOOL luther_statistics_gcnr PROTO((Argproto));
extern BOOL luther_statistics_gcbytes PROTO((Argproto));
extern BOOL luther_statistics_walltime PROTO((Argproto));
extern BOOL luther_statistics_parallel_runtime PROTO((Argproto));
extern BOOL luther_statistics_memory PROTO((Argproto));
extern BOOL luther_statistics_global PROTO((Argproto));
extern BOOL luther_statistics_local PROTO((Argproto));
extern BOOL luther_statistics_trail PROTO((Argproto));
extern BOOL luther_statistics_code PROTO((Argproto));
extern BOOL luther_statistics_atom PROTO((Argproto));

void init_statistics PROTO((worker *w));

