/*    File:	 statistics.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Jun 10 11:23:07 1991
 */ 

#include "include.h"
#include "engine.h"
#include "unify.h"
#include "think.h"

/* statistics/0 */
BOOL luther_statistics(Arg)
    Argdecl;
{
  int currentusertime, currentsystime;
  
  unsigned long heapsize, localsize, trailsize, atomsize, backsize, code_size;
  
  heapsize = ((unsigned long) w->heap_end)-((unsigned long) w->heap_start);
  localsize = ((unsigned long) w->stack_end) -
              ((unsigned long) w->stack_start);
  trailsize = ((unsigned long) w->trail_end) -
              ((unsigned long) w->trail_start);
  atomsize = ((unsigned long) w->global->atom_end) -
             ((unsigned long) w->global->atom_start);
  backsize = ((unsigned long) w->global->patch_end) -
             ((unsigned long) w->global->patch_start);
  code_size = ((unsigned long) w->global->code_end) -
              ((unsigned long) w->global->code_start);
  
  currentusertime = usertime();
  currentsystime = systime();
  
  fprintf(currout,"memory(total)      %10lu bytes\n", heapsize + localsize +
	  trailsize + atomsize + backsize + code_size);
  fprintf(currout,"  global stack     %10lu bytes: %10lu in use, %10lu free\n",
	  heapsize, ((unsigned long) w->heap_top) -
	  ((unsigned long) w->heap_start), ((unsigned long) w->heap_end) -
	  ((unsigned long) w->heap_top));
  fprintf(currout,"  local stack      %10lu bytes: %10lu in use, %10lu free\n",
	  localsize, ((unsigned long) Get_Local_Stack_Top) -
	  ((unsigned long) w->stack_start), ((unsigned long) w->stack_end) -
	  ((unsigned long) Get_Local_Stack_Top));
  fprintf(currout,"  trail stack      %10lu bytes: %10lu in use, %10lu free\n",
	  trailsize, ((unsigned long) w->trail_top) -
	  ((unsigned long) w->trail_start), ((unsigned long) w->trail_end) -
	  ((unsigned long) w->trail_top));
  fprintf(currout,"  code stack       %10lu bytes: %10lu in use, %10lu free\n",
	  code_size, ((unsigned long) w->global->code_current) -
	  ((unsigned long) w->global->code_start),
	  ((unsigned long) w->global->code_end) -
	  ((unsigned long) w->global->code_current));
  fprintf(currout,"  atom stack       %10lu bytes: %10lu in use, %10lu free\n",
	  atomsize, ((unsigned long) w->global->atom_current) -
	  ((unsigned long) w->global->atom_start),
	  ((unsigned long) w->global->atom_end) -
	  ((unsigned long) w->global->atom_current));
  
  fprintf(currout,"\n");

  fprintf(currout,"%10.3f sec. in prolog\n",
	  (double) (currentusertime-w->stats->user_start_time)/1000);
  fprintf(currout,"%10.3f sec. user time\n", (double) (currentusertime)/1000);
  fprintf(currout,"%10.3f sec. system time\n",
	  (double) (currentsystime)/1000);
  fprintf(currout,"%10.3f sec. for %d garbage collections ",
	  (double) (w->stats->heap_gc_time)/1000, w->stats->heap_gc_nr);
  fprintf(currout,"which collected %d bytes\n", w->stats->heap_gc_bytes);
  
  fprintf(currout,"\n");

#ifdef PARALLEL
  if(w->pid == 0)
    {
      int i;

      for(i = 1 ; i <= w->global->active_workers ; i++) {
	fprintf(currout,"%10.3f sec. user time in worker nr %d\n",
		(double) (w[i].stats->current_user_time)/1000, i);
      }

      fprintf(currout,"\n");
    }
#endif /* PARALLEL */

#ifdef PARALLEL
#ifdef STAT_AWAIT
  if(w->pid == 0)
    {
      int i;

      for(i = 1 ; i <= w->global->active_workers ; i++) {
	fprintf(currout,"%10d await %10d count worker nr %d\n",
		w[i].stats->await, w[i].stats->await_count, i);
	w[i].stats->await = w[i].stats->await_count = 0;
      }

      fprintf(currout,"\n");
    }
#endif /* STAT_AWAIT */
#endif /* PARALLEL */

#ifdef UNIX
  fprintf(currout,"%10d page faults not requiring physical I/O\n",
	  pagefaults_no_io());
  fprintf(currout,"%10d page faults requiring physical I/O\n",
	  pagefaults_ph_io());
  
  fprintf(currout,"\n");
#endif /* UNIX */
  
#ifdef STATISTICS
  fprintf(currout,"%10d calls since prolog start\n", w->stats->calls);
  fprintf(currout,"%10d fails since prolog start\n", w->stats->fails);
  fprintf(currout,"%10d calls to builtin functions since prolog start\n",
	  w->stats->builtin_calls);
  fprintf(currout,"\n");
#ifdef TIMESTAMP
  fprintf(currout,"%10d variables has been initialized since prolog start\n",
	  w->stats->hva_init_count + w->stats->sva_init_count);
  fprintf(currout,"%10d heap variables \n",
	  w->stats->hva_init_count);
  fprintf(currout,"%10d stack variables\n",
	  w->stats->sva_init_count);
  fprintf(currout,"\n");
#endif
#ifdef LOCKING
  fprintf(currout,"%10d attempted locks\n", w->stats->lock_attempt);
  fprintf(currout,"%10d grabbed locks\n", w->stats->lock_grab);
  fprintf(currout,"\n");
#endif
#ifdef SWAP_BIND
  fprintf(currout,"%10d failed bindings\n", w->stats->swap_fail);
  fprintf(currout,"\n");
#endif
#endif


  return TRUE;
}

#ifdef PARALLEL
/* statistics/1 */
BOOL luther_statistics_n(Arg)
    Argdecl;
{
  register TAGGED Worker;
  int work;
  unsigned long heapsize, localsize, trailsize, atomsize, backsize, code_size;

  DerefNLL(Worker,Xw(0));

  if(!IsNUM(Worker) || (w->pid != 0)) return FALSE;

  work = GetNumber(Worker);
  if((work > w->global->active_workers) ||
     (work < 0))
    return FALSE;

  heapsize = ((unsigned long) w[work].heap_end)-
             ((unsigned long) w[work].heap_start);
  localsize = ((unsigned long) w[work].stack_end) -
              ((unsigned long) w[work].stack_start);
  trailsize = ((unsigned long) w[work].trail_end) -
              ((unsigned long) w[work].trail_start);

  fprintf(currout,"memory(total)      %10lu bytes\n", heapsize + localsize +
	  trailsize + atomsize + backsize + code_size);
  fprintf(currout,"  global stack     %10lu bytes: %10lu in use, %10lu free\n",
	  heapsize, ((unsigned long) w[work].heap_top) -
	  ((unsigned long) w[work].heap_start),
	  ((unsigned long) w[work].heap_end) -
	  ((unsigned long) w[work].heap_top));
  fprintf(currout,"  local stack      %10lu bytes: %10lu in use, %10lu free\n",
	  localsize, ((unsigned long) Get_Local_Stack_Top) -
	  ((unsigned long) w[work].stack_start),
	  ((unsigned long) w[work].stack_end) -
	  ((unsigned long) Get_Local_Stack_Top));
  fprintf(currout,"  trail stack      %10lu bytes: %10lu in use, %10lu free\n",
	  trailsize, ((unsigned long) w[work].trail_top) -
	  ((unsigned long) w[work].trail_start),
	  ((unsigned long) w[work].trail_end) -
	  ((unsigned long) w[work].trail_top));
  fprintf(currout,"\n");

#ifdef STATISTICS
  fprintf(currout,"%10d calls since prolog start\n", w[work].stats->calls);
  fprintf(currout,"%10d fails since prolog start\n", w[work].stats->fails);
  fprintf(currout,"%10d calls to builtin functions since prolog start\n",
	  w[work].stats->builtin_calls);
  fprintf(currout,"\n");
#ifdef TIMESTAMP
  fprintf(currout,"%10d variables has been initialized since prolog start\n",
	  w[work].stats->hva_init_count + w[work].stats->sva_init_count);
  fprintf(currout,"%10d heap variables \n",
	  w[work].stats->hva_init_count);
  fprintf(currout,"%10d stack variables\n",
	  w[work].stats->sva_init_count);
  fprintf(currout,"\n");
#endif
#ifdef LOCKING
  fprintf(currout,"%10d attempted locks\n", w[work].stats->lock_attempt);
  fprintf(currout,"%10d grabbed locks\n", w[work].stats->lock_grab);
  fprintf(currout,"\n");
#endif
#ifdef SWAP_BIND
  fprintf(currout,"%10d failed bindings\n", w[work].stats->swap_fail);
  fprintf(currout,"\n");
#endif
#endif

  return TRUE;
}

#else /* PARALLEL */
BOOL luther_statistics_n(Arg)
    Argdecl;
{
  return luther_statistics(Arg);
}
#endif /* PARALLEL */

/* $statistics_runtime/1 */
BOOL luther_statistics_runtime(Arg)
    Argdecl;
{
    TAGGED X0, lst;
    int currtime;

    DerefNLL(X0,Xw(0));

    currtime = usertime();

    Make_LST(w->heap_top,lst);

    PushOnHeap(w->heap_top,
	       Make_Integer(currtime - w->stats->user_start_time));
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top, Make_Integer(currtime - w->stats->user_last_time));
    PushOnHeap(w->heap_top, atom_nil);

    w->stats->user_last_time = currtime;

    return unify(X0,lst,w);
}

/* $statistics_gctime/1 */
BOOL luther_statistics_gctime(Arg)
    Argdecl;
{
    TAGGED X0, lst;
    int currtime;

    DerefNLL(X0,Xw(0));

    currtime = w->stats->heap_gc_time;

    Make_LST(w->heap_top,lst);

    PushOnHeap(w->heap_top, Make_Integer(currtime));
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top, Make_Integer(currtime-w->stats->user_last_gctime));
    PushOnHeap(w->heap_top, atom_nil);

    w->stats->user_last_gctime = currtime;

    return unify(X0,lst,w);
}

/* $statistics_gcnr/1 */
BOOL luther_statistics_gcnr(Arg)
    Argdecl;
{
    TAGGED X0, lst;
    int currtime;

    DerefNLL(X0,Xw(0));

    currtime = w->stats->heap_gc_nr;

    Make_LST(w->heap_top,lst);

    PushOnHeap(w->heap_top, Make_Integer(currtime));
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top, Make_Integer(currtime-w->stats->user_last_gcnr));
    PushOnHeap(w->heap_top, atom_nil);

    w->stats->user_last_gcnr = currtime;

    return unify(X0,lst,w);
}

/* $statistics_gcbytes/1 */
BOOL luther_statistics_gcbytes(Arg)
    Argdecl;
{
    TAGGED X0, lst;
    int currtime;

    DerefNLL(X0,Xw(0));

    currtime = w->stats->heap_gc_bytes;

    Make_LST(w->heap_top,lst);

    PushOnHeap(w->heap_top, Make_Integer(currtime));
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top, Make_Integer(currtime-w->stats->user_last_gcbytes));
    PushOnHeap(w->heap_top, atom_nil);

    w->stats->user_last_gcbytes = currtime;

    return unify(X0,lst,w);
}

/* $statistics_walltime/1 */
BOOL luther_statistics_walltime(Arg)
    Argdecl;
{
    TAGGED X0, lst, t1,t2,t3,t4;
    double currtime;

    DerefNLL(X0,Xw(0));

    currtime = walltime();

    /* floats are stored on the heap, we must create them first */
    t1 = make_float(w,currtime - w->stats->user_start_walltime);
    t2 = make_float(w,currtime - w->stats->user_last_walltime);
#ifdef PARALLEL
    t3 = make_float(w,w->stats->in_parallel_walltime);
    t4 = make_float(w,w->stats->in_parallel_walltime -
		      w->stats->in_parallel_walltime_last);
    w->stats->in_parallel_walltime_last = w->stats->in_parallel_walltime;
#else
    t3 = Make_Integer(0);
    t4 = Make_Integer(0);
#endif     

    Make_LST(w->heap_top,lst);

    PushOnHeap(w->heap_top,t1);
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top,t2);
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top,t3);
    PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

    PushOnHeap(w->heap_top,t4);
    PushOnHeap(w->heap_top, atom_nil);

    w->stats->user_last_walltime = currtime;

    return unify(X0,lst,w);
}

/* $statistics_parallel_runtime/1 */
BOOL luther_statistics_parallel_runtime(Arg)
    Argdecl;
{
    TAGGED X0, lst;
    int currtime,i;

#ifdef PARALLEL

    if(w->pid != 0) return FALSE;
    
    DerefNLL(X0,Xw(0));

    currtime = usertime();

    Make_LST(w->heap_top,lst);

    for(i=1 ; i < w->global->active_workers ; i++)
      {
	PushOnHeap(w->heap_top, Make_Integer(w[i].stats->current_user_time));
	PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));
      }

    if (w->global->active_workers != 0)
      {
	PushOnHeap(w->heap_top, Make_Integer(w[i].stats->current_user_time));
	PushOnHeap(w->heap_top, atom_nil);
      }
    else
      {
	lst = atom_nil;
      }
    return unify(X0,lst,w);

#else

    return FALSE;

#endif /* PARALLEL */
}

/* $statistics_memory/1 */
BOOL luther_statistics_memory(Arg)
    Argdecl;
{
  TAGGED X0, lst;
  unsigned long heapsize, localsize, trailsize, atomsize, backsize, code_size;
  
  DerefNLL(X0,Xw(0));
  
  heapsize = ((unsigned long) w->heap_end) - ((unsigned long) w->heap_start);
  localsize = ((unsigned long) w->stack_end) -
              ((unsigned long) w->stack_start);
  trailsize = ((unsigned long) w->trail_end) - 
              ((unsigned long) w->trail_start);
  atomsize = ((unsigned long) w->global->atom_end) - 
             ((unsigned long) w->global->atom_start);
  backsize = ((unsigned long) w->global->patch_end) - 
             ((unsigned long) w->global->patch_start);
  code_size = ((unsigned long) w->global->code_end) - 
              ((unsigned long) w->global->code_start);
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top, Make_Integer(heapsize + localsize +
				       trailsize + atomsize +
				       backsize + code_size));
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

  PushOnHeap(w->heap_top, Make_Integer(0));
  PushOnHeap(w->heap_top, atom_nil);

  return unify(X0,lst,w);
}

/* $statistics_global/1 */
BOOL luther_statistics_global(Arg)
    Argdecl;
{
  TAGGED X0, lst, t1, t2;
  
  DerefNLL(X0,Xw(0));

  t1 = Make_Integer(((unsigned long) w->heap_top) -
		    ((unsigned long) w->heap_start));

  t2 = Make_Integer(((unsigned long) w->heap_end) -
		    ((unsigned long) w->heap_top));
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top, t1);
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE, LST));

  PushOnHeap(w->heap_top, t2);
  PushOnHeap(w->heap_top, atom_nil);

  return unify(X0,lst,w);
}

  
/* $statistics_local/1 */
BOOL luther_statistics_local(Arg)
    Argdecl;
{
  TAGGED X0, lst;
  
  DerefNLL(X0,Xw(0));
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top, Make_Integer(((unsigned long) Get_Local_Stack_Top) -
				       ((unsigned long) w->stack_start)));
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

  PushOnHeap(w->heap_top, Make_Integer(((unsigned long) w->stack_end) -
				       ((unsigned long) Get_Local_Stack_Top)));
  PushOnHeap(w->heap_top, atom_nil);
	     
  return unify(X0,lst,w);
}

/* $statistics_trail/1 */
BOOL luther_statistics_trail(Arg)
    Argdecl;
{
  TAGGED X0, lst;
  
  DerefNLL(X0,Xw(0));
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top, Make_Integer(((unsigned long) w->trail_top) -
				       ((unsigned long) w->trail_start)));
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

  PushOnHeap(w->heap_top, Make_Integer(((unsigned long) w->trail_end) -
				       ((unsigned long) w->trail_top)));
  PushOnHeap(w->heap_top, atom_nil);

  return unify(X0,lst,w);
}

/* $statistics_code/1 */
BOOL luther_statistics_code(Arg)
    Argdecl;
{
  TAGGED X0, lst;
  
  DerefNLL(X0,Xw(0));
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top,
	     Make_Integer(((unsigned long) w->global->code_current) -
			  ((unsigned long) w->global->code_start)));
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

  PushOnHeap(w->heap_top,
	     Make_Integer(((unsigned long) w->global->code_end) -
			  ((unsigned long) w->global->code_current)));
  PushOnHeap(w->heap_top, atom_nil);

  return unify(X0,lst,w);
}


/* $statistics_atom/1 */
BOOL luther_statistics_atom(Arg)
    Argdecl;
{
  TAGGED X0, lst;
  
  DerefNLL(X0,Xw(0));
  
  Make_LST(w->heap_top, lst);

  PushOnHeap(w->heap_top,
	     Make_Integer(((unsigned long) w->global->atom_current) -
			  ((unsigned long) w->global->atom_start)));
  PushOnHeap(w->heap_top, Tagify(w->heap_top+VARSIZE,LST));

  PushOnHeap(w->heap_top,
	     Make_Integer(((unsigned long) w->global->atom_end) -
			  ((unsigned long) w->global->atom_current)));
  PushOnHeap(w->heap_top, atom_nil);

  return unify(X0,lst,w);
}

void init_statistics(w)
    worker *w;
{
    w->stats->user_start_time = usertime();
    w->stats->user_last_time = w->stats->user_start_time;
    w->stats->sys_start_time = w->stats->user_start_time;

    w->stats->user_start_walltime = walltime();
    w->stats->user_last_walltime = w->stats->user_start_walltime;

    w->stats->calls = 0;
    w->stats->fails = 0;
    w->stats->builtin_calls = 0;

    w->stats->heap_gc_nr = 0;
    w->stats->heap_gc_bytes = 0;
    w->stats->heap_gc_time = 0;

#ifdef PARALLEL
    w->stats->in_parallel_walltime = 0.0;
    w->stats->in_parallel_walltime_last = 0.0;
#ifdef STAT_AWAIT
    w->stats->await = 0;
    w->stats->await_count;
#endif /* STAT_AWAIT */    
#endif /* PARALLEL */

#ifdef TIMESTAMP
    w->stats->hva_init_count = 0;
    w->stats->sva_init_count = 0;
#endif

#ifdef LOCKING
    w->stats->lock_grab = 0;
    w->stats->lock_attempt = 0;
#endif

#ifdef SWAP_BIND
    w->stats->swap_fail = 0;
#endif
}
