/*    File:	 signal.c  (~bevemyr/Luther2/SharedEmulator/signal.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Jun 29 12:38:26 1993
 *    Purpose:   Takes care of signal handeling.
 */ 




#include "include.h"
#include "debug.h"
#include <signal.h>
#include "signal.h"
#include "engine.h"

static int is_in_interrupt = 0;

#define BUFSIZE 255
#define SH_Print1(String) { sprintf(tmpout,String);signal_writestring(tmpout);}

static char readbuffer[BUFSIZE];
static int c_count, c_max;

void init_my_getchar()
{
  c_count = c_max = 0;
}

int my_getchar()
{
  if(c_count == c_max)
    {
      c_max = read(1,readbuffer,BUFSIZE);
      c_count = 1;
      return (int) readbuffer[0];
    }
  else
    {
      return (int) readbuffer[c_count++];
    }
}

void readstring(x)
char *x;
{
   int i = 0;

   init_my_getchar();

   x[0] = my_getchar();
   while((x[i] != '\n') && (x[i] != EOF) && (i < 255)) {
	if(x[i] == 8) {
	   if(i>0) i--;
	} else {
	   i++;
	}
	x[i] = my_getchar();
   }
   x[++i] = 0;
}

void signal_writestring(x)
     char *x;
{
  register int size;

  for(size=0 ; x[size] != (char) 0 ; size++);
  
  write(0,x,size);
}

void install_sigvec(sig,new)
     int sig;
     void (*new)();
{
  struct sigvec newsig;

  bzero((char *) &newsig, sizeof(newsig));
  
#ifdef SEQUENT
  newsig.sv_handler = (int (*)()) new;
#else
  newsig.sv_handler = new;
#endif /* SEQUENT */

#ifdef HP_UX
  sigvector(sig, &newsig, NULL);
#else 
  sigvec(sig, &newsig, NULL);
#endif
  return;
}

void interrupt_handler(sig)
     int sig;
{
  char tmp[255], tmpout[255];

  if (is_in_interrupt == 1)
    {
      return;
    }
  else
    {
      is_in_interrupt = 1;
    }

#ifdef PARALLEL
  if(worker_nr != 0) 
    {
      if(worker_set->global->debugsig == worker_nr)
	{
	  SH_Print1("{The debugger will first creep -- ");
          SH_Print1("showing everyting}\n");
	  debugflag = TRUE;
	  debugmode = D_CREEP;
	  worker_set->global->debugsig = 0;	  
	}
	  
      is_in_interrupt = 0;
      return;
    }
#endif

 start:
  SH_Print1("\nProlog interruption (h for help)? ");
  fflush(currerr);

  readstring(tmp);

  switch(tmp[0])
    {
    case 'a':
      worker_set->global->interrupt_code = abort_code;
      AddEvent(EVENT_INTERRUPT);
      SH_Print1("{Execution will abort at next call}\n");
      is_in_interrupt = 0;
      return;
      break;

    case 'c':
      is_in_interrupt = 0;
      return;

    case 'd':
#ifdef DEBUG
#ifdef PARALLEL
    { int i;
      i = atoi(&(tmp[1]));
      if (i == 0)
	{
	  SH_Print1("{The debugger will first creep -- showing everyting}\n");
	  debugflag = TRUE;
	  debugmode = D_CREEP;
	}
      else if (i > worker_set->global->active_workers)
	{
	  SH_Print1("No such worker\n");
	  goto error;
	}
      else
	{
	  worker_set->global->debugsig = i;
	  (void) kill(child_pid[i-1],SIGINT);
	}
    }
#else
    SH_Print1("{The debugger will first creep -- showing everyting}\n");
    debugflag = TRUE;
    debugmode = D_CREEP;
#endif
#endif
    is_in_interrupt = 0;
    return;

    case 'e':
      luther_exit(1);

    case '?':
    case 'h':
    default:
    error:
      SH_Print1("\nProlog interrupt options: \n");
      SH_Print1("    a         abort        - abort execution\n");
      SH_Print1("    c         continue     - do nothing\n");
#ifdef PARALLEL
      SH_Print1("    d <nr>    debug        - enter wam-debugger for worker <nr>\n");
#else
      SH_Print1("    d         debug        - enter wam-debugger\n");
#endif
      SH_Print1("    e         exit         - cause exit\n");
      SH_Print1("    h         help         - get this list\n");

      goto start;
  }

  return;
}
