/*    File:	 sequent.h  (~bevemyr/Luther2/SharedEmulator/sequent.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Oct  5 13:51:27 1992
 *    Purpose:   Sequent specific stuff.
 */ 

#ifdef SEQUENT

#define MAXSEMOPS 10

/* The code for swam_il() is copied from muse.14.06 by Roland Karlsson
   at SICS */

#ifdef __GNUC__
#ifdef SEMILOCK

#define swap_il(adr,reg) ({ int _ret; _ret = (int *) *adr; *adr = reg; _ret; })

#else

#define swap_il(adr,reg)					\
({								\
   long _ret;							\
   asm volatile ("xchgl %0,%1"					\
	: "=q" (_ret), "=m" (*(adr))	/* Output %0,%1 */	\
	: "m"  (*(adr)), "0"  (reg));	/* Input (%2),%0 */	\
   _ret;							\
})

#endif
#endif /* __GNUC__ */

extern char mmap_filename[];

extern char* mmap_global PROTO((long));

#endif /* SEQUENT */
