/*    File:	 semaphore.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Aug 21 15:08:03 1991
 *    Purpose:   
 */ 

#ifdef SEMAPHORE

typedef enum {
    SEMA_DONE,
    SEMA_EVENT,
    SEMA_IDLE
} semaphores;

#ifdef SPIN_LOCK

#define SEMAPHORE_LOCK 0xffffffff

#define Lock_Semaphore(Val,Sem)                                      \
{                                                                    \
  register volatile u32 *sl_pos = Sem;                               \
  do                                                                 \
    {                                                                \
      if((Val = swap_il(sl_pos,SEMAPHORE_LOCK)) != SEMAPHORE_LOCK)   \
	{                                                            \
	  break;                                                     \
	}                                                            \
      while(*sl_pos == SEMAPHORE_LOCK);                              \
    } while(TRUE);                                                   \
}

#define GrabSemaphore(S,N,W)                                         \
{                                                                    \
  register u32 s_val;                                                \
  register volatile u32 *s_pos;                                      \
                                                                     \
  s_pos = &(W->global->semaphores[S]);                               \
  while(TRUE) {                                                      \
    while((s_val = *s_pos) == SEMAPHORE_LOCK);                       \
    if(s_val >= N) {                                                 \
      Lock_Semaphore(s_val,s_pos);                                   \
      if(s_val >= N) {                                               \
	*s_pos = s_val - N;                                          \
	break;                                                       \
      } else {                                                       \
	*s_pos = s_val;                                              \
      }                                                              \
    }                                                                \
  }                                                                  \
}

#define DropSemaphore(S,N,W)                                         \
{                                                                    \
  register u32 s_val;                                                \
  register u32 *s_pos;                                               \
                                                                     \
  s_pos = &(W->global->semaphores[S]);                               \
  Lock_Semaphore(s_val,s_pos);                                       \
  *s_pos = s_val + N;                                                \
}

#else /* SPIN_LOCK */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

extern int sem, asem;
extern struct sembuf sdropop[], *gasem, *dasem;

#define GrabSemaphore(S,N,W) { FooSemaphore(S,-1*(N),W);                   \
			     } 

#define DropSemaphore(S,N,W) { FooSemaphore(S,N,W);                        \
			     } 

#define FooSemaphore(S,N,W)  { sdropop[0].sem_num = S ;                    \
                               sdropop[0].sem_op = N;                      \
			       if(semop(sem, sdropop, 1)==-1) {            \
			         perror("couldn't drop/grab semaphore");   \
			       }                                           \
		             }

#define ActivateAllWorkers(N)                                              \
{                                                                          \
  register s32 tmpn = N;                                                   \
  if(tmpn > MAXSEMOPS)                                                     \
    {                                                                      \
      register s32 aaw_i;                                                  \
      for(aaw_i = 0 ; (tmpn - aaw_i) > MAXSEMOPS ;  aaw_i += MAXSEMOPS)    \
	{                                                                  \
	  if(semop(asem, &(dasem[aaw_i]), MAXSEMOPS) == -1)                \
	    perror("couldn't activate workers");                           \
	}                                                                  \
      if(semop(asem, &(dasem[aaw_i]), tmpn - aaw_i) == -1)                 \
	perror("couldn't activate workers");                               \
    }                                                                      \
  else                                                                     \
    {                                                                      \
      if(semop(asem, dasem, tmpn) == -1)                                   \
	perror("couldn't activate workers");                               \
    }                                                                      \
}
#define GrabActivateSem(N)                                                 \
{                                                                          \
  if(semop(asem, &(gasem[N]), 1) == -1)                                    \
    {                                                                      \
      if (errno == EINTR)                                                  \
	{                                                                  \
	  while(1)                                                         \
	    {                                                              \
	      if(semop(asem, &(gasem[N]), 1) == -1)                        \
		{                                                          \
		  if(errno == EINTR)                                       \
		    continue;                                              \
		  else {                                                   \
		    perror("couldn't grab activate sem");                  \
		    break;                                                 \
		  }                                                        \
		}                                                          \
	      else                                                         \
		break;                                                     \
	    }                                                              \
	}                                                                  \
      else                                                                 \
	perror("couldn't grab activate sem");                              \
    }                                                                      \
}
#endif /* SPIN_LOCK */

#else /* SEMAPHORES */

#define GrabSemaphore(S,N,W)   
#define DropSemaphore(S,N,W) 
#define ActivateAllWorkers(N)
#define GrabActivateSem(N)

#endif /* SEMAPHORES */

#define ActivateWorkers(W)                                                 \
{                                                                          \
    double starttime = walltime();                                         \
                                                                           \
    ActivateAllWorkers((W)->global->active_workers);                       \
    GrabSemaphore(SEMA_DONE,(W)->global->active_workers,W);                \
                                                                           \
    (W)->stats->in_parallel_walltime += walltime()-starttime;              \
}

extern void init_semaphores PROTO((worker *, s32));
extern void remove_semaphores PROTO((void));




