/*    File:	 semaphore.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Aug 21 15:07:54 1991
 */ 

#include "include.h"

#ifdef SEMAPHORE

#ifdef SPIN_LOCK

void init_semaphores(w,n)
    worker *w;
    s32 n;
{
    register int i;

    for(i = 0 ; i < MAX_SEM_NR ; i++) {
	w->global->semaphores[i] = 0;
    }

}

void remove_semaphores()
{
}

#else /* SPIN_LOCK */

int sem, asem;

struct sembuf sdropop[1];
struct sembuf *gasem, *dasem;

void init_semaphores(w,n)
    worker *w;
    s32 n;
{
#ifdef SEQUENT
  union semun {
    int val;
    struct semid_ds *buf;
    ushort *array;
  } arg;
#else
  union semun arg;
#endif
    
  int i;
  
  arg.val = 0;
  
  sdropop[0].sem_num = 0;
  sdropop[0].sem_op = 1;
  sdropop[0].sem_flg = 0;

  gasem = (struct sembuf *) malloc(sizeof(struct sembuf)*n);
  dasem = (struct sembuf *) malloc(sizeof(struct sembuf)*n);

  for(i = 0 ; i < n ; i++) {
      gasem[i].sem_num = i;
      gasem[i].sem_op = -1;
      gasem[i].sem_flg = 0;
      dasem[i].sem_num = i;
      dasem[i].sem_op = 1;
      dasem[i].sem_flg = 0;
  }
  
  if((sem = semget(IPC_PRIVATE, MAX_SEM_NR, 200)) == -1)
    {
      perror("semget couldn't initialize semaphores");
      luther_exit(0);
    }

  for(i = 0; i != MAX_SEM_NR ; i++)
    {
      if(semctl(sem, i, SETVAL, arg) == -1)
	{
	  perror("semctl couldn't initialize semaphores");
	  luther_exit(0);
	}
    }

  if((asem = semget(IPC_PRIVATE, n, 200)) == -1)
    {
      perror("semget couldn't initialize activate semaphores");
      luther_exit(0);
    }

  for(i = 0; i != n ; i++)
    {
      if(semctl(asem, i, SETVAL, arg) == -1)
	{
	  perror("semctl couldn't initialize activate semaphores");
	  luther_exit(0);
	}
    }
}

void remove_semaphores()
{
  if(semctl(sem, 0, IPC_RMID, 0) == -1)
    {
      perror("semctl remove semaphores");
    }
  if(semctl(asem, 0, IPC_RMID, 0) == -1)
    {
      perror("semctl remove semaphores");
    }
}
#endif /* SPIN_LOCK */
#else /* SEMAPHORE */
void init_semaphores(w,n)
    worker *w;
    s32 n;
{}
void remove_semaphores()
{}
#endif /* SEMAPHORE */
