%{
/*    File:	 parser.l  (~bevemyr/Luther/akl/parser.l)
 *    Author:	 Johan Bevemyr
 *    Created:	 Fri May 24 16:31:54 1991
 *    Purpose:   A lex grammar for WAM-code in Luther.
 */ 

#include "parser.tab.h"

#include <stdio.h>

#ifdef THINK_C
YY_DECL;
#endif


%}

%%
"switch_on_term"		{ return Switch_On_Term; }
"switch_on_constant"		{ return Switch_On_Constant; }
"switch_on_structure"		{ return Switch_On_Structure; }
	
"try"				{ return Try; }
"retry"				{ return Retry; }
"trust"				{ return Trust; }
"try_me_else"			{ return Try_Me_Else; }
"retry_me_else"			{ return Retry_Me_Else; }
"trust_me"			{ return Trust_Me; }
	
"choice_x"			{ return Choice_X; }
"choice_y"			{ return Choice_Y; }
"cut"				{ return Cut; }
"cut_x"				{ return Cut_X; }
"cut_y"				{ return Cut_Y; }
"inline"                        { return Inline; }
"builtin"			{ return Builtin; }
"meta_call"			{ return Meta_Call; }
"meta_execute"			{ return Meta_Execute; }
	
"require"                       { return Require; }
"require_using"                 { return Require_Using; }
"allocate"			{ return Allocate; }
"allocate2"			{ return Allocate2; }
"deallocate"			{ return Deallocate; }
"init"                          { return Init; }
"call"				{ return Call; }
"execute"			{ return Execute; }
"proceed"			{ return Proceed; }
"fail"				{ return Fail; }
	
"get_x_variable"		{ return Get_X_Variable; }
"get_y_variable"		{ return Get_Y_Variable; }
"get_y_first_value"		{ return Get_Y_First_Value; }
"get_x_value"			{ return Get_X_Value; }
"get_y_value"			{ return Get_Y_Value; }
"get_constant"			{ return Get_Constant; }
"get_nil"			{ return Get_Nil; }
"get_structure"			{ return Get_Structure; }
"get_list"			{ return Get_List; }
"get_constant_x0"		{ return Get_Constant_X0; }
"get_nil_x0"			{ return Get_Nil_X0; }
"get_structure_x0"		{ return Get_Structure_X0; }
"get_list_x0"			{ return Get_List_X0; }

"put_x_void"			{ return Put_X_Void; }
"put_y_void"			{ return Put_Y_Void; }
"put_x_variable"		{ return Put_X_Variable; }
"put_y_variable"		{ return Put_Y_Variable; }
"put_x_value"			{ return Put_X_Value; }
"put_y_value"			{ return Put_Y_Value; }
"put_x_unsafe_value"		{ return Put_X_Unsafe_Value; }
"put_y_unsafe_value"		{ return Put_Y_Unsafe_Value; }
"put_constant"			{ return Put_Constant; }
"put_nil"			{ return Put_Nil; }
"put_structure"			{ return Put_Structure; }
"put_list"			{ return Put_List; }
	
"unify_void"			{ return Unify_Void; }
"unify_x_variable"		{ return Unify_X_Variable; }
"unify_y_variable"		{ return Unify_Y_Variable; }
"unify_y_first_value"		{ return Unify_Y_First_Value; }
"unify_x_value"			{ return Unify_X_Value; }
"unify_y_value"			{ return Unify_Y_Value; }
"unify_x_local_value"		{ return Unify_X_Local_Value; }
"unify_y_local_value"		{ return Unify_Y_Local_Value; }
"unify_constant"		{ return Unify_Constant; }
"unify_nil"			{ return Unify_Nil; }
"unify_structure"		{ return Unify_Structure; }
"unify_list"			{ return Unify_List; }
"new_unlock"                    { return New_Unlock; }

changequote([,])
ifdef([NEW_READ],[
"read_list_top"			{ return Read_List_Top; }
"read_struct_top"		{ return Read_Struct_Top; }
"read_list"			{ return Read_List; }
"read_struct"			{ return Read_Struct; }
"read_list_tail"		{ return Read_List_Tail; }
"read_struct_tail"		{ return Read_Struct_Tail; }
"unify_constant_up"		{ return Unify_Constant_Up; }
"unify_x_variable_up"		{ return Unify_X_Variable_Up; }
"unify_y_variable_up"		{ return Unify_Y_Variable_Up; }
"unify_x_value_up"		{ return Unify_X_Value_Up; }
"unify_y_value_up"		{ return Unify_Y_Value_Up; }
"unify_x_local_value_up"	{ return Unify_X_Local_Value_Up; }
"unify_y_local_value_up"	{ return Unify_Y_Local_Value_Up; }
"unify_void_up"  		{ return Unify_Void_Up; }
"unify_nil_up"                  { return Unify_Nil_Up; }
	
"write_list_top"                { return Write_List_Top; }
"write_struct_top"              { return Write_Struct_Top; }

"push_list"			{ return Push_List; }
"push_struct"			{ return Push_Struct; }
"push_struct_func"              { return Push_Struct_Func; }
"push_functor"			{ return Push_Functor; }    
"push_void"       		{ return Push_Void; }       
])

ifdef([EXTENDED_CALL],[
"var_call"                      { return Var_Call; }
"var_execute"                   { return Var_Execute; }
])

ifdef([BOUNDED_Q],[
define([JUMP_CODE],1)
"zerop"                         { return Zerop; }
"listp"                         { return Listp; }
"deterministic"                 { return Deterministic; }

"allocate*"                     { return Allocate_Star; }
"repeat"                        { return Repeat; }
"iterate_int"                   { return Iterate_Int; }
"iterate_int*"                  { return Iterate_Int_Star; }
"iterate_list"                  { return Iterate_List; }
"iterate_list*"                 { return Iterate_List_Star; }
"ensure_list_try"		{ return Ensure_List_Try; }
"ensure_list_trust"             { return Ensure_List_Trust; }
])

ifdef([PARALLEL_BQ],[
"spawn_left_bq"                 { return Spawn_Left_BQ; }
])

ifdef([PARALLEL],[
define([JUMP_CODE],1)
"build_rec_poslist"		{ return Build_Rec_Poslist; }
"build_poslist"			{ return Build_Poslist; }
"build_poslist_value"		{ return Build_Poslist_Value; }
"build_neglist"			{ return Build_Neglist; }
"build_neglist_value"		{ return Build_Neglist_Value; }
"build_variables"		{ return Build_Variables; }

"put_nth_head"			{ return Put_Nth_Head; }
"put_nth_tail"			{ return Put_Nth_Tail; }
"put_global_arg"		{ return Put_Global_Arg; }

"unify_nth_head"		{ return Unify_Nth_Head; }
"unify_nth_tail"		{ return Unify_Nth_Tail; }
"unify_global_arg"		{ return Unify_Global_Arg; }

"start_right_body"		{ return Start_Right_Body; }
"start_left_body"		{ return Start_Left_Body; }

"initialize_right"		{ return Initialize_Right; }
"initialize_left"		{ return Initialize_Left; }

"spawn_right"			{ return Spawn_Right; }
"spawn_left"			{ return Spawn_Left; }

"await_leftmost"		{ return Await_Leftmost; }
"await_nonvar"			{ return Await_Nonvar; }
"await_strictly_nonvar"		{ return Await_Strictly_Nonvar; }
"await_variable"		{ return Await_Variable; }

"par_builtin"                   { return Par_Builtin; }
"par_inline"                    { return Par_Inline; }

"lock_and_get_list"             { return Lock_And_Get_List; }
"lock_and_get_structure"        { return Lock_And_Get_Structure; }
"unlock"                        { return Unlock; }
])

ifdef([JUMP_CODE],[
"jump"                          { return Jump; }
])
changequote(`,')

"halt"	 			{ return Halt; }
"noop"				{ return Noop; }
	
"label"				{ return Label; }
"predicate"			{ return PREDICATE; }

[0-9]*"."[0-9]+			{ return FLOAT; }
"-"[0-9]*"."[0-9]+		{ return FLOAT; }
[0-9]+				{ return NUMBER; }
"-"[0-9]+			{ return NUMBER; }

"[]"                    	{ return ATOMNAME; }
[a-zA-Z_$=\\][a-zA-Z_0-9$=\\]*  { return ATOMNAME; }

"'"[\01-\46\50-\176\t]+"'"      {
                                  int i=0;
				  int j=1;
				  
				  parseatom:
				  if(yytext[j] == 39)
				    if(yytext[j+1] == 39)
				      j++;
				    else {
				      yytext[i]=0;
				      return ATOMNAME;
				    }
				  yytext[i]=yytext[j];
				  i++; j++;
				  goto parseatom;
				}

"("				{ return LPAR; }
")"				{ return RPAR; }
"{"                             { return LSPAR; }
"}"                             { return RSPAR; }
","				{ return COMMA; }
"/"				{ return SLASH; }
	
[\n\t ]				;
%.*$				;
"/*"				{ loop:
				  while(input() != '*');
				  switch(input())
				    {
				    case '/': break;
                                    case '*': unput('*');
                                    default: goto loop;
                                    }
                                }
<<EOF>>				{ return END; }
                        
