/*    File:	 parallel.c  (~bevemyr/Luther2/SharedEmulator/parallel.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Apr 14 17:05:41 1993
 *    Purpose:   
 */ 

#include "include.h"
#include "engine.h"
#include "unify.h"
#include "debug.h"
#include "inline.h"
#include "labelsort.h"
#include "initial.h"
#include "array.h"
#include "parallel.h"

double reduce_vector_plus(w)
    worker *w;
{
#ifdef PARALLEL
  register double sum;
  register s32 first, last, arraysize, mod, div;
  register TAGGED *array, number, *end;
  
  arraysize = GetNumber(GetArraySize(w->global->parallel_start.code));
  div = (s32) arraysize / w->global->active_workers;
  mod = arraysize % w->global->active_workers;
  first =  div * (w->pid-1) + (mod < w->pid ?  mod : (w->pid - 1));
  last = first + div + (w->pid <= mod ? 1 : 0);
  
  array = &(GetArrayArg((TAGGED) w->global->parallel_start.code,first));
  end   = &(GetArrayArg((TAGGED) w->global->parallel_start.code,last));
  
  for(sum = 0.0 ; array < end ; array += VARSIZE)
    {
      if(w->global->global_fail) return sum;
      DerefNLL(number, Ref(array));
      if(IsNUM(number))
	{
	  sum += (double) GetNumber(number);
	}
      else if (IsFLT(number))
	{
	  sum += GetFloat(number);
	}
      else
	{
	  Report_Global_Fail;
	  return sum;
	}
    }
  return sum;
#endif
}

double reduce_vector_times(w)
     worker *w;
{
#ifdef PARALLEL
  register double sum;
  register s32 first, last, arraysize, mod, div;
  register TAGGED *array, number, *end;
  
  arraysize = GetNumber(GetArraySize(w->global->parallel_start.code));
  div = (s32) arraysize / w->global->active_workers;
  mod = arraysize % w->global->active_workers;
  first =  div * (w->pid-1) + (mod < w->pid ?  mod : (w->pid - 1));
  last = first + div + (w->pid <= mod ? 1 : 0);
  
  array = &(GetArrayArg((TAGGED) w->global->parallel_start.code,first));
  end   = &(GetArrayArg((TAGGED) w->global->parallel_start.code,last));
  
  for(sum = 1.0 ; array < end ; array += VARSIZE)
    {
      if(w->global->global_fail) return sum;
      DerefNLL(number, Ref(array));
      if(IsNUM(number))
	{
	  sum *= (double) GetNumber(number);
	}
      else if (IsFLT(number))
	{
	  sum *= GetFloat(number);
	}
      else
	{
	  Report_Global_Fail;
	  return sum;
	}
    }
  return sum;
#endif /* PARALLEL */
}
