/*    File:	 lock.h  (~bevemyr/Luther2/SharedEmulator/lock.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Thu Jul  2 16:28:21 1992
 *    Purpose:   Defines lock operations.
 */ 

#ifdef LOCKING

/* 
   The first word of an unbound variable contains a tag and
   a pointer field. The variable is locked by changing the
   tag field to LCK.
 */

#define Drop_Lock(V,VP)    Drop_P_Lock(V,VP)
#define Drop_P_Lock(V,VP)  { *TagToPointer(V)= VP; }

/* Grab_Lock tries to lock a variable using a optimistic lock.
   A locked variable is a term with the tag LCK pointing to
   itself. We grab the lock by swapping the variables current
   value with a lock term. If the result of the swap isn't
   a lock term then we know that we owns the lock,
   if it, on the other hand, is a lock term then someone else 
   has managed to lock the variable before us and we have to
   wait until the lock is dropped and try again.
 */

#define Grab_Lock(VP,V)                                        \
{                                                              \
  register TAGGED *gl_pos = TagToPointer(V);                   \
  register TAGGED gl_lock = Tagify(gl_pos,LCK);                \
  do                                                           \
    {                                                          \
      LCKAttStat(w);                                           \
      if((VP = swap_il(gl_pos,gl_lock)) != gl_lock)            \
	{                                                      \
	  break;                                               \
	}                                                      \
      Spin_On_Lock(gl_pos,VP);                                 \
    } while(TRUE);                                             \
                                                               \
  LCKGrabStat(w);                                              \
}                                                              


#define Spin_On_Lock(P,V)                                      \
{                                                              \
    register volatile TAGGED *sol_pos = P;                     \
    while(*(sol_pos)==(TAGGED)V);                              \
}                                                              

#else  /* LOCKING */

#define Drop_P_Lock(X,Y)

#endif /* LOCKING */
