/*    File:	 load.c
 *    Author:	 Johan Bevemyr
 *    Created:	 Sun Jun  2 17:42:41 1991
 */ 

#include "include.h"
#include "engine.h"
#include "unify.h"
#include "load.h"

#ifdef LOAD

extern void yyrestart PROTO((FILE *));
extern int yyparse PROTO((void));
extern worker *parse_worker;
extern FILE* yyin;

void load(file,w)
    FILE *file;
    worker *w;
{
    if(yyin == NULL) {
	yyin = file;
    } else {
	yyrestart(file);
    }
    parse_worker = w;
    yyparse();
}

/* $load/1 */
BOOL luther_load(Arg)
    Argdecl;
{
    register TAGGED X0;
    FILE *loadfile;
    char filename[MAXPATHLEN];

    
    DerefNLL(X0,Xw(0));

    if(IsATM(X0)) {
        if(!expand_file_name(GetString(X0,w),filename))
	    return FALSE;
	if((loadfile = fopen(filename, "r")) == NULL) {
	    luther_error(E_OPEN_FILE, X0,w);
	    return FALSE;
	}
	if(yyin == NULL) {
	    yyin = loadfile;
	} else {
	    yyrestart(loadfile);
	}
	parse_worker = w;
	yyparse();
	fclose(loadfile);
	return TRUE;
    } else {
	luther_error(E_FILE_SPEC,X0,w);
	return FALSE;
    }
}

#else

void load(file,w)
    FILE *file;
    worker *w;
{
    return;
}

BOOL luther_load(Arg)
    Argdecl;
{
    Error("load - wam code format not supported, recompile");
    return FALSE;
}
#endif
