/*    File:	 inout.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Jun  5 15:22:23 1991
 */ 

enum {
    USER_IN,
    USER_OUT,
    USER_ERR
};

typedef struct stream_node {
    FILE *file;
    TAGGED name;
    TAGGED mode;
    BOOL tty_io;
} stream_t;

#define IsUserOut(S) (IsATM(S)&&((S==atom_user)||(S==atom_user_output)))
#define IsUserErr(S) (IsATM(S)&&(S==atom_user_error))
#define IsUserIn(S)  (IsATM(S)&&((S==atom_user)||(S==atom_user_input)))
#define IsStream(S)  (IsSTR(S)&&(GetFunctor(S) == functor_d_stream))

#define GetInStream(Term,FromStream)                               \
{                                                                  \
  if (IsStream(Term))                                              \
    {                                                              \
      TAGGED StIndex;                                              \
      DerefNLL(StIndex,*GetArg(Term,0));                           \
      FromStream = streams[GetNumber(StIndex)].file;               \
    }                                                              \
  else if (IsUserIn(Term))                                         \
    {                                                              \
      FromStream = streams[USER_IN].file;                          \
    }                                                              \
  else                                                             \
    {                                                              \
      luther_error(E_ILLEGAL_STREAM,Term,w);                       \
      return FALSE;                                                \
    }                                                              \
}

#define GetOutStream(Term,ToStream)                                \
{                                                                  \
  if (IsStream(Term))                                              \
    {                                                              \
      TAGGED StIndex;                                              \
      DerefNLL(StIndex,*GetArg(Term,0));                           \
      ToStream = streams[GetNumber(StIndex)].file;                 \
    }                                                              \
  else if (IsUserOut(Term))                                        \
    {                                                              \
      ToStream = streams[USER_OUT].file;                           \
    }                                                              \
  else if (IsUserErr(Term))                                        \
    {                                                              \
      ToStream = streams[USER_ERR].file;                           \
    }                                                              \
  else                                                             \
    {                                                              \
      luther_error(E_ILLEGAL_STREAM,Term,w);                       \
      return FALSE;                                                \
    }                                                              \
}

#define GetStreamIndex(Term,Index)                                 \
{                                                                  \
  if (IsStream(Term))                                              \
    {                                                              \
      TAGGED StIndex;                                              \
      DerefNLL(StIndex,*GetArg(Term,0));                           \
      Index = GetNumber(StIndex);                                  \
    }                                                              \
  else if (IsUserOut(Term))                                        \
    {                                                              \
      Index = USER_OUT;                                            \
    }                                                              \
  else if (IsUserIn(Term))                                         \
    {                                                              \
      Index = USER_IN;                                             \
    }                                                              \
  else                                                             \
    {                                                              \
      luther_error(E_ILLEGAL_STREAM,Term,w);                       \
      return FALSE;                                                \
    }                                                              \
}
    
#define GetStreamInIndex(Term,Index)                               \
{                                                                  \
  if (IsStream(Term))                                              \
    {                                                              \
      TAGGED StIndex;                                              \
      DerefNLL(StIndex,*GetArg(Term,0));                           \
      Index = GetNumber(StIndex);                                  \
    }                                                              \
  else if (IsUserIn(Term))                                         \
    {                                                              \
      Index = USER_IN;                                             \
    }                                                              \
  else                                                             \
    {                                                              \
      luther_error(E_ILLEGAL_STREAM,Term,w);                       \
      return FALSE;                                                \
    }                                                              \
}
    
#define GetStreamOutIndex(Term,Index)                              \
{                                                                  \
  if (IsStream(Term))                                              \
    {                                                              \
      TAGGED StIndex;                                              \
      DerefNLL(StIndex,*GetArg(Term,0));                           \
      Index = GetNumber(StIndex);                                  \
    }                                                              \
  else if (IsUserOut(Term))                                        \
    {                                                              \
      Index = USER_OUT;                                            \
    }                                                              \
  else                                                             \
    {                                                              \
      luther_error(E_ILLEGAL_STREAM,Term,w);                       \
      return FALSE;                                                \
    }                                                              \
}
      

extern FILE *currin;
extern FILE *currout;
extern FILE *currerr;

extern char char_table[256];

extern BOOL luther_display PROTO((Argproto));
extern BOOL luther_display2 PROTO((Argproto));
extern BOOL luther_write PROTO((Argproto));
extern BOOL luther_write2 PROTO((Argproto));
extern BOOL luther_ttyflush PROTO((Argproto));
extern BOOL luther_ttynl PROTO((Argproto));
extern BOOL luther_ttyget0 PROTO((Argproto));
extern BOOL luther_ttyget PROTO((Argproto));
extern BOOL luther_ttyskip PROTO((Argproto));
extern BOOL luther_ttyput PROTO((Argproto));
extern BOOL luther_flush PROTO((Argproto));
extern BOOL luther_nl PROTO((Argproto));
extern BOOL luther_getch PROTO((Argproto));
extern BOOL luther_getch0 PROTO((Argproto));
extern BOOL luther_ttygetch0 PROTO((Argproto));
extern BOOL luther_skip PROTO((Argproto));
extern BOOL luther_prompt PROTO((Argproto));
extern BOOL luther_get0 PROTO((Argproto));
extern BOOL luther_get PROTO((Argproto));
extern BOOL luther_put PROTO((Argproto));
extern BOOL luther_flush_stream PROTO((Argproto));
extern BOOL luther_nl_stream PROTO((Argproto));
extern BOOL luther_get0_stream PROTO((Argproto));
extern BOOL luther_get_stream PROTO((Argproto));
extern BOOL luther_put_stream PROTO((Argproto));
extern BOOL luther_current_input PROTO((Argproto));
extern BOOL luther_current_output PROTO((Argproto));
extern BOOL luther_set_input PROTO((Argproto));
extern BOOL luther_set_output PROTO((Argproto));
extern BOOL luther_streams PROTO((Argproto));
extern BOOL luther_stream_name PROTO((Argproto));
extern BOOL luther_stream_mode PROTO((Argproto));
extern BOOL luther_stream_file PROTO((Argproto));
extern BOOL luther_stream_code PROTO((Argproto));
extern BOOL luther_file_code PROTO((Argproto));
extern BOOL luther_code_file PROTO((Argproto));
extern BOOL luther_fopen PROTO((Argproto));
extern BOOL luther_fdopen PROTO((Argproto));
extern BOOL luther_close PROTO((Argproto));
extern BOOL luther_rewind PROTO((Argproto));

void initialize_streams PROTO((void));
