/*    File:	 inline.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Jun  5 17:26:02 1991
 */ 


extern SIZE compare_struct PROTO((TAGGED *, TAGGED *, int, worker *));
static SIZE compare_term PROTO((TAGGED, TAGGED, worker *));

static BOOL luther_compare PROTO((InArgproto));
static BOOL luther_functor PROTO((InArgproto));
static BOOL luther_arg PROTO((InArgproto));
static BOOL luther_eq_univ PROTO((InArgproto));
static BOOL luther_ineq_univ PROTO((InArgproto));
static BOOL luther_lt_univ PROTO((InArgproto));
static BOOL luther_gt_univ PROTO((InArgproto));
static BOOL luther_le_univ PROTO((InArgproto));
static BOOL luther_ge_univ PROTO((InArgproto));
static BOOL luther_math_eq PROTO((InArgproto));
static BOOL luther_math_ineq PROTO((InArgproto));
static BOOL luther_lt PROTO((InArgproto));
static BOOL luther_gt PROTO((InArgproto));
static BOOL luther_le PROTO((InArgproto));
static BOOL luther_ge PROTO((InArgproto));
static BOOL luther_atom PROTO((InArgproto));
static BOOL luther_atomic PROTO((InArgproto));
static BOOL luther_integer PROTO((InArgproto));
static BOOL luther_float PROTO((InArgproto));
static BOOL luther_number PROTO((InArgproto));
static BOOL luther_nonvar PROTO((InArgproto));
static BOOL luther_var PROTO((InArgproto));
static BOOL luther_plus PROTO((InArgproto));
static BOOL luther_plus_1 PROTO((InArgproto));
static BOOL luther_minus PROTO((InArgproto));
static BOOL luther_minus_1 PROTO((InArgproto));
static BOOL luther_times PROTO((InArgproto));
static BOOL luther_div PROTO((InArgproto));
static BOOL luther_intdiv PROTO((InArgproto));
static BOOL luther_mod PROTO((InArgproto));
static BOOL luther_lshift PROTO((InArgproto));
static BOOL luther_rshift PROTO((InArgproto));
static BOOL luther_tointeger PROTO((InArgproto));
static BOOL luther_tofloat PROTO((InArgproto));
static BOOL luther_eval_math PROTO((InArgproto));
static BOOL luther_univ PROTO((InArgproto));
static BOOL luther_bin_or PROTO((InArgproto));
static BOOL luther_bin_and PROTO((InArgproto));
static BOOL luther_bin_xor PROTO((InArgproto));
static BOOL luther_unary_minus PROTO((InArgproto));
static BOOL luther_exp PROTO((InArgproto));
static BOOL luther_log PROTO((InArgproto));
static BOOL luther_sin PROTO((InArgproto));
static BOOL luther_cos PROTO((InArgproto));
static BOOL luther_tan PROTO((InArgproto));
static BOOL luther_asin PROTO((InArgproto));
static BOOL luther_acos PROTO((InArgproto));
static BOOL luther_atan PROTO((InArgproto));
static BOOL luther_inline_unify PROTO((InArgproto));
static BOOL luther_generic PROTO((InArgproto));
static BOOL luther_aref PROTO((InArgproto));
static BOOL luther_array_in_size PROTO((InArgproto));
static BOOL luther_array_in_elt PROTO((InArgproto));
static BOOL luther_array_in_ref PROTO((InArgproto));
static BOOL luther_reduce_vector_plus PROTO((InArgproto));
static BOOL luther_reduce_vector_times PROTO((InArgproto));
static BOOL luther_par_reduce_plus PROTO((InArgproto));
static BOOL luther_par_reduce_times PROTO((InArgproto));
static BOOL luther_abs PROTO((InArgproto));
static BOOL luther_pow PROTO((InArgproto));
static BOOL luther_active PROTO((InArgproto));
static BOOL luther_save PROTO((InArgproto));
static BOOL luther_collect_plus PROTO((InArgproto));
static BOOL luther_collect_times PROTO((InArgproto));
static BOOL luther_array_var_size PROTO((InArgproto));
static BOOL luther_array_var_elt PROTO((InArgproto));
static BOOL luther_elt PROTO((InArgproto));
static BOOL luther_floor PROTO((InArgproto));
static BOOL luther_ceil PROTO((InArgproto));

extern BOOL luther_is PROTO((InArgproto));

#define INLINE_TABLE_SIZE 69

#define GetInlineArity(F)  inline_table[F].arity
#define GetInlineFnk(F)    inline_table[F].fnk
#define GetInlineName(F)   inline_table[F].pname
#define GetInlineType(F)   inline_table[F].type
#define GetInlineRetarg(F) inline_table[F].retarg

typedef enum {
    I_FUNC,
    I_PRED
} i_type;

typedef struct {
  char *pname;
  int  arity;
  BOOL (*fnk)PROTO((InArgproto));
  i_type type;
  int retarg;
} inline_entry;

extern inline_entry inline_table[];

extern void init_inline PROTO((void));
