/*    File:	 initial.c
 *    Author:	 Johan Bevemyr
 *    Created:	 Sun Jun  2 17:16:58 1991
 */ 

#include "include.h"
#include "inline.h"
#include "builtin.h"
#include "array.h"
#include "load.h"

#include "qload.h"
#include "display.h"
#include "initial.h"
#include "debug.h"
#include "engine.h"

#ifdef HP_UX
#include <unistd.h>
#endif

TAGGED atom_nil;		/* "[]" */
TAGGED atom_list;		/* "." */
TAGGED functor_list;		/* "."/2 */
TAGGED atom_user_input;		/* "user_input" */ 
TAGGED atom_user_output;	/* "user_output" */
TAGGED atom_user_error;		/* "user_error" */
TAGGED atom_user;		/* "user" */
TAGGED atom_r;			/* "r"  */
TAGGED atom_w;			/* "w" */
TAGGED atom_fail;		/* "fail" */
TAGGED atom_true;		/* "true" */
TAGGED atom_equal;              /* "=" */
TAGGED atom_less;               /* "<" */
TAGGED atom_greater;            /* ">" */
TAGGED default_prefix;          /* "$new" */
TAGGED prompt;                  /* "|: " */
TAGGED functor_d_ref;           /* "$ref"/2 */
TAGGED functor_d_stream;        /* "$stream/1 */

TAGGED module_prolog;           /* "prolog" */
TAGGED module_public;           /* "public" */
TAGGED module_user;             /* "user"   */

int orig_nr_of_workers;
int verbose = 0;                /* true = 1, false = 0: guides the loader */
int tracing;                    /* used by the prolog tracer */

int worker_nr;
worker *worker_set;

static void def_c_pred PROTO((int, BOOL (), int, TAGGED, worker *));

static void def_c_pred(pname, procedure, arity, module, w)
    int pname;
    BOOL (*procedure)();
    int arity;
    TAGGED module;
    worker *w;
{
    store_c_predicate(StoreFunctor(atom_table_tagged[pname], arity),
		      procedure, module, w);
}

void initialize_builtin(w)
    worker *w;
{
    /* inline.c */

    def_c_pred(ATOM_IS, luther_is, 2, PUBLIC, w);

    /* builtin.c */

    def_c_pred(ATOM_FAIL, luther_fail, 0, PUBLIC, w);
    def_c_pred(ATOM_TRUE, luther_true, 0, PUBLIC, w);
    def_c_pred(ATOM_NAME, luther_name, 2, PUBLIC, w);
    def_c_pred(ATOM_NUMBER_CHARS, luther_number_chars, 3, PUBLIC, w);
    def_c_pred(ATOM_ATOM_CHARS, luther_atom_chars, 2, PUBLIC, w);
    def_c_pred(ATOM_HALT, luther_halt, 0, PUBLIC, w);
    def_c_pred(ATOM_VERSION, luther_version, 0, PUBLIC, w);
    def_c_pred(ATOM_WAMDEBUG, luther_debug, 0, PUBLIC, w);
    def_c_pred(ATOM_PROLOG_WAMDEBUG, luther_prolog_debug, 0, PUBLIC, w);
    def_c_pred(ATOM_WAMDEBUG, luther_par_debug, 1, PUBLIC, w);
    def_c_pred(ATOM_WAMNODEBUG,luther_nodebug, 0, PUBLIC, w);
    def_c_pred(ATOM_UNIQUE_NAME, luther_unique_name, 3, PUBLIC, w);
    def_c_pred(ATOM_SETARG, luther_setarg, 3, PUBLIC, w);
    def_c_pred(ATOM_TRACE, luther_trace, 0, PUBLIC, w);
    def_c_pred(ATOM_NOTRACE, luther_notrace, 0, PUBLIC, w);
    def_c_pred(ATOM_CURRENT_PREDICATE, luther_current_predicate, 2, PUBLIC, w);

    def_c_pred(ATOM_TOPCHOICE,luther_topchoice, 1, PROLOG, w);
    def_c_pred(ATOM_D_ASSERT_DELETE_OTHER,
	       luther_assert_delete_other, 4, PROLOG, w);
    def_c_pred(ATOM_D_ASSERTA, luther_asserta, 4, PROLOG, w);
    def_c_pred(ATOM_D_ASSERTZ, luther_assertz, 4, PROLOG, w);
    def_c_pred(ATOM_D_CLAUSE, luther_clause, 5, PROLOG, w);
    def_c_pred(ATOM_D_CLAUSE, luther_clause_noref, 4, PROLOG, w);
    def_c_pred(ATOM_D_ERASE, luther_erase, 2, PROLOG, w);
    def_c_pred(ATOM_D_RETRY_CHOICE, luther_retry_choice, 1, PROLOG, w);
    def_c_pred(ATOM_D_RETRY_CUT, luther_retry_cut, 1, PROLOG, w);
    def_c_pred(ATOM_D_SET_SPY, luther_set_spy, 1, PROLOG, w);
    def_c_pred(ATOM_D_REMOVE_SPY, luther_remove_spy, 1, PROLOG, w);
    def_c_pred(ATOM_D_TRACE, luther_d_trace, 0, PROLOG, w);
    def_c_pred(ATOM_D_GET_TRACE_LEVEL, luther_get_trace_level, 1, PROLOG, w);
    def_c_pred(ATOM_D_SET_INC_TRACE_LEVEL,
	       luther_set_inc_trace_level, 1, PROLOG, w);
    def_c_pred(ATOM_D_SET_DEC_TRACE_LEVEL,
	       luther_set_dec_trace_level, 1, PROLOG, w);
    def_c_pred(ATOM_D_SAVE_CHOICE, luther_save_choice, 1, PROLOG, w);
    def_c_pred(ATOM_D_GET_SAVED_CHOICE, luther_get_saved_choice, 1, PROLOG, w);
    def_c_pred(ATOM_D_CURR_PRED, luther_curr_pred, 4, PROLOG, w);
    def_c_pred(ATOM_D_FILE_MOD_TIME, luther_file_mod_time,3, PROLOG, w);
    def_c_pred(ATOM_D_SET_MODULE, luther_set_module, 2, PUBLIC, w);
    def_c_pred(ATOM_D_PUBLIC, luther_public, 2, PUBLIC, w);
    def_c_pred(ATOM_REDUCE_STRUCT, luther_reduce, 3, PUBLIC, w); 
    def_c_pred(ATOM_REDUCE, luther_array_reduce, 3, PUBLIC, w); 
    def_c_pred(ATOM_D_PREDICATE_PROPERTY, luther_predicate_property,2,
	       PROLOG, w);
    def_c_pred(ATOM_COPY_TERM, luther_copy_term, 2, PUBLIC, w);
    def_c_pred(ATOM_ELT, luther_array_elt, 3, PUBLIC, w);
    def_c_pred(ATOM_SIZE, luther_array_size_2, 2, PUBLIC, w);
    def_c_pred(ATOM_SETREF, luther_array_setref,3,PUBLIC, w);
    def_c_pred(ATOM_ATOM_MODE, luther_atom_mode,2,PROLOG, w);
    def_c_pred(ATOM_DEREFTEST, luther_test_deref,3,PUBLIC, w);
    def_c_pred(ATOM_DEREFTEST_BIND, luther_test_deref_bind,3,PUBLIC, w);
    def_c_pred(ATOM_TRAILTEST, luther_trailtest,2,PUBLIC, w);
    def_c_pred(ATOM_TRAILTEST2, luther_trailtest2,3,PUBLIC, w);
    def_c_pred(ATOM_INITTEST, luther_inittest,2,PUBLIC, w);
    def_c_pred(ATOM_ACTIVE_WORKERS, luther_nr_workers,2,PUBLIC, w);
    def_c_pred(ATOM_RANDOM, luther_random,2,PUBLIC, w);
    def_c_pred(ATOM_SRANDOM, luther_srandom,1,PUBLIC, w);
    def_c_pred(ATOM_SCHEDULE, luther_scheduling,1,PUBLIC, w);
    def_c_pred(ATOM_COLLECT_GARBAGE, luther_collect_garbage,0,PUBLIC, w);
    def_c_pred(ATOM_PROLOG_FLAG_GC_VERBOSE, luther_prolog_flag_gc_verbose,
	       2,PUBLIC, w);
    def_c_pred(ATOM_PROLOG_FLAG_LOAD_VERBOSE, luther_prolog_flag_load_verbose,
	       2,PUBLIC, w);

    /* load.c */

    def_c_pred(ATOM_D_LOAD,luther_load,1, PROLOG, w);

    /* qload.c */

    def_c_pred(ATOM_D_QLOAD,luther_qload,1, PROLOG, w);

    /* statistics.c */

    def_c_pred(ATOM_STATISTICS,luther_statistics,0, PUBLIC, w);
    def_c_pred(ATOM_STATISTICS,luther_statistics_n,1, PUBLIC, w);
    def_c_pred(ATOM_D_STATISTICS_RUNTIME,
	       luther_statistics_runtime,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_GCTIME,
	       luther_statistics_gctime,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_GCNR,
	       luther_statistics_gcnr,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_GCBYTES,
	       luther_statistics_gcbytes,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_WALLTIME,
	       luther_statistics_walltime,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_PARALLEL_RUNTIME,
	       luther_statistics_parallel_runtime,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_MEMORY,
	       luther_statistics_memory,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_GLOBAL,
	       luther_statistics_global,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_LOCAL, luther_statistics_local,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_TRAIL, luther_statistics_trail,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_CODE, luther_statistics_code,1, PROLOG, w);
    def_c_pred(ATOM_D_STATISTICS_ATOM, luther_statistics_atom,1, PROLOG, w);

    /* inout.c */

    def_c_pred(ATOM_D_PROMPT,luther_prompt,2, PROLOG, w);

      /* tty I/O */

    def_c_pred(ATOM_TTYFLUSH,luther_ttyflush,0, PUBLIC, w);
    def_c_pred(ATOM_TTYNL,luther_ttynl,0, PUBLIC, w);
    def_c_pred(ATOM_TTYGET0,luther_ttyget0,1, PUBLIC, w);
    def_c_pred(ATOM_TTYGET,luther_ttyget,1, PUBLIC, w);
    def_c_pred(ATOM_D_TTYGETCH0,luther_ttygetch0,2, PROLOG, w);
    def_c_pred(ATOM_TTYSKIP,luther_ttyskip,1, PUBLIC, w);
    def_c_pred(ATOM_TTYPUT,luther_ttyput,1, PUBLIC, w);

      /* currin/currout I/O */

    def_c_pred(ATOM_FLUSH,luther_flush,0, PUBLIC, w);
    def_c_pred(ATOM_NL,luther_nl,0, PUBLIC, w);
    def_c_pred(ATOM_D_DISPLAY,luther_display,1, PROLOG, w);
    def_c_pred(ATOM_WRITE,luther_write,1, PUBLIC, w);
    def_c_pred(ATOM_D_WRITE,luther_write,1, PROLOG, w);
    def_c_pred(ATOM_D_SKIP,luther_skip,1, PROLOG, w);
    def_c_pred(ATOM_PUT,luther_put,1, PUBLIC, w);
    def_c_pred(ATOM_D_PUT,luther_put,1, PROLOG, w);
    def_c_pred(ATOM_GET0,luther_get0,1, PUBLIC, w);
    def_c_pred(ATOM_GET,luther_get,1, PUBLIC, w);
    def_c_pred(ATOM_D_GETCH,luther_getch,2, PROLOG, w);
    def_c_pred(ATOM_D_GETCH0,luther_getch0,2, PROLOG, w);

      /* stream I/O */

    def_c_pred(ATOM_PUT,luther_put_stream,2, PUBLIC, w);
    def_c_pred(ATOM_D_PUT,luther_put_stream,2, PROLOG, w);
    def_c_pred(ATOM_D_WRITE,luther_write2,2, PROLOG, w);
    def_c_pred(ATOM_D_DISPLAY, luther_display2, 2, PROLOG, w);
    def_c_pred(ATOM_FLUSH,luther_flush_stream,1, PUBLIC, w);
    def_c_pred(ATOM_NL,luther_nl_stream,1, PUBLIC, w);
    def_c_pred(ATOM_GET0,luther_get0_stream,2, PUBLIC, w);
    def_c_pred(ATOM_GET,luther_get_stream,2, PUBLIC, w);
    def_c_pred(ATOM_CURRENT_INPUT,luther_current_input,1, PUBLIC, w);
    def_c_pred(ATOM_CURRENT_OUTPUT,luther_current_output,1, PUBLIC, w);
    def_c_pred(ATOM_D_SET_INPUT,luther_set_input,1, PROLOG, w);
    def_c_pred(ATOM_D_SET_OUTPUT,luther_set_output,1, PROLOG, w);
    def_c_pred(ATOM_D_STREAMS,luther_streams,1, PROLOG, w);
    def_c_pred(ATOM_D_STREAM_NAME,luther_stream_name,2, PROLOG, w);
    def_c_pred(ATOM_D_STREAM_MODE,luther_stream_mode,2, PROLOG, w);
    def_c_pred(ATOM_D_STREAM_FILE,luther_stream_file,2, PROLOG, w);
    def_c_pred(ATOM_D_CODE_FILE,luther_code_file,2, PROLOG, w);
    def_c_pred(ATOM_D_FOPEN,luther_fopen,3, PROLOG, w);
    def_c_pred(ATOM_CLOSE,luther_close, 1, PUBLIC, w);
    def_c_pred(ATOM_REWIND,luther_rewind, 1, PUBLIC, w);

#ifndef THINK_C
    def_c_pred(ATOM_D_STREAM_CODE,luther_stream_code,2, PROLOG, w);
    def_c_pred(ATOM_D_FILE_CODE,luther_file_code,2, PROLOG, w);
    def_c_pred(ATOM_D_FDOPEN,luther_fdopen,3, PROLOG, w);
#endif /* THINK_C */

    init_backtrackable_c(w);
}


static void init_char()
{
  register int i;
  register char *ch;

  for (i=0   ; i < 128 ; i++) char_table[i] = WHITESPACE;

  for (i=128 ; i < 256 ; i++) char_table[i] = LOWERCASE;		

  ch = "abcdefghijklmnopqrstuvwxyz";
  while(i = *ch++) char_table[i] = LOWERCASE;

  ch = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  while(i = *ch++) char_table[i] = UPPERCASE;
  
  ch = "0123456789";
  while(i = *ch++) char_table[i] = DIGIT;

  ch = "#$&*+-./:<=>?@^\\`~";
  while(i = *ch++) char_table[i] = SYMBOL;

  ch = "!\"%'(),;[]_{|}";
  while(i = *ch++) char_table[i] = SOLO;
}

void init_predefined_atoms()
{
    atom_user_input  = atom_table_tagged[ATOM_USER_INPUT];
    atom_user_output = atom_table_tagged[ATOM_USER_OUTPUT];
    atom_user_error  = atom_table_tagged[ATOM_USER_ERROR];
    atom_r           = atom_table_tagged[ATOM_R];
    atom_w           = atom_table_tagged[ATOM_W];
    atom_user        = atom_table_tagged[ATOM_USER];
    atom_list        = atom_table_tagged[ATOM_LIST];
    atom_nil         = atom_table_tagged[ATOM_NIL];
    atom_fail        = atom_table_tagged[ATOM_FAIL];
    atom_true        = atom_table_tagged[ATOM_TRUE];
    atom_equal       = atom_table_tagged[ATOM_EQUAL];
    atom_less        = atom_table_tagged[ATOM_LESS];
    atom_greater     = atom_table_tagged[ATOM_GREATER];
    default_prefix   = atom_table_tagged[ATOM_PREFIX];
    prompt           = atom_table_tagged[ATOM_PROMPT];

    module_prolog    = atom_table_tagged[ATOM_PROLOG];
    module_public    = atom_table_tagged[ATOM_PUBLIC];
    module_user      = atom_table_tagged[ATOM_USER];

    functor_list     = StoreFunctor(atom_list,2);
    functor_d_stream = StoreFunctor(atom_table_tagged[ATOM_D_STREAM],1);
    functor_d_ref    = StoreFunctor(atom_table_tagged[ATOM_D_REF],2);

    return;
}

/* System specifik initalizations */

float ticks_per_msecond;

static void init_system()
{
#ifdef APOLLO
    ticks_per_msecond = 60.0 / 1000.0;
#endif
#ifdef HP_UX
    ticks_per_msecond = sysconf(_SC_CLK_TCK) / 1000.0;
#endif
#ifdef BSD_UNIX
    ticks_per_msecond = 1.0;
#endif
}

/* Initialize the signal handler */

static void init_signals()
{
#ifdef HP_UX
#define SIGINT 2
#endif HP_UX
  install_sigvec(SIGINT, interrupt_handler);
  return;
}

/* Initialisations that need to be made once only. */

static worker *init_once(n)
    int n;
{
    worker *w;

    init_char();
    init_system();
    init_signals();

    w = init_global_memory(n);

    init_semaphores(w,n);
    
    /* Node specific initalization */

    init_node(w); 
    
    init_database(w);
    
    /* These initializations requires the atom table to be present
       and can thus not be done in the leaf until the atom table
       has been recieved by com-engine(). */
    
    init_inline(); 

    init_predefined_atoms();

    current_module = module_prolog;

    initialize_builtin(&(w[0]));

    initialize_streams();

    initialize_flags(&(w[0]));

    /* start timer */
    init_statistics(&(w[0]));

#ifdef PARALLEL
    w->global->scheduling = STATIC;
    w->global->scheduling_mode = VERTICAL;

    w->global->debugsig = 0;
#endif

    return w;
}

static void init_each_time(w)
    worker *w;
{
  current_module = module_prolog;

  w->frame = (environment *) w->stack_start;
  w->choice = (choicepoint *) w->stack_start;
  
#ifdef DEBUG
  init_debugger(debugflag);
#endif

  interpret_goal =
    get_definition(StoreFunctor(atom_table_tagged[ATOM_D_INTERPRET_GOAL],
				 1),w);
  interpret_goal_trace =
    get_definition(StoreFunctor(atom_table_tagged[ATOM_D_INTERPRET_GOAL_T],
				 1),w);

   abort_code =
    get_definition(StoreFunctor(atom_table_tagged[ATOM_ABORT],0),w);

  return;
}

void reinitialize(w)
    worker *w;
{
    register choicepoint *B;

    /* Resets engine */

    w->heap_top = w->heap_start;
#if defined(TIMESTAMP) || defined(UNBOUND)
    w->time = w->uncond = 0;
#else
    w->uncond = w->heap_top;
#endif
    w->trail_top = w->trail_start;

    init_each_time(w);

    current_module = module_user;

    B = w->choice;
    B->trail_top = w->trail_top;
    B->global_top = w->heap_top;
    B->last_choice = NULL;
    B->cont_env = NULL;
    B->next_instr = w->next_instr;
    B->next_clause = NULL;
    B->arity = 0;
    
    w->frame = (environment *) (((char *) w->choice) + sizeof(choicepoint) -
				sizeof(TAGGED));
    w->frame->cont_env = NULL;
    w->frame->next_instr = w->next_instr;

    return;
}

void init_wam(w)
    worker *w;
{
    register choicepoint *B;

    init_local_memory(w);
    init_each_time(w);

#if defined(TIMESTAMP) || defined(UNBOUND)
    w->time = w->uncond = 0;
#else
    w->uncond = w->heap_top;
#endif
    w->lut_trace = 0;
    w->event_flag = 0;
    w->next_instr = &(start_pred)[2];

    B = w->choice;

    B->trail_top = w->trail_top;
    B->global_top = w->heap_top;
    B->last_choice = NULL;
    B->cont_env = NULL;
    B->next_instr = w->next_instr;
    B->next_clause = NULL;
    B->arity = 0;

    w->frame = (environment *) (((char *) w->choice) + sizeof(choicepoint) -
				sizeof(TAGGED));
    w->frame->cont_env = NULL;
    w->frame->next_instr = w->next_instr;

#ifdef PARALLEL
    w->stats->current_user_time = (int) usertime();
#endif /* PARALLEL */

    return;
}

void reinitialize_stack(w)
    worker *w;
{
    /* reinitialize stack */
    
    w->choice = (choicepoint *) w->stack_start;

    w->frame = (environment *) (((char *) (w->stack_start)) +
				sizeof(choicepoint) - sizeof(TAGGED));
    
    current_module = module_user;
    
#if defined(TIMESTAMP) || defined(UNBOUND)      
 
   /* Get current time */
    w->time = (w-w->pid)->time+1;

    w->uncond = (w-w->pid)->uncond;

#endif /* TIMESTAMP || UNBOUND */
    
    return;
}

worker *initialize(n)
    int n;
{
    return init_once(n);
}

