/*    File:	 gc.h  (~bevemyr/Luther/Emulator/gc.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Oct 28 16:22:48 1991
 *    Purpose:   Support macros for the garbage collector.
 */ 


#define GC_If_Needed_Execute(W, DEF)                                    \
{                                                                       \
  if(H > (W)->heap_margin)                                              \
    {                                                                   \
      StoreHeap;                                                        \
      garbage_collect(W, ArityOf(DEF->name), FrameSize(W->next_instr)); \
      LoadHeap;                                                         \
    }                                                                   \
}

#define GC_If_Needed_Require(W, A)                                      \
{                                                                       \
  if(H > (W)->heap_margin)                                              \
    {                                                                   \
      StoreHeap;                                                        \
      garbage_collect(W, A, FrameSize(W->next_instr));                  \
      LoadHeap;                                                         \
    }                                                                   \
}

#define UL(T)              ((u32) (T))
                           
#define GC_M_MASK          (0x1L << GCOFFSET) /* 0000..00001 */
#define GC_F_MASK          (0x2L << GCOFFSET) /* 0000..00010 */
#define GC_FM_MASK         (GC_M_MASK | GC_F_MASK)
#define GC_P_MASK          POINTMASK
#define GCMASK             GC_FM_MASK

#define Mark(T)            (T) |= GC_M_MASK
#define MarkF(T)           (T) |= GC_F_MASK

#define UnMark(T)          (T) &= (~GC_M_MASK)
#define UnMarkF(T)         (T) &= (~GC_F_MASK)

#define IsMarked(T)        (UL(T) & GC_M_MASK)
#define IsMarkedF(T)       (UL(T) & GC_F_MASK)
#define IsForM(T)          (UL(T) & GC_FM_MASK)
#define IsMarkedFM(T)      ((UL(T) & GC_FM_MASK) == GC_FM_MASK)

#define RemoveMark(T)      ((TAGGED) ((UL(T) - GC_M_MASK)))
#define RemoveMarkF(T)     ((TAGGED) ((UL(T) - GC_F_MASK)))
#define PutMark(T)         ((TAGGED) ((UL(T) + GC_M_MASK)))

#define PutValue(X,Y)      ((UL(X) & GC_P_MASK) |                       \
			    (UL(Y) & ~GC_P_MASK))

#define PutValueFirst(X,Y) ((UL(X) & (GC_P_MASK | GC_F_MASK)) |         \
			    (UL(Y) & ~(GC_P_MASK | GC_F_MASK)))

#define Reverse(C,N)       { register TAGGED *temp = TagToPointer(*(N));\
                             *(N) = PutValue(C,*(N));                   \
                             C = N;                                     \
                             N = temp; }
                         
#define Undo(C,N)          Reverse(N,C)

#define Advance(C,N)       { register TAGGED *temp = TagToPointer(*(C));\
                             *(C) = PutValue(N,*(C));                   \
                             (C)--;                                     \
                             (N) = TagToPointer(*(C));                  \
                             *(C) = PutValue(temp,*(C)); }

#define Reset(V)           *TagToPointer(V) = (V)

extern void garbage_collect PROTO((worker *, int, int));

