/*    File:	 expand_file_name.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Fri Jun  7 14:15:17 1991
 */ 

#include "include.h"
#include "expand_file_name.h"

#ifndef UNIX
BOOL expand_file_name(name, target)
     char *name;
     char *target;
{
    strcpy(target,name);
    return TRUE;
}

#else /* UNIX */

#include <pwd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <signal.h>
#include <sys/stat.h>

/* This file is stolen from akl */
    
static char cwd[MAXPATHLEN+1];

BOOL expand_file_name(name, target)
     char *name;
     char *target;
{
  register char *src, *dest, *temp;

#ifdef HP_UX
  getcwd(cwd,MAXPATHLEN+1);
#endif /* HP_UX */
#ifdef APOLLO
  getcwd(cwd,MAXPATHLEN+1);
#endif /* APOLLO */
#ifdef BSD_UNIX
  getwd(cwd);
#endif /* BSD_UNIX */

  src = name, dest = target;
  if (src[0] != '/' && src[0] != '~')
    {
      strcpy(dest,cwd);
      dest += strlen(dest);
      *dest++ = '/';
    }

				/* phase 1: expand ~...  and $... */

 state0:			/* prev char is '/' or b.o.l. */
  switch (*dest++ = *src++)
    {
    case 0:
      src = dest = target;
      goto state20;
    case '/':
      goto state0;
    case '~':
      temp = dest;
      goto stateusr;
    case '$':
      temp = dest;
      goto stateenv;
    }

 state1:			/* inside file name component */
  switch (*dest++ = *src++)
    {
    case 0:
      src = dest = target;
      goto state20;
    case '/':
      goto state0;
    default:
      goto state1;
    }

 stateusr:			/* inside ~... component */
  switch (*dest++ = *src++)
    {
    case 0:
    case '/':
      --src, --dest, dest[0] = (char)0;
      if (temp == dest)
	{
	  --dest, dest[0] = (char)0;
	  if (!(temp = getenv("HOME")))
	    USAGE_FAULT("file name: no home directory")
	  strcat(dest,temp);
	  dest += strlen(dest);
	}
      else
	{
	  struct passwd *pw;

	  dest = temp-1, dest[0] = (char)0;
	  if (!(pw = getpwnam(temp)))
	    USAGE_FAULT("file name: no such user")
	  strcat(dest,(char *)pw->pw_dir);
	  dest += strlen(dest);
	}	
      goto state0;
    default:
      goto stateusr;
    }

 stateenv:			/* inside $... component */
  switch (*dest++ = *src++)
    {
    case 0:
    case '/':
      --src, --dest, dest[0] = (char)0;
      if (temp == dest)
	dest[0] = '$';
      else
	{
	  dest = temp-1, dest[0] = (char)0;
	  if (!(temp = getenv(temp)))
	    USAGE_FAULT("file name: undefined variable")
	  strcat(dest,temp);
	  dest += strlen(dest);
	}
      goto state0;
    default:
      goto stateenv;
    }

				/* phase 2: contract "." and ".." components */

 state10:			/* prev char is '/' */
  switch (*dest++ = *src++)
    {
    case 0:
      if (dest-2 > target)
	dest[-2] = 0;
      return TRUE;
    case '/':
#if aegis
      if (dest-3 < target || dest[-3] == '/')
	{
	  dest = target, *dest++ = '/', *dest++ = '/';
	  goto state10;
	}
#endif
      dest = target, *dest++ = '/';
      goto state10;
    case '.':
      if (src[0] == '/' || src[0] == (char)0)
	{
	  dest -= 2;
	  if (dest-1 <= target)
	    dest++;
	}
      else if (src[0] == '.' && (src[1] == '/' || src[1] == (char)0))
	{
	  src++, dest -= 2;
	  if (dest-1 <= target)
	    dest++;
	  while (--dest, dest[0] != '/')
	    ;
	  if (dest-1 <= target)
	    dest++;
	}
      if (dest[-1] == '/')
	goto state10;
    }

 state20:
  switch (*dest++ = *src++)
    {
    case 0:
      return TRUE;
    case '/':
      goto state10;
    default:
      goto state20;
    }
}

#endif /* UNIX */

