/*    File:	 event.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Aug 13 12:07:22 1991
 */ 

/* events in order of priority */

typedef enum {
    EVENT_HEAP_GC = 0,
    EVENT_TRACE,
    EVENT_RESTART,
    EVENT_BACKTRACK,
    EVENT_REQUEST,
    EVENT_INTERRUPT,
    EVENT_BOUND_VVA
} events;

#ifdef SEMAPHORE
#define AddEvent(E) { GrabSemaphore(SEMA_EVENT,1,w); \
		      worker_set->event_flag |= 1 << (E); \
		      DropSemaphore(SEMA_EVENT,1,w); }
#else /* SEMAPHORE */

#define AddEvent(E) { worker_set->event_flag |= 1 << (E); }

#endif /* SEMAPHORE */

#define CheckEvent  { if(event_flag) handle_event(); }
