/*    File:	 event.c 
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Aug 13 12:07:07 1991
 *    Purpose:   To handle events inside the WAM.
 *    Note:      This file MUST be included by the engine.c inside the
 *               wam() function to be useful.
 */ 

#ifndef EVENT_INCLUDED_ONCE
#define EVENT_LABEL first_event_start
#define EVENT_INCLUDED_ONCE
#else
#undef EVENT_LABEL
#define EVENT_LABEL second_event_start
#endif

if(w->event_flag != 0) {
    register u32 event;
    register int i;

    event = w->event_flag;
    w->event_flag = 0;
    
 EVENT_LABEL:
    
    if(event == 0) return;
    
    i = 0 ; 

    while(!(event & 1))
      {
	event = event >> 1;
	i += 1;
      }
    
    switch(i) {
    case EVENT_HEAP_GC:
      garbage_collect(w,ArityOf(def->name),FrameSize(pc-1));
      break;
      
    case EVENT_TRACE:
      PL_Print1(stderr,"can't display TRACE info...yet\n");
      break;
      
    case EVENT_INTERRUPT:
      /* 
	 The following should be implemented!
	 
	 save x registers and pc in an environment
	 set continuation to the following code

	 call foo/0, <arity+1>
	 call restore/0, <arity+1>
	 deallocate
	 proceed

       */

      pc = w->global->interrupt_code->entry_code.incoreinfo;

      Pre_Fetch;
      Pre_Execute_Read_Instr(0);

      break;

    default:
      PL_Print2(stderr,"event handler - no such event %d\n", i);
      
    }
    goto EVENT_LABEL;
}

