/*    File:	 error.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Sun Jun  2 16:51:51 1991
 */ 

#ifdef UNIX
#include <errno.h>
#endif

extern int sys_nerr;
extern int errno;

#define FatalError(String) { PL_Print2(stderr,"Fatal Error: %s\n", String);\
			     error_exit(1); }
#define Error(String) PL_Print2(stderr,"Error: %s\n", String);
			
#define USAGE_FAULT(String) {PL_Print2(stderr,"%s\n",String); return FALSE;}

#define OsError(String) PL_Print2(stderr,"OS Error: %s\n", String)

enum errortypes {
    E_PUT_ARG,
    E_FILE_SPEC,
    E_OPEN_FILE,
    E_NR_FILES,
    E_ILLEGAL_GOAL,
    E_PRED_NOT_DEF,
    E_ILLEGAL_STREAM,
    E_ILLEGAL_AR_EX,
    E_DIV_ZERO,
    E_CLAUSE_NOT_DYNAMIC
};

/* functions declared in error.c */

extern void error_exit PROTO((int));
extern void luther_error PROTO((int, TAGGED, worker *));
extern void luther_exit PROTO((int));
extern int child_pid[];
extern int nr_children;
    
