/*    File:	 error.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Jun  4 18:34:08 1991
 */ 

#include "include.h"
#include "display.h"

#ifdef UNIX
int sys_nerr;
int errno;
#endif

#ifdef PARALLEL
#include <signal.h>
int child_pid[MAXACTIVE];
int nr_children;
#endif /* PARALLEL */

#ifdef THINK_C
#include <SegLoad.h>
#endif

void luther_exit(e)
    int e;
{
#ifdef PARALLEL
    printf(stderr,"died\n");
    {
      int i;
      for(i = 0; i < nr_children ; i++) {
	(void) kill(child_pid[i],SIGKILL);
      }
    }
#endif /* PARALLEL */

    remove_semaphores();
#ifdef SHARED
    remove_shared_memory();
#endif

#ifdef THINK_C
    ExitToShell();
#else
    exit(e);
#endif
}

void error_exit(e)
    int e;
{
    luther_exit(e);
}

void luther_error(t,arg,w)
    int	t;
    TAGGED arg;
    worker *w;
{
    switch(t) {
    case E_PUT_ARG:
	PL_Print1(stderr,"{ERROR: illigal arithmetic expression}\n");
	PL_Print1(stderr,"{ERROR: put(");
	display_term(stderr,arg,w);
	PL_Print1(stderr,") - illegal argumnet}\n");
	break;
    case E_OPEN_FILE:
	PL_Print2(stderr,"{ERROR: %s - cannot open file}\n",GetString(arg,w));
	break;
    case E_FILE_SPEC:
	PL_Print1(stderr,"{ERROR: ");
	display_term(stderr,arg,w);
	PL_Print1(stderr," - invalid file spec}\n");
	break;
    case E_NR_FILES:
	PL_Print1(stderr,"{ERROR: cannot open more files}\n");
	break;
    case E_ILLEGAL_GOAL:
	PL_Print1(stderr,"{ERROR: ");
	display_term(stderr,arg,w);
	PL_Print1(stderr," - illegal goal}\n");
	break;
    case E_PRED_NOT_DEF:
	PL_Print3(stderr,"{Warning: The predicate %s/%d is undefined}\n",
		  GetString(FunctorToAtom(((definition *) arg)->name),w),
		  ArityOf(((definition *) arg)->name));
	break;
    case E_ILLEGAL_STREAM:
	PL_Print1(stderr,"{ERROR: ");
	display_term(stderr,arg,w);
	PL_Print1(stderr," - illegal stream specifier}\n");
	break;
    case E_ILLEGAL_AR_EX:
	PL_Print1(stderr,"{ERROR: illegal arithmetic expression}\n");
	break;
    case E_DIV_ZERO:
	PL_Print1(stderr,"{ERROR: division by zero}\n");
	break;
    case E_CLAUSE_NOT_DYNAMIC:
	PL_Print1(stderr,"{ERROR: predicate ");
	display_term(stderr,arg,w);
	PL_Print1(stderr," is not dynamic}\n");
	break;
    default:
	PL_Print1(stderr,"Error: luther_error, no such error type\n");
    }
}

