/*    File:	 display_code.c 
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Jun  5 13:12:48 1991
 */ 

#include "include.h"
#include "engine.h"
#include "display_code.h"
#include "inline.h"

#define ResetIndex      index_nr = 1

#define PrintSmallIndex { int index;                                 \
			  Get_Small_Index(index,instruction,index_nr,pc);\
			  index_nr++;                                \
                          PL_Print2(currerr,"%d",index);             \
                        }

#ifdef THREADED_CODE
#define Get_Small_Index(To,I,N,P) { To = Get_Index(P); }
#else
#define Get_Small_Index(To,I,N,P) { if(N > MAX_INDEX) {              \
	                              N = 1;                         \
	                              I = Get_Tagged(P);             \
                                    }                                \
                                    To = Get_Instr((I) >> N*8);      \
                                  }
#endif
#define PrintLabel   { int label = Get_Label(pc);                    \
		       if(label == 0) {                              \
			   PL_Print1(currerr,"fail");                \
		       } else {                                      \
			   PL_Print2(currerr,"%lu",                  \
				     ((s32)pc)+((s32)label)-         \
				     ((s32)lstart)-4);               \
		       }                                             \
		     }

#define PrintIndex   { int index = Get_Index(pc);                    \
			  PL_Print2(currerr,"%lu",index);}
#define PrintIndex1  { int index = Get_Index_I(1,instruction);       \
			  PL_Print2(currerr,"%d)",index); }
#define PrintIndex1n { int index = Get_Index_I_M(1,instruction);     \
			  PL_Print2(currerr,"%d,",index); }
#define PrintIndex2  { int index = Get_Index_I(2,instruction);       \
			  PL_Print2(currerr,"%d)",index); }
#define PrintIndex2n { int index = Get_Index_I(2,instruction);       \
			  PL_Print2(currerr,"%d,",index); }

#define PrintConstant {                                              \
    TAGGED con = Get_Tagged(pc);                                     \
    switch(TagOf(con)) {                                             \
    case ATM:                                                        \
	PL_Print2(currerr,"'%s'",GetString(con,w));                  \
	break;                                                       \
    case NUM:                                                        \
	PL_Print2(currerr,"%d",GetNumber(con));                      \
	break;                                                       \
    case FLT:                                                        \
	PL_Print2(currerr,"%f",(float) GetFloat(con));               \
	break;                                                       \
    default:                                                         \
	PL_Print1(currerr,"error: not a constant!");                 \
    }                                                                \
}

#define PrintStructure {                                             \
    TAGGED f = Get_Functor(pc);                                      \
    PL_Print3(currerr,"'%s'/%d",                                     \
              GetString(FunctorToAtom(f),w),ArityOf(f));             \
}

void display_code(pc,w)
    code *pc;
    worker *w;
{
    (void) display_code_inc(pc,w);
}

code *display_code_inc(pc,w)
    code *pc;
    worker *w;
{
  TAGGED instruction;
  register int index_nr;
  
  InstToOp(instruction,Get_Code(pc));
  switch(Get_Instr(instruction))
    {
    case DUMMY_INSTRUCTION:
      PL_Print1(currerr,"dummy_instruction");
      break;
    case SWITCH_ON_TERM:
      PL_Print1(currerr,"switch_on_term(");
      PrintLabel; PL_Print1(currerr,",");
      PrintLabel; PL_Print1(currerr,",");
      PrintLabel; PL_Print1(currerr,",");
      PrintLabel; PL_Print1(currerr,",");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case SWITCH_ON_CONSTANT:
      {
	int i, nr = Get_Index(pc);
	PL_Print2(currerr,"switch_on_constant(%d,[", nr);
	for(i = 0 ; i != nr ; i++) {
	  PL_Print1(currerr,"[");
	  PrintConstant; PL_Print1(currerr,","); PrintLabel; 
	  PL_Print1(currerr,"]");
	  if(i != nr - 1) PL_Print1(currerr,",");
	}
	PL_Print1(currerr,"],");
	PrintLabel;
	PL_Print1(currerr,")");
	break;
      }
    case SWITCH_ON_STRUCTURE:
      {
	int i, nr = Get_Index(pc);
	PL_Print2(currerr,"switch_on_structure(%d,[", nr);
	for(i = 0 ; i != nr ; i++) {
	  PL_Print1(currerr,"[");
	  PrintStructure; PL_Print1(currerr,","); PrintLabel; 
	  PL_Print1(currerr,"]");
	  if (i != nr - 1) PL_Print1(currerr,",");
	}
	PL_Print1(currerr,"],");
	PrintLabel;
	PL_Print1(currerr,")");
	break;
      }
      
    case TRY:
      PL_Print1(currerr,"try("); 
      PrintIndex1n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case RETRY:
      PL_Print1(currerr,"retry("); 
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case TRUST:
      PL_Print1(currerr,"trust("); 
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case TRY_ME_ELSE:
      PL_Print1(currerr,"try_me_else("); 
      PrintIndex1n; 
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case RETRY_ME_ELSE:
      PL_Print1(currerr,"retry_me_else("); 
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case TRUST_ME:
      PL_Print1(currerr,"trust_me");
      break;
      
    case CHOICE_X:
      PL_Print1(currerr,"choice_x(");
      PrintIndex1;
      break;
    case CHOICE_Y:
      PL_Print1(currerr,"choice_y("); 
      PrintIndex1;
      break;
    case CUT:
      PL_Print1(currerr,"cut");
      break;
    case CUT_X:
      PL_Print1(currerr,"cut_x("); 
      PrintIndex1;
      break;
    case CUT_Y:
      PL_Print1(currerr,"cut_y("); 
      PrintIndex1;
      break;
    case INLINE:
      {
	int arity, fnk;
	
	fnk = Get_Index_I(1,instruction);
	
	arity = GetInlineArity(fnk);
	
	PL_Print3(currerr,"inline('%s'/%d,", GetInlineName(fnk), arity);
	PrintLabel;
	PL_Print1(currerr,",[");
	
	while(arity--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	
	PL_Print1(currerr,"])");
	break;
      }
    case BUILTIN:
      {
	int arity, fnk;
	
	fnk = Get_Index_I(1,instruction);
	
	arity = GetInlineArity(fnk);
	
	PL_Print3(currerr,"builtin('%s'/%d,[", GetInlineName(fnk), arity);
	
	while(arity--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	
	PL_Print1(currerr,"])");
	break;
      }
    case META_CALL:
      PL_Print1(currerr,"meta_call("); 
      PrintIndex1n;
      PrintIndex2;
      Inc_Index(pc);
      break;
    case META_EXECUTE:
      PL_Print1(currerr,"meta_execute("); 
      PrintIndex1;
      break;
      
#ifdef EXTENDED_CALL
    case VAR_CALL:
      PL_Print1(currerr,"var_call("); 
      PrintIndex2;
      Inc_Index(pc);
      break;
    case VAR_EXECUTE:
      PL_Print1(currerr,"var_execute"); 
      break;
#endif /* EXTENDED_CALL */
      
    case REQUIRE:
      PL_Print1(currerr,"require(");
      PrintIndex;
      PL_Print1(currerr,")");
      break;
      
    case REQUIRE_USING:
      {
	int n = Get_Index_I(1,instruction);
	
	PL_Print1(currerr,"require_using(");
	PrintIndex; 
	PL_Print2(currerr,",%d)", n);
	
	break;
      }	
    case ALLOCATE:
      PL_Print1(currerr,"allocate"); 
      break;
    case ALLOCATE2:
      PL_Print1(currerr,"allocate2");
      break;
    case DEALLOCATE:
      PL_Print1(currerr,"deallocate");
      break;
    case INIT:
      {
	int nr, n;
	
	nr = Get_Index_I(1,instruction);
	
	PL_Print2(currerr,"init(%d,[",nr);
	
	while(nr--) {
	  n = Get_Index(pc);
	  PL_Print2(currerr,"%d",n);
	  if(nr != 0) PL_Print1(currerr,",");
	}
	PL_Print1(currerr,"])");
	break;
      }
      
    case CALL:
      {
	definition *def;
	int env;
	env = Get_Index_I(2,instruction);
	def = Get_Definition(pc);
	
	PL_Print4(currerr,"call('%s'/%d,%d)",
		  GetString(FunctorToAtom(def->name),w),
		  ArityOf(def->name), env);
	break;
      }
    case EXECUTE:
      {
	definition *def;
	
	def = Get_Definition(pc);
	PL_Print3(currerr,"execute('%s'/%d)",
		  GetString(FunctorToAtom(def->name),w),
		  ArityOf(def->name));
	break;
      }
    case PROCEED:
      PL_Print1(currerr,"proceed");
      break;
    case FAIL:
      PL_Print1(currerr,"fail");
      break;
      
    case GET_X_VARIABLE:
      PL_Print1(currerr,"get_x_variable(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case GET_Y_VARIABLE:
      PL_Print1(currerr,"get_y_variable(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case GET_Y_FIRST_VALUE:
      PL_Print1(currerr,"get_y_first_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case GET_X_VALUE:
      PL_Print1(currerr,"get_x_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case GET_Y_VALUE:
      PL_Print1(currerr,"get_y_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case GET_CONSTANT:
      PL_Print1(currerr,"get_constant(");
      PrintConstant; PL_Print1(currerr,","); 
      PrintIndex1;
      break;
    case GET_NIL:
      PL_Print1(currerr,"get_nil(");
      PrintIndex1;
      break;
    case GET_STRUCTURE:
      PL_Print1(currerr,"get_structure(");
      PrintStructure; PL_Print1(currerr,","); 
      PrintIndex1;
      break;
    case GET_LIST:
      PL_Print1(currerr,"get_list(");
      PrintIndex1;
      break;
    case GET_CONSTANT_X0:
      PL_Print1(currerr,"get_constant_x0(");
      PrintConstant;
      break;
    case GET_NIL_X0:
      PL_Print1(currerr,"get_nil_x0(");
      break;
    case GET_STRUCTURE_X0:
      PL_Print1(currerr,"get_structure_x0(");
      PrintStructure;
      PL_Print1(currerr,")");
      break;
    case GET_LIST_X0:
      PL_Print1(currerr,"get_list_x0");
      break;
      
    case PUT_X_VOID:
      PL_Print1(currerr,"put_x_void(");
      PrintIndex1;
      break;
    case PUT_Y_VOID:
      PL_Print1(currerr,"put_y_void(");
      PrintIndex1;
      break;
    case PUT_X_VARIABLE:
      PL_Print1(currerr,"put_x_variable(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_Y_VARIABLE:
      PL_Print1(currerr,"put_y_variable(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_X_VALUE:
      PL_Print1(currerr,"put_x_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_Y_VALUE:
      PL_Print1(currerr,"put_y_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_X_UNSAFE_VALUE:
      PL_Print1(currerr,"put_x_unsafe_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_Y_UNSAFE_VALUE:
      PL_Print1(currerr,"put_y_unsafe_value(");
      PrintIndex1n;
      PrintIndex2;
      break;
    case PUT_CONSTANT:
      PL_Print1(currerr,"put_constant(");
      PrintConstant; PL_Print1(currerr,",");
      PrintIndex1;
      break;
    case PUT_NIL:
      PL_Print1(currerr,"put_nil(");
      PrintIndex1;
      break;
    case PUT_STRUCTURE:
      PL_Print1(currerr,"put_structure(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex1;
      break;
    case PUT_LIST:
      PL_Print1(currerr,"put_list(");
      PrintIndex1;
      break;
      
    case UNIFY_VOID:
      PL_Print1(currerr,"unify_void(");
      PrintIndex1;
      break;
    case UNIFY_X_VARIABLE:
      PL_Print1(currerr,"unify_x_variable(");
      PrintIndex1;
      break;
    case UNIFY_Y_VARIABLE:
      PL_Print1(currerr,"unify_y_variable(");
      PrintIndex1;
      break;
    case UNIFY_Y_FIRST_VALUE:
      PL_Print1(currerr,"unify_y_first_value(");
      PrintIndex1;
      break;
    case UNIFY_X_VALUE:
      PL_Print1(currerr,"unify_x_value(");
      PrintIndex1;
      break;
    case UNIFY_Y_VALUE:
      PL_Print1(currerr,"unify_y_value(");
      PrintIndex1;
      break;
    case UNIFY_X_LOCAL_VALUE:
      PL_Print1(currerr,"unify_x_local_value(");
      PrintIndex1;
      break;
    case UNIFY_Y_LOCAL_VALUE:
      PL_Print1(currerr,"unify_y_local_value(");
      PrintIndex1;
      break;
    case UNIFY_CONSTANT:
      PL_Print1(currerr,"unify_constant(");
      PrintConstant; 
      PL_Print1(currerr,")");
      break;
    case UNIFY_NIL:
      PL_Print1(currerr,"unify_nil");
      break;
    case UNIFY_STRUCTURE:
      PL_Print1(currerr,"unify_structure(");
      PrintStructure;
      PL_Print1(currerr,")");
      break;
    case UNIFY_LIST:
      PL_Print1(currerr,"unify_list");
      break;

#ifdef JUMP_CALL
    case CJUMP:
      {
	int  env = Get_Index_I(2,instruction);
	definition *def = Get_Definition(pc);

	PL_Print3(currerr,"cjump(%ld,%d)", def, env);
	break;
      }
    case EJUMP:
      {
	definition *def = Get_Definition(pc);

	PL_Print2(currerr,"ejump(%ld)", def);
	break;
      }
#endif JUMP_CALL
      
#ifdef NEW_READ
    case READ_LIST_TOP:
      PL_Print1(currerr,"read_list_top(");
      PrintIndex1n; 
      PrintIndex2;
      break;
    case READ_STRUCT_TOP:
      PL_Print1(currerr,"read_struct_top(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex1n; PrintIndex2;
      break;
    case READ_LIST:
      PL_Print1(currerr,"read_list(");
      PrintIndex1;
      break;
    case READ_STRUCT:
      PL_Print1(currerr,"read_struct(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex1;
      break;
    case READ_LIST_TAIL:
      PL_Print1(currerr,"read_list_tail(");
      PrintIndex1;
      break;
    case READ_STRUCT_TAIL:
      PL_Print1(currerr,"read_struct_tail(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex1;
      break;
    case UNIFY_CONSTANT_UP:
      PL_Print1(currerr,"unify_constant_up(");
      PrintConstant;
      PL_Print1(currerr,")");
      break;
    case UNIFY_X_VARIABLE_UP:
      PL_Print1(currerr,"unify_x_variable_up(");
      PrintIndex1;
      break;
    case UNIFY_Y_VARIABLE_UP:
      PL_Print1(currerr,"unify_y_variable_up(");
      PrintIndex1;
      break;
    case UNIFY_X_VALUE_UP:
      PL_Print1(currerr,"unify_x_value_up(");
      PrintIndex1;
      break;
    case UNIFY_Y_VALUE_UP:
      PL_Print1(currerr,"unify_y_value_up(");
      PrintIndex1;
      break;
    case UNIFY_X_LOCAL_VALUE_UP:
      PL_Print1(currerr,"unify_x_local_value_up(");
      PrintIndex1;
      break;
    case UNIFY_Y_LOCAL_VALUE_UP:
      PL_Print1(currerr,"unify_y_local_value_up(");
      PrintIndex1;
      break;
    case UNIFY_VOID_UP:  
      PL_Print1(currerr,"unify_void_up(");
      PrintIndex1;
      break;
    case UNIFY_NIL_UP:
      PL_Print1(currerr,"unify_void_up(");
      break;
#ifdef PARALLEL
    case NEW_UNLOCK:
      PL_Print1(currerr,"new_unlock(");
      break;
#endif
#endif /* NEW_READ */
      
#ifdef NEW_WRITE
    case WRITE_LIST_TOP:
      PL_Print1(currerr,"write_list_top(");
      PrintIndex1;
      break;
    case WRITE_STRUCT_TOP:
      PL_Print1(currerr,"write_struct_top(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex1;
      break;
    case PUSH_LIST:
      PL_Print1(currerr,"push_list(");
      PrintIndex;
      break;
    case PUSH_STRUCT:
      PL_Print1(currerr,"push_struct(");
      PrintIndex1n;
      PrintIndex;
      PL_Print1(currerr,")");
      break;
    case PUSH_STRUCT_FUNC:
      PL_Print1(currerr,"push_struct_func(");
      PrintStructure; PL_Print1(currerr,",");
      PrintIndex;
      PL_Print1(currerr,")");
      break;
    case PUSH_FUNCTOR:
      PL_Print1(currerr,"push_functor(");
      PrintStructure;
      PL_Print1(currerr,")");
      break;
    case PUSH_VOID:
      PL_Print1(currerr,"push_void");
      break;
#endif /* NEW_WRITE */
      
#ifdef BOUNDED_Q
    case ZEROP:
      PL_Print1(currerr,"zerop(");
      PrintIndex1n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case LISTP:
      PL_Print1(currerr,"listp(");
      PrintIndex1n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case DETERMINISTIC:
      PL_Print1(currerr,"deterministic(");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
      
    case ALLOCATE_STAR:
      PL_Print1(currerr,"allocate*(");
      PrintIndex1n;
      break;
    case REPEAT:
      PL_Print1(currerr,"repeat(");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case ITERATE_INT:
      PL_Print1(currerr,"iterate_int(");
      PrintIndex1n; 
      PrintIndex2n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case ITERATE_INT_STAR:
      PL_Print1(currerr,"iterate_int_star(");
      PrintIndex1n;
      PrintIndex2n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case ITERATE_LIST:
      PL_Print1(currerr,"iterate_list(");
      PrintIndex1n;
      PrintIndex2n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case ITERATE_LIST_STAR:
      PL_Print1(currerr,"iterate_list_star(");
      PrintIndex1n;
      PrintIndex2n;
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case ENSURE_LIST_TRY:
      PL_Print1(currerr,"ensure_list_try(");
      PrintIndex1n;
      PrintIndex2n;
      PrintLabel;
      PL_Print1(currerr,")");
	break;
    case ENSURE_LIST_TRUST:
      PL_Print1(currerr,"ensure_list_trust");
      break;
#endif /* BOUNDED_Q */
      
#ifdef PARALLEL_BQ
    case SPAWN_LEFT_BQ:
      ResetIndex;
      PL_Print1(currerr,"spawn_left_bq(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
#endif /* PARALLEL_BQ */      

#ifdef JUMP_CODE
    case JUMP:
      PL_Print1(currerr,"jump ");
      PrintLabel;
      break;
#endif
      
#ifdef REFORM
    case BUILD_REC_POSLIST:
      ResetIndex;
      PL_Print1(currerr,"build_rec_poslist(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case BUILD_POSLIST:
      ResetIndex;
      PL_Print1(currerr,"build_poslist(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case BUILD_POSLIST_VALUE:
      ResetIndex;
      PL_Print1(currerr,"build_poslist_value(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case BUILD_NEGLIST:
      ResetIndex;
      PL_Print1(currerr,"build_neglist(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case BUILD_NEGLIST_VALUE:
      ResetIndex;
      PL_Print1(currerr,"build_neglist_value(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case BUILD_VARIABLES:
      ResetIndex;
      PL_Print1(currerr,"build_variables(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case PUT_NTH_HEAD:
      ResetIndex;
      PL_Print1(currerr,"put_nth_head(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintIndex;  PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
    case PUT_NTH_TAIL:
      ResetIndex;
      PL_Print1(currerr,"put_nth_tail(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintIndex;  PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case PUT_GLOBAL_ARG:
      ResetIndex;
      PL_Print1(currerr,"put_global_arg(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case UNIFY_NTH_HEAD:
      ResetIndex;
      PL_Print1(currerr,"unify_nth_head(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintIndex;
      PL_Print1(currerr,")");
      break;
    case UNIFY_NTH_TAIL:
      ResetIndex;
      PL_Print1(currerr,"unify_nth_tail(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintIndex;
      PL_Print1(currerr,")");
      break;
    case UNIFY_GLOBAL_ARG:
      ResetIndex;
      PL_Print1(currerr,"unify_global_arg(");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case START_RIGHT_BODY:
      ResetIndex;
      PL_Print1(currerr,"start_right_body(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case START_LEFT_BODY:
      PL_Print1(currerr,"start_left_body(");
      PrintLabel;
      PL_Print1(currerr,")");
      break;
    case INITIALIZE_RIGHT:
      ResetIndex;
      PL_Print1(currerr,"initialize_right(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case INITIALIZE_LEFT:
      ResetIndex;
      PL_Print1(currerr,"initialize_left(");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case SPAWN_RIGHT:
      ResetIndex;
      PL_Print1(currerr,"spawn_right(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
    case SPAWN_LEFT:
      ResetIndex;
      PL_Print1(currerr,"spawn_left(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
    case AWAIT_LEFTMOST:
      PL_Print1(currerr,"await_leftmost");
      break;
    case AWAIT_NONVAR:
      ResetIndex;
      PL_Print1(currerr,"await_nonvar");
      PrintSmallIndex;
      break;
    case AWAIT_STRICTLY_NONVAR:
      ResetIndex;
      PL_Print1(currerr,"await_strictly_nonvar(");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case AWAIT_VARIABLE:
      ResetIndex;
      PL_Print1(currerr,"await_variable(");
      PrintSmallIndex;
      PL_Print1(currerr,")");
      break;
    case AWAIT_NONVAR_UNIFY:
      ResetIndex;
      PL_Print1(currerr,"await_nonvar");
      break;
    case AWAIT_STRICTLY_NONVAR_UNIFY:
      ResetIndex;
      PL_Print1(currerr,"await_strictly_nonvar");
      break;
    case AWAIT_VARIABLE_UNIFY:
      ResetIndex;
      PL_Print1(currerr,"await_variable");
      break;
    case PAR_BUILTIN:
      {
	int arity, fnk, waitnr;
	
	fnk = Get_Index_I_M(1,instruction);
	waitnr = Get_Index_I(2,instruction);
	
	arity = GetInlineArity(fnk);
	
	PL_Print4(currerr,"builtin('%s'/%d,%d,[", GetInlineName(fnk), arity,
		  waitnr);
	
	while(waitnr--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	PL_Print1(currerr,"],[");
	
	while(arity--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	
	PL_Print1(currerr,"])");
	break;
      }
    case PAR_INLINE:
      {
	int arity, fnk,waitnr;
	
	fnk = Get_Index_I_M(1,instruction);
	waitnr = Get_Index_I(2,instruction);
	
	arity = GetInlineArity(fnk);
	
	PL_Print4(currerr,"inline('%s'/%d,%d,", GetInlineName(fnk), arity,
		  waitnr);
	PrintLabel;
	PL_Print1(currerr,",[");
	
	while(waitnr--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	
	PL_Print1(currerr,"],[");
	
	while(arity--) {
	  PrintIndex;
	  if(arity != 0) PL_Print1(currerr,",");
	}
	
	PL_Print1(currerr,"])");
	break;
      }
    case LOCK_AND_GET_LIST:
      ResetIndex;
      PL_Print1(currerr,"lock_and_get_list(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
    case LOCK_AND_GET_STRUCTURE:
      ResetIndex;
      PL_Print1(currerr,"lock_and_get_structure(");
      PrintStructure;  PL_Print1(currerr,",");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
    case UNLOCK:
      ResetIndex;
      PL_Print1(currerr,"unlock(");
      PrintSmallIndex; PL_Print1(currerr,",");
      PrintSmallIndex; 
      PL_Print1(currerr,")");
      break;
#endif /* REFORM */
    case HALT:
      PL_Print1(currerr,"halt");
      break;
  
    default:
      PL_Print1(currerr,"display_code: no such instruction!");
    }
  return pc;
}
