/*    File:	 display.c
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Jun  4 18:37:49 1991
 */ 

#include "include.h"
#include "unify.h"
#include "display.h"

void display_term(stream,t,w)
    FILE *stream;
    TAGGED t;
    worker *w;
{
    int	i;
    register TAGGED Term;

    if(t == (TAGGED) NULL) {
	PL_Print1(stream,"NULL");
	return;
    }

    DerefNLL(Term, t);
    
    switch(TagOf(Term)) {
    case HVA:
#ifdef VARDISPLAY
	PL_Print2(stream,"_(h)%lx", Term);
#else
	PL_Print2(stream,"_%lx", Term);
#endif
	break;
#ifdef CONSTR
    case CVA:
	PL_Print2(stream,"_c%lx", Term);
	break;
#endif /* CONSTR */      
    case SVA:
#ifdef VARDISPLAY
	PL_Print2(stream,"_(s)%lx", Term);
#else
	PL_Print2(stream,"_%lx", Term);
#endif	
	break;
    case NUM:
	PL_Print2(stream,"%d",GetNumber(Term));
	break;
    case FLT:
	PL_Print2(stream,"%f",GetFloat(Term));
	break;
    case ATM:
	PL_Print2(stream,"%s",GetString(Term,w));
	break;
    case LST:
	PL_Print1(stream,"[");
	display_term(stream,Ref(GetCar(Term)),w);
	DerefNLL(Term,Ref(GetCdr(Term)));
	while(IsLST(Term)) {
	    PL_Print1(stream,",");
	    display_term(stream,Ref(GetCar(Term)),w);
	    DerefNLL(Term,Ref(GetCdr(Term)));
	}
	if(Term == atom_nil)
	    PL_Print1(stream,"]");
	else {
	    PL_Print1(stream,"|");
	    display_term(stream,Term,w);
	    PL_Print1(stream,"]");
	}
	break;
	    
    case STR: {
	structure str;
	int arity;
	
	str = Struct(RemoveTag(Term,STR));
	arity = ArityOf(str->functor);
	
	PL_Print2(stream,"%s(",GetString(FunctorToAtom(str->functor),w));
	
	for(i=0 ; i != arity; i++) {
	    display_term(stream,Ref(GetUntArg(str,i)),w);
	    if(i != arity - 1)
		PL_Print2(stream,"%c",44);
	}
	PL_Print1(stream,")");
	break;
    }
    case GEN:
	GetMethod(print,Term)(stream,Term,w);
	break;
    default:
	PL_Print2(stream,"Error in display_term: No such tag type %lu\n",
		  LowTagOf(Term));
	break;
    }
}

void write_term(stream,t,w)
    FILE *stream;
    TAGGED t;
    worker *w;
{
    int	i;
    register TAGGED Term;

    if(t == (TAGGED) NULL) {
	PL_Print1(stream,"NULL");
	return;
    }

    DerefNLL(Term, t);
    
    switch(TagOf(Term)) {
    case HVA:
#ifdef VARDISPLAY
	PL_Print2(stream,"_(h)%lx", Term);
#else
	PL_Print2(stream,"_%lx", Term);
#endif
	break;
#ifdef CONSTR
    case CVA:
	PL_Print2(stream,"_c%lx", Term);
	break;
#endif /* CONSTR */      
    case SVA:
#ifdef VARDISPLAY
	PL_Print2(stream,"_(s)%lx", Term);
#else
	PL_Print2(stream,"_%lx", Term);
#endif	
	break;
    case NUM:
	PL_Print2(stream,"%d",GetNumber(Term));
	break;
    case FLT:
	PL_Print2(stream,"%f",GetFloat(Term));
	break;
    case ATM:
	if(!AtomHasSpecial(Term))
	  {
	    PL_Print2(stream,"%s",GetString(Term,w));
	    break;
	  }
	else if(AtomHasSquote(Term))
	  {
	    char buf[2*MAXATOMLEN];
	    char i,*in = GetString(Term,w), *out = buf;

	    while(i=*in++) {
	      if (i == '\'')
		*out++ = '\'';
	      *out++ = i;
	    }
	    *out = 0;
	    
	    PL_Print2(stream,"'%s'",buf);
	    break;
	  }
	else
	  {
	    PL_Print2(stream,"'%s'",GetString(Term,w));
	    break;
	  }
    case LST:
	PL_Print1(stream,"[");
	write_term(stream,Ref(GetCar(Term)),w);
	DerefNLL(Term,Ref(GetCdr(Term)));
	while(IsLST(Term)) {
	    PL_Print1(stream,",");
	    write_term(stream,Ref(GetCar(Term)),w);
	    DerefNLL(Term,Ref(GetCdr(Term)));
	}
	if(Term == atom_nil)
	    PL_Print1(stream,"]");
	else {
	    PL_Print1(stream,"|");
	    write_term(stream,Term,w);
	    PL_Print1(stream,"]");
	}
	break;
	    
    case STR: {
	structure str;
	int arity;
	
	str = Struct(RemoveTag(Term,STR));
	arity = ArityOf(str->functor);
	
	PL_Print2(stream,"%s(",GetString(FunctorToAtom(str->functor),w));
	
	for(i=0 ; i != arity; i++) {
	    write_term(stream,Ref(GetUntArg(str,i)),w);
	    if(i != arity - 1)
		PL_Print2(stream,"%c",44);
	}
	PL_Print1(stream,")");
	break;
    }
    case GEN:
	GetMethod(print,Term)(stream,Term,w);
	break;
    default:
	PL_Print2(stream,"Error in write_term: No such tag type %lu\n",
		  LowTagOf(Term));
	break;
    }
}

static int disp_term(t,w)
    TAGGED t;
    worker *w;
{
  display_term(stdout,t,w);
  PL_Print1(stdout,"\n"); fflush(stdout);
  return 1;
}
