/*    File:	 deref.h  (~bevemyr/Luther2/SharedEmulator/deref.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Fri Nov  6 10:44:53 1992
 *    Purpose:   Defines dereferencing macros.
 */ 

#ifdef UNBOUND
#define Deref(Xderefed, X) {                                  \
  register TAGGED d_v, d_vp;                                  \
                                                              \
  d_v = (X);						      \
							      \
  while(TRUE)                                                 \
    {                                                         \
      if(IsVar(d_v))                                          \
	{                                                     \
	  RefVAR(d_vp,d_v);                                   \
	  if((d_v != d_vp) && (!IsUVA(d_vp)))                 \
	    {                                                 \
	      d_v = d_vp;                                     \
	      continue;                                       \
	    }                                                 \
	}                                                     \
      break;                                                  \
    }                                                         \
                                                              \
    Xderefed = d_v;                                           \
}

#define DerefHVA(Xderefed, X) {                               \
  register TAGGED d_v, d_vp;                                  \
                                                              \
  d_v = (X);						      \
							      \
  while(TRUE)                                                 \
    {                                                         \
      if(IsHVA(d_v))                                          \
	{                                                     \
	  RefHVA(d_vp,d_v);                                   \
	  if(!IsUVA(d_vp))                                    \
	    {                                                 \
	      d_v = d_vp;                                     \
	      continue;                                       \
	    }                                                 \
	}                                                     \
      break;                                                  \
    }                                                         \
                                                              \
    Xderefed = d_v;                                           \
}

#else /* UNBOUND */
#ifdef SEQUENT
#define Deref(Xderefed, X) {                                  \
    register TAGGED d_v, d_vp;                                \
                                                              \
    d_v = (X);                                                \
    while(TRUE)                                               \
      {                                                       \
	if(IsVar(d_v))                                        \
	  {                                                   \
	    RefVAR(d_vp,d_v);                                 \
	    if(d_v == d_vp)                                   \
	      break;                                          \
	  }                                                   \
	else                                                  \
	  break;                                              \
	d_v = d_vp;                                           \
      }                                                       \
    Xderefed = d_v;                                           \
}
#define DerefHVA(Xderefed, X) {                               \
    register TAGGED d_v, d_vp;                                \
                                                              \
    d_v = (X);                                                \
    while(TRUE)                                               \
      {                                                       \
	if(IsHVA(d_v))                                        \
	  {                                                   \
	    RefHVA(d_vp,d_v);                                 \
	    if(d_v == d_vp)                                   \
	      break;                                          \
	  }                                                   \
	else                                                  \
	  break;                                              \
	d_v = d_vp;                                           \
      }                                                       \
    Xderefed = d_v;                                           \
}
#else
#define Deref(Xderefed, X) {                                  \
    register TAGGED d_v, d_vp;                                \
                                                              \
    d_v = (X);                                                \
    if(IsVar(d_v))                                            \
	do {                                                  \
	    RefVAR(d_vp,d_v);                                 \
	} while(d_v != d_vp && IsVar(d_v = d_vp));            \
    Xderefed = d_v;                                           \
}

#define DerefHVA(Xderefed, X) {                               \
    register TAGGED d_v = (X), d_vp;                          \
                                                              \
    if(IsHVA(d_v))                                            \
	do {                                                  \
	    RefHVA(d_vp,d_v);                                 \
	} while(d_v != d_vp && IsHVA(d_v = d_vp));            \
    Xderefed = d_v;                                           \
}
#endif /* SEQUENT */
#endif /* UNBOUND */

#ifdef LOCKING
/* 
   These algorithms merits some explanation  . What we do is the
   following:

   1. We follows a variable chain until an unbound variable or a 
      non variable is encountered. 

   2. If the found term is an unbound variable then we try to 
      lock that variable.
   
      a) If the term resulting from the lock operation is the term
         we tried to lock, we return that term.

      b) If, on the other hand, someone has sneaked by and bound
         the variable we have locked, then we drop the lock and
	 continues to follow the reference chain.

   3. If the term at the end of the reference chain is a lock we
      wait until the lock is dropped and then continues to follow
      the chain.

   4. If the end term is neither an unbound variable nor a lock, then
      we return the term as it is.

   This macro relies on the following macros being defined:

      Drop_Lock()
      Grab_Lock()
      IsLCK()
      IsVar()
      RefVAR()
      RemoveTag()
      Spin_On_Lock()
      Tagify()
     
      TRUE

*/

#define DerefNLL(Xderefed, X)                                             \
{                                                                         \
  register TAGGED d_v, d_vp;                                              \
                                                                          \
  d_v = (X);                                                              \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if(IsVar(d_v))                                                      \
	{                                                                 \
	  RefVAR(d_vp,d_v);                                               \
	  if(d_v == d_vp) break;                                          \
	}                                                                 \
      else if (IsLCK(d_v))                                                \
        {                                                                 \
          Spin_On_Lock(TagToPointer(d_v),d_v);                            \
	  RefVAR(d_v,d_v);                                                \
	  continue;                                                       \
	}                                                                 \
      else                                                                \
        break;                                                            \
      d_v = d_vp;                                                         \
    }                                                                     \
  Xderefed = d_v;                                                         \
}                                                               

#define DerefLockSwitch(d_v, Vcode, Ccode)                                \
{                                                                         \
  __label__ varcode;                                                      \
  TAGGED d_vp;                                                            \
                                                                          \
  while(TRUE) {                                                           \
    if(IsHVAorCVA(d_v))                                                   \
      {                                                                   \
	RefHVAorCVA(d_vp,d_v);                                            \
	if(d_v == d_vp)                                                   \
	  {                                                               \
	    Grab_Lock(d_vp,d_v);                                          \
	    if(d_v == d_vp)                                               \
	      {                                                           \
	      varcode:                                                    \
		Vcode;                                                    \
		break;                                                    \
	      }                                                           \
	    else                                                          \
	      {                                                           \
	        Drop_Lock(d_v,d_vp);                                      \
		d_v = d_vp;                                               \
		continue;                                                 \
	      }                                                           \
	  }                                                               \
	else                                                              \
	  {                                                               \
	    d_v = d_vp;                                                   \
	    continue;                                                     \
	  }                                                               \
      }                                                                   \
    else if (IsSVA(d_v))                                                  \
      {                                                                   \
	RefVAR(d_vp,d_v);                                                 \
	if(d_vp == d_v)                                                   \
	  goto varcode;                                                   \
	else                                                              \
	  {                                                               \
	    d_v = d_vp;                                                   \
	    continue;                                                     \
	  }                                                               \
      }                                                                   \
    else if (IsLCK(d_v))                                                  \
      {                                                                   \
	Spin_On_Lock(TagToPointer,(d_v),d_v);                              \
	RefVAR(d_v,d_v);                                                  \
	continue;                                                         \
      }                                                                   \
    else                                                                  \
      {                                                                   \
	Ccode;                                                            \
	break;                                                            \
      }                                                                   \
  }                                                                       \
}                                                               

#define DerefLockSwitchHVA(d_v, Vcode, Ccode)                             \
{                                                                         \
  register TAGGED d_vp;                                                   \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if (IsHVAorCVA(d_v))                                                \
	{                                                                 \
	  RefHVAorCVA(d_vp,d_v);                                          \
	  if(d_v == d_vp)                                                 \
	    {                                                             \
	      Grab_Lock(d_vp,d_v);                                        \
	      if(d_v == d_vp)                                             \
		{                                                         \
		  Vcode;                                                  \
		  break;                                                  \
		}                                                         \
	      else                                                        \
		{                                                         \
		  Drop_Lock(d_v,d_vp);                                    \
		  d_v = d_vp;                                             \
		  continue;                                               \
		}                                                         \
	    }                                                             \
	  else                                                            \
	    {                                                             \
	      d_v = d_vp;                                                 \
	      continue;                                                   \
	    }                                                             \
	}                                                                 \
      else if (IsLCK(d_v))                                                \
	{                                                                 \
	  Spin_On_Lock(TagToPointer(d_v),d_v);                            \
	  RefVAR(d_v,d_v);                                                \
	  continue;                                                       \
	}                                                                 \
      else if (IsNonVar(d_v))                                             \
	{                                                                 \
	  Ccode;                                                          \
	  break;                                                          \
	}                                                                 \
    }                                                                     \
}

#else /* LOCKING */

#define DerefNLL(Xderefed,X) Deref(Xderefed,X)

#ifdef UNBOUND

#define DerefLockSwitch(d_v, Vcode, Ccode)                                \
{                                                                         \
  register TAGGED d_vp;                                                   \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if(IsVar(d_v))                                                      \
	{                                                                 \
	  RefVAR(d_vp,d_v);                                               \
	  if((d_v == d_vp) || (IsUVA(d_vp)))                              \
	    {                                                             \
	      Vcode;                                                      \
	      break;                                                      \
	    }                                                             \
	}                                                                 \
      else                                                                \
	{                                                                 \
	  Ccode;                                                          \
	  break;                                                          \
	}                                                                 \
      d_v = d_vp;                                                         \
    }                                                                     \
}
    
#define DerefLockSwitchHVA(d_v, Vcode, Ccode)                             \
{                                                                         \
  register TAGGED d_vp = d_v;                                             \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if(IsVar(d_v))                                                      \
	{                                                                 \
	  RefHVA(d_vp,d_v);                                               \
	  if(IsUVA(d_vp))                                                 \
	    {                                                             \
	      Vcode;                                                      \
	      break;                                                      \
	    }                                                             \
	}                                                                 \
      else                                                                \
	{                                                                 \
	  Ccode;                                                          \
	  break;                                                          \
	}                                                                 \
      d_v = d_vp;                                                         \
    }                                                                     \
}

#else /* UNBOUND */

#define DerefLockSwitch(d_v, Vcode, Ccode)                                \
{                                                                         \
  register TAGGED d_vp;                                                   \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if(IsVar(d_v))                                                      \
	{                                                                 \
	  RefVAR(d_vp,d_v);                                               \
	  if(d_v == d_vp) {                                               \
	    Vcode;                                                        \
	    break;                                                        \
	  }                                                               \
	}                                                                 \
      else                                                                \
	{                                                                 \
	  Ccode;                                                          \
	  break;                                                          \
	}                                                                 \
      d_v = d_vp;                                                         \
    }                                                                     \
}
    
#define DerefLockSwitchHVA(d_v, Vcode, Ccode)                             \
{                                                                         \
  register TAGGED d_vp;                                                   \
                                                                          \
  while(TRUE)                                                             \
    {                                                                     \
      if(IsHVAorCVA(d_v))                                                 \
	{                                                                 \
	  RefHVAorCVA(d_vp,d_v);                                          \
	  if(d_v == d_vp) {                                               \
	    Vcode;                                                        \
	    break;                                                        \
	  }                                                               \
	}                                                                 \
      else                                                                \
	{                                                                 \
	  Ccode;                                                          \
	  break;                                                          \
	}                                                                 \
      d_v = d_vp;                                                         \
    }                                                                     \
}
#endif  /* UNBOUND */
#endif /* LOCKING */
