/*    File:	 debug.h 
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Jun  5 12:13:18 1991
 */ 

#define MAXSPYPOINTS 100
#define MAXBREAKPOINTS 100

enum debugflags {
    D_CREEP,
    D_TRACE,
    D_LEAP,
    D_CALL_TRACE,
    D_CALL_LEAP
};

#ifdef DEBUG

#ifdef PREFETCH

#define Pre_DisplayFail(rwmc,C)                    \
    if(debugflag) {                                \
	StoreHeap;                                 \
	if(!debug_fail(pc-(C==0?1:0),w,rwmc)) return; \
	LoadHeap;                                  \
    }

#define Pre_DisplayInstr(rwmc,C)                   \
    if(debugflag) {                                \
	StoreHeap;                                 \
    	if(!debug(pc-(C==0?1:0),w,rwmc)) return;   \
	LoadHeap;                                  \
    }

#endif /* PREFETCH */

#define DisplayFail(rwmc)                        \
    if(debugflag) {                              \
	StoreHeap;                               \
	if(!debug_fail(pc,w,rwmc)) return;       \
	LoadHeap;                                \
    }

#define DisplayInstr(rwmc)                         \
    if(debugflag) {                                \
	StoreHeap;                                 \
    	if(!debug(pc,w,rwmc)) return;              \
	LoadHeap;                                  \
    }

extern void init_debugger PROTO((int));
extern int debug_fail PROTO((code *, worker *, char *));
extern int debug PROTO((code *,worker *, char *));
extern void debug_prolog_terms PROTO((void));

#else /* DEBUG */

#define DisplayFail(F)
#define DisplayInstr(F) 
#define Pre_DisplayFail(F,C)
#define Pre_DisplayInstr(F,C) 
#endif /* DEBUG */

extern void readstring PROTO((char *));

extern int debugflag, debugmode, debugfail;
