/*    File:	 database.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Sat May 25 19:21:00 1991
 */ 


#define IsEmptyDynPred(F)   ( (F) == NULL ? 0 != 0 : (F)->clause == NULL )

#define IsLastClause(F)     ( (F)->next == NULL ? 0 == 0 : \
			                         (F)->next->clause == NULL )

#define StoreFunctor(F,A) Arityfy(F,A)

#define PUBLIC module_public
#define PROLOG module_prolog

typedef enum {
    ENTER_INTERPRETED,
    ENTER_SPY,
    ENTER_EMULATED,
    ENTER_C,
    ENTER_UNDEFINED
} enter_inst;

typedef struct retry_node {
    code *clause;
    struct retry_node *next;
} retry_node;

typedef struct {
    retry_node *var, *last;
} in_switch;

union definfo {
  code *incoreinfo;
  BOOL (*cinfo) PROTO((Argproto));
  in_switch *indexinfo;
};

#ifdef JUMP_CALL 

typedef struct calluse {
    code *where;
    struct calluse *next;
} calluse;

#endif /* JUMP_CALL */

typedef struct definition {
    enter_inst enter_instruction;
    TAGGED name;
    TAGGED module; 
    union definfo entry_code;
#ifdef JUMP_CALL
    struct calluse *users;
#endif /* JUMP_CALL */    
    struct definition *next;
} definition;

#ifdef LOCALPRED
extern definition *predtable[];
#else
extern definition **predtable;
#endif

/* Variable used when doing listing of a predicate */

extern code *lstart;

/* Module */

extern TAGGED current_module;

/* Functions declared in database.c */

/* extern TAGGED store_functor PROTO((TAGGED, int)); */
extern void init_atomtable PROTO((worker *));
extern void init_database PROTO((worker *));
extern int hash_atom PROTO((char *));
extern void store_emulated_predicate PROTO((TAGGED, code *, worker *));
extern void store_c_predicate PROTO((TAGGED, BOOL (), TAGGED, worker *));
extern void listing PROTO((worker *));
extern void emulated_listing PROTO((worker *));
extern void store_dynamic_predicate PROTO((TAGGED,code *,TAGGED,TAGGED,worker *));
extern void add_first_dynamic_predicate PROTO((TAGGED,code *,TAGGED,TAGGED,worker *));
extern void add_last_dynamic_predicate PROTO((TAGGED,code *,TAGGED,TAGGED,worker *));
extern definition *get_definition PROTO((TAGGED, worker *));
extern definition *get_ex_definition PROTO((TAGGED, worker *));
extern definition *get_c_definition PROTO((TAGGED, worker *, s32 *));
extern definition *make_public PROTO((TAGGED,worker *));

extern void reset_dynamic_predicate PROTO((in_switch *, retry_node *));
extern void remove_dynamic_clause PROTO((in_switch *, retry_node *));
extern definition *make_undefined PROTO((TAGGED, definition *, worker *));

extern in_switch *make_empty_index_table PROTO((worker *));
extern retry_node *make_retry_node PROTO((code *, retry_node *, worker *));
extern retry_node *add_dynamic_first PROTO((in_switch *, code *, worker *));
extern retry_node *add_dynamic_last PROTO((in_switch *, code *, worker *));
extern definition *get_def_code PROTO((code *, worker *));

