/*    File:	 config.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Nov  6 11:35:39 1991
 *    Purpose:   Configurationfile for Luther
 */ 

#ifdef BOUNDED_Q      /* The code for bounded quantifiers has not been modified
		       * to work in a parallel context
		       */
#define JUMP_CODE 1
#endif /* BOUNDED_Q */


/**********************************************************************
 *
 * Operating system specific
 */

/******************************
 *
 * HP_UX (HP 730)
 */

#ifdef HP_UX

#define MallocBase 0x40000000L
#define ALIGN_DOUBLE 1
#define NEED_RANDOM 1

#endif /* HP_UX */

/******************************
 *
 * Sun OS
 */

#ifdef SUN

#define ALIGN_DOUBLE 1
#define BSD_UNIX 1

#endif /* SUN */

/******************************
 *
 * Symetry Sequent (DYNIX)
 */

#ifdef SEQUENT

#define BSD_UNIX 1
#define ALIGN_DOUBLE 1

#endif SEQUENT

/**********************************************************************
 *
 * Flags for parallel prolog
 */

#ifdef PARALLEL

#define SEMAPHORE 1

#define SWAP_BIND 1  

/* #define LOCKING 1 */

/* #define CONSTR 1  */

#define SHARED 1

#ifndef TRAIL_ALL
#ifndef UNBOUND
#define TIMESTAMP 1
#endif /* UNBOUND */
#endif /* TRAIL_ALL */

#define ACTIVE_CONSUMER 1
#define REFORM 1

#ifdef TIMESTAMP
#define SHORT_SVA 1 
#endif /* TIMESTAMP */

#endif /* PARALLEL */
/**********************************************************************
 *
 * Other flags
 */

#if defined(BSD_UNIX) || defined(HP_UX) || defined(APOLLO)
#define UNIX
#endif 

#ifndef UNIX
#define MAXPATHLEN  255
#endif

#ifdef THINK_C
#define ALIGN_MALLOC 1
#endif

#ifdef REFORM
#define JUMP_CODE 1
#endif

#ifdef THREADED_IND
#define THREADED_CODE
#endif

/* #define HAS_SHMGET 1 */

/* #define LOWTAGS 1 */



