/*    File:	 bind.h  (~bevemyr/Luther2/SharedEmulator/bind.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Fri Nov  6 11:10:13 1992
 *    Purpose:   
 */ 

#ifdef CONSTR
/**********************************************************************
 *
 * constrained variables
 *
 */

#define Bind(V,VAL) {  register TAGGED VR = (V);              \
		       register TAGGED VALL = (VAL);          \
		                                              \
		       if (IsHVA(VR))                         \
			 {                                    \
			   Bind_HVA(VR,VALL);                 \
			 }                                    \
		       else if (IsSVA(VR))                    \
			 {                                    \
			   Bind_SVA(VR,VALL);                 \
			 }                                    \
		       else                                   \
			 {                                    \
			   Bind_CVA(VR,VALL); 		      \
			 }                                    \
		     }

#define Bind_Heap(X,Y)     {  if(IsHVA(X))                    \
				{                             \
				  Bind_HVA(X,Y);              \
				}                             \
                              else                            \
				{                             \
				  Bind_CVA(X,Y);              \
				}                             \
			    }

#else /* CONSTR */
/**********************************************************************
 *
 * NO CONSTR
 *
 */
#define Bind(V,VAL) {  register TAGGED VR = (V);              \
		       register TAGGED VALL = (VAL);          \
		                                              \
		       if (IsHVA(VR))                         \
			 {                                    \
			   Bind_HVA(VR,VALL);                 \
			 }                                    \
		       else                                   \
			 {                                    \
			   Bind_SVA(VR,VALL);                 \
			 }                                    \
		     }

#define Bind_Heap(X,Y)     Bind_HVA(X,Y)

#endif /* CONSTR */

#ifdef SWAP_BIND
/**********************************************************************
 *
 * Atomic bind operation using SWAP
 *
 */

#ifdef UNBOUND
#define Swap_Bind(POS,X,Y,T,TRUECODE,FAILCODE)                \
{                                                             \
  register TAGGED SB_Y = (Y);                                 \
                                                              \
  if(!IsUVA(T = swap_il(((TAGGED *) POS),SB_Y)))              \
    {                                                         \
      SwapFailStat(w)                                         \
      if(!unify_deref(T, SB_Y,w))                             \
	{                                                     \
	  FAILCODE;                                           \
	}                                                     \
    }                                                         \
  else                                                        \
    {                                                         \
      TRUECODE;                                               \
    }                                                         \
}

#define Bind_Unsafe_HVA(X,Y,FAILCODE)                         \
{                                                             \
  register TAGGED BH_X = (X), BH_T;                           \
  Swap_Bind(OffsetBase(BH_X), BH_X, Y, BH_T,                  \
	    Trail_HVA(BH_X,BH_T),                             \
	    FAILCODE);                                        \
}

#else /* UNBOUND */
#define Swap_Bind(POS,X,Y,TRUECODE,FAILCODE)                  \
{                                                             \
  register TAGGED SB_Y = (Y);                                 \
  register TAGGED NEW_X;                                      \
                                                              \
  if((NEW_X = swap_il(((TAGGED *) POS),SB_Y)) != X)           \
    {                                                         \
      SwapFailStat(w)                                         \
      if(!unify_deref(NEW_X, SB_Y,w))                         \
	{                                                     \
	  FAILCODE;                                           \
	}                                                     \
    }                                                         \
  else                                                        \
    {                                                         \
      TRUECODE;                                               \
    }                                                         \
}

#define Bind_Unsafe_HVA(X,Y,FAILCODE)                         \
{                                                             \
  register TAGGED BH_X = (X);                                 \
  Swap_Bind(OffsetBase(BH_X), BH_X, Y,                        \
	    Trail_HVA(BH_X),                                  \
	    FAILCODE);                                        \
}
#endif /* UNBOUND */

#define Bind_Unsafe_Heap(X,Y,FAILCODE) Bind_Unsafe_HVA(X,Y,FAILCODE)

#define Bind_Unsafe(V,VAL,FAILCODE)                           \
{  register TAGGED VR = (V);                                  \
   register TAGGED VALL = (VAL);                              \
                                                              \
   if (IsHVA(VR))                                             \
     {                                                        \
       Bind_Unsafe_HVA(VR,VALL,FAILCODE);                     \
     }                                                        \
   else                                                       \
     {                                                        \
       Bind_SVA(VR,VALL);                                     \
     }                                                        \
 }

#else  /* SWAP_BIND */

#ifdef UNBOUND
#define Swap_Bind(X,Y,Z,A,B,C) SetHVA(Y,Z)
#else
#define Swap_Bind(X,Y,Z,A,B) SetHVA(Y,Z)
#endif

/**********************************************************************
 *
 * NO atomic bind operation, regular binding
 *
 */

#define Bind_Unsafe_Heap(X,Y,Z) Bind_Heap(X,Y)
#define Bind_Unsafe_HVA(X,Y,Z)  Bind_HVA(X,Y)
#define Bind_Unsafe(X,Y,Z)      Bind(X,Y)        

#endif /* SWAP_BIND */

#ifdef UNBOUND
#define Bind_HVA(X,Y)      {Trail_HVA(X,*((TAGGED *) OffsetBase(X)));\
                            *((TAGGED *) OffsetBase(X)) = (Y);}
#else  /* UNBOUND */
#define Bind_HVA(X,Y)      {Trail_HVA(X);\
                            *((TAGGED *) OffsetBase(X)) = (Y);}
#endif /* UNBOUND */
#define Bind_SVA(X,Y)      {Trail_SVA(X); *(RemoveTag(X,SVA)) = (Y);}
#define Bind_CVA(X,Y)      {Trail_CVA(X); *(RemoveTag(X,CVA))=(Y);Wake_CVA(X);}


#define AlwaysBind(X,Y)     SetVar(X,Y)
#define SetHVA(X,Y)         *((TAGGED *) OffsetBase(X)) = Y
#define SetVar(X,Y)         *(TagToPointer(X)) = (Y);
