/*    File:	 atom_table.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Thu Aug  8 16:57:36 1991
 *    Purpose:   
 */ 

typedef enum {
    ATOM_NIL = 1,
    ATOM_USER_INPUT,
    ATOM_USER_OUTPUT,
    ATOM_USER_ERROR,
    ATOM_R,
    ATOM_W,
    ATOM_USER,
    ATOM_PROLOG,
    ATOM_PUBLIC,
    ATOM_D_PUBLIC,
    ATOM_LIST,
    ATOM_FAIL,
    ATOM_TRUE,
    ATOM_EQUAL,
    ATOM_LESS,
    ATOM_GREATER,
    ATOM_B_OR,
    ATOM_B_AND,
    ATOM_B_XOR,
    ATOM_EXP,
    ATOM_LOG,
    ATOM_SIN,
    ATOM_COS,
    ATOM_TAN,
    ATOM_ASIN,
    ATOM_ACOS,
    ATOM_ATAN,
    ATOM_PREFIX,
    ATOM_D_REF,
    ATOM_IS,
    ATOM_REDUCE,
    ATOM_NAME,
    ATOM_NUMBER_CHARS,
    ATOM_ATOM_CHARS,
    ATOM_HALT,
    ATOM_VERSION,
    ATOM_WAMDEBUG,
    ATOM_PROLOG_WAMDEBUG,
    ATOM_WAMNODEBUG,
    ATOM_TOPCHOICE,
    ATOM_UNIQUE_NAME,
    ATOM_SETARG,
    ATOM_D_ASSERT_DELETE_OTHER,
    ATOM_D_ASSERTA,
    ATOM_D_ASSERTZ,
    ATOM_D_CLAUSE,
    ATOM_D_ERASE,
    ATOM_D_RETRY_CHOICE,
    ATOM_D_RETRY_CUT,
    ATOM_D_SET_SPY,
    ATOM_D_REMOVE_SPY,
    ATOM_D_TRACE,
    ATOM_TRACE,
    ATOM_NOTRACE,
    ATOM_D_GET_TRACE_LEVEL,
    ATOM_D_SET_INC_TRACE_LEVEL,
    ATOM_D_SET_DEC_TRACE_LEVEL,
    ATOM_D_SAVE_CHOICE,
    ATOM_D_GET_SAVED_CHOICE,
    ATOM_D_LOAD,
    ATOM_D_QLOAD,
    ATOM_STATISTICS,
    ATOM_D_STATISTICS_RUNTIME,
    ATOM_D_STATISTICS_GCTIME,
    ATOM_D_STATISTICS_GCNR,
    ATOM_D_STATISTICS_GCBYTES,
    ATOM_D_STATISTICS_WALLTIME,
    ATOM_D_STATISTICS_PARALLEL_RUNTIME,
    ATOM_D_STATISTICS_MEMORY,
    ATOM_D_STATISTICS_GLOBAL,
    ATOM_D_STATISTICS_LOCAL,
    ATOM_D_STATISTICS_TRAIL,
    ATOM_D_STATISTICS_CODE,
    ATOM_D_STATISTICS_ATOM,
    ATOM_DISPLAY,
    ATOM_D_DISPLAY,
    ATOM_WRITE,
    ATOM_D_WRITE,
    ATOM_TTYFLUSH,
    ATOM_TTYNL,
    ATOM_TTYGET0,
    ATOM_TTYGET,
    ATOM_TTYSKIP,
    ATOM_TTYPUT,
    ATOM_FLUSH,
    ATOM_NL,
    ATOM_D_GETCH,
    ATOM_D_GETCH0,
    ATOM_D_TTYGETCH0,
    ATOM_D_SKIP,
    ATOM_D_PROMPT,
    ATOM_GET0,
    ATOM_GET,
    ATOM_PUT,
    ATOM_D_PUT,
    ATOM_D_FLUSH_STREAM,
    ATOM_D_NL,
    ATOM_D_GET0_STREAM,
    ATOM_D_GET_STREAM,
    ATOM_CURRENT_INPUT,
    ATOM_CURRENT_OUTPUT,
    ATOM_D_SET_INPUT,
    ATOM_D_SET_OUTPUT,
    ATOM_D_STREAM,
    ATOM_D_STREAMS,
    ATOM_D_STREAM_NAME,
    ATOM_D_STREAM_MODE,
    ATOM_D_STREAM_FILE,
    ATOM_D_STREAM_CODE,
    ATOM_D_FILE_CODE,
    ATOM_D_CODE_FILE,
    ATOM_D_FOPEN,
    ATOM_D_FDOPEN,
    ATOM_CLOSE,
    ATOM_START,
    ATOM_PLUS,
    ATOM_MINUS,
    ATOM_TIMES,
    ATOM_DIV,
    ATOM_INTDIV,
    ATOM_MOD,
    ATOM_RSHIFT,
    ATOM_LSHIFT,
    ATOM_INTEGER,
    ATOM_FLOAT,
    ATOM_ABS,
    ATOM_PROMPT,
    ATOM_DISTRIBUTE_CODE,
    ATOM_PARALLEL_CALL,
    ATOM_END_ITERATION,
    ATOM_INIT_LEAVES,
    ATOM_RESET_NODES,
    ATOM_LRA,
    ATOM_DNF,
    ATOM_TSP,
    ATOM_D_INTERPRET_GOAL,
    ATOM_D_INTERPRET_GOAL_T,
    ATOM_D_CURR_PRED,
    ATOM_CURRENT_PREDICATE,
    ATOM_D_FILE_MOD_TIME,
    ATOM_D_SET_MODULE,
    ATOM_D_ARRAY,
    ATOM_INTERPRETED,
    ATOM_COMPILED,
    ATOM_BUILT_IN,
    ATOM_D_PREDICATE_PROPERTY,
    ATOM_COPY_TERM,
    ATOM_ELT,
    ATOM_SIZE,
    ATOM_REDUCE_STRUCT,
    ATOM_AREF,
    ATOM_SETREF,
    ATOM_ATOM_MODE,
    ATOM_DEREFTEST,
    ATOM_DEREFTEST_BIND,
    ATOM_TRAILTEST,
    ATOM_TRAILTEST2,
    ATOM_INITTEST,
    ATOM_REWIND,
    ATOM_ACTIVE_WORKERS,
    ATOM_RANDOM,
    ATOM_SRANDOM,
    ATOM_DYNAMIC,
    ATOM_STATIC,
    ATOM_SCHEDULE,
    ATOM_COLLECT_GARBAGE,
    ATOM_ON,
    ATOM_OFF,
    ATOM_PROLOG_FLAG_GC_VERBOSE,
    ATOM_PROLOG_FLAG_LOAD_VERBOSE,
    ATOM_FLOOR,
    ATOM_CEIL,
    ATOM_ABORT,
    ATOM_TABLE_SIZE
} atoms;

#define Print1(A1)               fprintf(stderr,A1)
#define Print2(A1,A2)            fprintf(stderr,A1,A2)
#define Print3(A1,A2,A3)         fprintf(stderr,A1,A2,A3)
#define Print4(A1,A2,A3,A4)      fprintf(stderr,A1,A2,A3,A4)

#define ErrPrint1(A1)            fprintf(stderr,A1)
#define ErrPrint2(A1,A2)         fprintf(stderr,A1,A2)
#define ErrPrint3(A1,A2,A3)      fprintf(stderr,A1,A2,A3)
#define ErrPrint4(A1,A2,A3,A4)   fprintf(stderr,A1,A2,A3,A4)

#define PL_Print1(S,A1)	         fprintf(S,A1)
#define PL_Print2(S,A1,A2)       fprintf(S,A1,A2)
#define PL_Print3(S,A1,A2,A3)    fprintf(S,A1,A2,A3)
#define PL_Print4(S,A1,A2,A3,A4) fprintf(S,A1,A2,A3,A4)

extern char *get_string PROTO((atom, worker *));
extern TAGGED get_mode PROTO((atom, worker *));
extern void init_atom_table PROTO((worker *));
extern void init_node PROTO((worker *));

extern TAGGED atom_table_tagged[ATOM_TABLE_SIZE+1];
extern TAGGED store_atom PROTO((char *, worker *));
extern TAGGED atom_exist PROTO((char *, worker *));
