/*    File:	 atom_table.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Thu Aug  8 16:57:31 1991
 *    Purpose:   The atomtable is only stored in the root node, all other
 *               nodes must get an atoms printname from the root. This is
 *               the code to keep the atom database.
 */ 

#include "include.h"

char *atom_table[ATOM_TABLE_SIZE] = {
    "dummy",
    "[]",
    "user_input",
    "user_output",
    "user_error",
    "r",
    "w",
    "user",
    "prolog",
    "public",
    "$public",
    ".",
    "fail",
    "true",
    "=",
    "<",
    ">",
    "\\/",
    "/\\",
    "#",
    "exp",
    "log",
    "sin",
    "cos",
    "tan",
    "asin",
    "acos",
    "atan",
    "$new",
    "$ref",
    "is",
    "reduce",
    "name",
    "number_chars",
    "atom_chars",
    "halt",
    "version",
    "wamdebug",
    "prolog_wamdebug",
    "wamnodebug",
    "$topchoice",
    "unique_name",
    "setarg",
    "$assert_delete_other",
    "$asserta",
    "$assertz",
    "$clause",
    "$erase",
    "$retry_choice",
    "$retry_cut",
    "$set_spy",
    "$remove_spy",
    "$trace",
    "trace",
    "notrace",
    "$get_trace_level",
    "$set_inc_trace_level",
    "$set_dec_trace_level",
    "$save_choice",
    "$get_saved_choice",
    "$load",
    "$qload",
    "statistics",
    "$statistics_runtime",
    "$statistics_gctime",
    "$statistics_gcnr",
    "$statistics_gcbytes",
    "$statistics_walltime",
    "$statistics_parallel_runtime",
    "$statistics_memory",
    "$statistics_global",
    "$statistics_local",
    "$statistics_trail",
    "$statistics_code",
    "$statistics_atom",
    "display",
    "$display",
    "write",
    "$write",
    "ttyflush",
    "ttynl",
    "ttyget0",
    "ttyget",
    "ttyskip",
    "ttyput",
    "flush",
    "nl",
    "$getch",
    "$getch0",
    "$ttygetch0",
    "$skip",
    "$prompt",
    "get0",
    "get",
    "put",
    "$put",
    "$flush_stream",
    "$nl",
    "$get0_stream",
    "$get_stream",
    "current_input",
    "current_output",
    "$set_input",
    "$set_output",
    "$stream",
    "$streams",
    "$stream_name",
    "$stream_mode",
    "$stream_file",
    "$stream_code",
    "$file_code",
    "$code_file",
    "$fopen",
    "$fdopen",
    "close",
    "start",
    "+",
    "-",
    "*",
    "/",
    "//",
    "mod",
    ">>",
    "<<",
    "integer",
    "float",
    "abs",
    "|: ",
    "$distribute_code",
    "$parallel_call",
    "$end_iteration",
    "$init_leaves",
    "$reset_nodes",
    "$lra",
    "$dnf",
    "$tsp",
    "$interpret_goal",
    "$interpret_goal_trace",
    "$curr_pred",
    "current_predicate",
    "$file_mod_time",
    "$set_module",
    "$array",
    "interpreted",
    "compiled",
    "built_in",
    "$predicate_property",
    "copy_term",
    "elt",
    "size",
    "reduce_struct",
    "aref",
    "setref",
    "$atom_mode",
    "dereftest",
    "dereftest_bind",
    "trailtest",
    "trailtest2",
    "inittest",
    "rewind",
    "active_workers",
    "random",
    "srandom",
    "dyn",
    "stat",
    "schedule",
    "collect_garbage",
    "on",
    "off",
    "prolog_flag_gc_verbose",
    "prolog_flag_load_verbose",
    "floor",
    "ceil",
    "abort"
};

TAGGED atom_table_tagged[ATOM_TABLE_SIZE+1];
atom_bucket **atomtable;

static atom_bucket *make_atom_bucket(a,next,w)
    TAGGED a;
    atom_bucket *next;
    worker *w;
{
    atom_bucket *res;

    res = (atom_bucket *) atom_alloc(sizeof(atom_bucket),w);
    res->a = a;
    res->next = next;
    
    return res;
}

int hash_atom(str)
    char *str;
{
    long hval;
    int i;
    
    hval = str[0] * 113;
    i = 0;
    
    while(str[i]!=0) i++;
    hval += str[i-1] * 109;
    hval += i;
    
    return (int) (hval % ATOMHASHLEN);
}

TAGGED store_atom(str,w)  
    char *str;
    worker *w;
{
    register atom_bucket *bucket;
    register int hv;

    hv = hash_atom(str); 

    for(bucket = atomtable[hv] ;  
	bucket != NULL ;          
	bucket = bucket->next) 
      {
	if(strcmp(str,GetString(bucket->a,w)) == 0)
	  return bucket->a;
      }

    /* add atom first in bucket */
    atomtable[hv] = make_atom_bucket(make_atom(str,w),
						atomtable[hv],w);
    return atomtable[hv]->a;
}

TAGGED atom_exist(str,w)  
    char *str;
    worker *w;
{
    register atom_bucket *bucket;
    register int hv;

    hv = hash_atom(str); 

    for(bucket = atomtable[hv] ;  
	bucket != NULL ;          
	bucket = bucket->next) 
      {
	if(strcmp(str,GetString(bucket->a,w)) == 0)
	  return (TAGGED) NULL;
      }

    /* add atom first in bucket */
    atomtable[hv] = make_atom_bucket(make_atom(str,w),
						atomtable[hv],w);
    return atomtable[hv]->a;
}

char *get_string(a,w)
    atom a;
    worker *w;
{
    return OffsetAtom(a)->pname;
}

TAGGED get_mode(a,w)
    atom a;
    worker *w;
{
    return OffsetAtom(a)->mode;
}


void init_atomtable(w)
    worker *w;
{
    int	i;

    atomtable = w->global->atomtable;
    for(i=0 ; i != ATOMHASHLEN ; i++)
	atomtable[i] = NULL;
}

void init_atom_table(w)
    worker *w;
{
    register int i;

    for(i=0 ; i < ATOM_TABLE_SIZE ; i++) 
	atom_table_tagged[i] = store_atom(atom_table[i],w);
}

void init_node(w)
    worker *w;
{
    init_atomtable(w);
    init_atom_table(w);
}

