/*    File:	 assert.h  
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Nov 18 17:12:51 1991
 *    Purpose:   
 */ 

#ifdef PARALLEL
#define ADispatchUp(K) {if((K) > 0)                                 \
			  {                                         \
			    s = PopCont;                            \
			    goto write_start;                       \
			  }                                         \
                        else                                        \
			  {                                         \
			    register TAGGED x,y;                    \
			    x = (TAGGED) PopCont;                   \
			    y = (TAGGED) PopCont;                   \
			    Bind_Unsafe(y,x,{goto fail;});          \
			    s = PopCont;                            \
			    goto read_start;                        \
			  }                                         \
		         }

#else
#define ADispatchUp(K) {s = PopCont;                                \
			if((K) > 0)                                 \
			  {                                         \
			    goto write_start;                       \
			  }                                         \
                        else                                        \
			  {                                         \
			    goto read_start;                        \
			  }                                         \
		        }
#endif /* PARALLEL */

#define AInitCont     { cont = pdstack; }
#define PushCont(C)   { *(cont++) = (TAGGED) (C); }
#define PopCont       ((TAGGED *) (*(--cont)))

#define IsForward(T)  IsMarked(T)
#define GetForward(T) GetNumber(T)

#ifdef UNBOUND
#define SetForward(V,N) \
	{ PushOnTrail(w->trail_top,*(TagToPointer(V)));\
	  PushOnTrail(w->trail_top,V);\
	  *TagToPointer(V) = Make_Integer(N);\
	  Mark(*TagToPointer(V));\
        }
#else
#define SetForward(V,N) \
	{ PushOnTrail(w->trail_top,V);\
	  *TagToPointer(V) = Make_Integer(N);\
	  Mark(*TagToPointer(V));\
        }
#endif
#define UndoForward(T) Unwind_Trail(T)

#define NextFreeReg(R) (*(R))++

#define EmitOp(O)      *w->global->code_current++ = (TAGGED) (O)
#define EmitOp1(O,A)   *w->global->code_current++ = (TAGGED) (UL(O) | ((A) << INDEXOFFSET))
#define EmitOp2(O,A,B) *w->global->code_current++ = (TAGGED) (UL(O) | ((A) << INDEXOFFSET)\
						  | ((B) << (INDEXOFFSET * 2)))
#define ZapIndex(To,I,V) *(To) |= ((V) << (INDEXOFFSET * (I)))

#define EmitNumber(N)  *w->global->code_current++ = (N)
#define EmitAtom(A)    *w->global->code_current++ = (A)
#define EmitFunctor(F) *w->global->code_current++ = (F)

#define EmitUnsafeFLT(F) { TAGGED ttmp = (F); \
			   if(IsInHeap(ttmp)) {\
			     *w->global->code_current++ =\
			       make_atomspace_float(GetFloat(ttmp),w);\
			   } else {\
			     *w->global->code_current++ = (F);\
			   }\
			 }

extern code *compile_clause PROTO((TAGGED, TAGGED, worker *));
extern int compile_head PROTO((TAGGED, int, int *, worker *));
extern int compile_head_str PROTO((TAGGED *, int, int, int *, worker *));
    
extern BOOL match_term PROTO((Argproto,code *));
