/*    File:	 assert.c  
 *    Author:	 Johan Bevemyr
 *    Created:	 Tue Nov 12 12:44:28 1991
 *    Updated:	 Fri Jul  3 16:40:56 1992
 *    Purpose:   
 */ 

#include "include.h"
#include "unify.h"
#ifdef THREADED_CODE
#undef THREADED_CODE
#endif
#include "engine.h"
#include "assert.h"

/*
   BOOL match_term(worker *, code *)

   takes care of the head unification.


   code *compile_clause(TAGGED, TAGGED, worker *)

   returns a pointer to the code for doing the head unification
   of clause(Head,Body).


   DerefLockSwitch(Var,VarCode,ElseCode)

   If Var is dereferenced to a variable then VarCode is executed,
   otherwise ElseCode. In a parallell context the variable Var is
   locked while VarCode is executed.

 */

TAGGED pdstack[1024];

BOOL match_term(Arg,pc)
    Argdecl;
    register code *pc;
{

    register u32 instruction;
    register TAGGED *s, *areg, *hp;
    register TAGGED k, *cont;

    areg = w->regs;

    LoadHeap;

 read_start:
    
    instruction = Get_Code(pc);

    switch(Get_Instr(instruction)) {
    case A_GET_X_VARIABLE:
    a_get_x_variable:
      {
	register indx i,n;
	
	n = Get_Index_I_M(1,instruction);
	i = Get_Index_I(2,instruction);
	
	X(n) = X(i);
	goto read_start;
      }
    case A_GET_X_VALUE:
    a_get_x_value:
      {
	register indx i,n;
	
	n = Get_Index_I_M(1,instruction);
	i = Get_Index_I(2,instruction);
	
	Unify(X(n),X(i));
	goto read_start;
      }
    case A_GET_CONSTANT:
    a_get_constant:
      {
	register TAGGED c, Xi;
	register indx i;
	
	c = Get_Tagged(pc); 
	i = Get_Index_I(1,instruction);
	
	Xi = X(i);
	DerefLockSwitch(Xi, 
			{
			  Bind_Unsafe(Xi,c,{goto fail;});
			},
			{
			  if(Xi!=c) goto fail;
			});

	goto read_start;
      }
    case A_READ_LIST_TOP:
    a_read_list_top:
      {
	register indx i;
	register TAGGED Xi, lst;

	AInitCont;

	i = Get_Index_I_M(1,instruction);
	Xi = X(i);
#ifdef PARALLEL
	DerefLockSwitch(Xi,
			{
			  k = Get_Index_I(2,instruction);
			  Make_LST_S(H,s,lst);
			  PushCont(Xi);
			  PushCont(lst);
			  goto write_start;
			},
			{
			  if (IsLST(Xi)) {
			    s = GetCar(Xi);
			    goto read_start;
			  } else
			    goto fail;
			});
#else /* PARALLEL */
	DerefLockSwitch(Xi,
			{
			  k = Get_Index_I(2,instruction);
			  Make_LST_S(H,s,lst);
			  Bind_Unsafe(Xi,lst,{goto fail;});
			  goto write_start;
			},
			{
			  if (IsLST(Xi)) {
			    s = GetCar(Xi);
			    goto read_start;
			  } else
			    goto fail;
			});

#endif /* PARALLEL */

      }

    case A_READ_STRUCT_TOP:
    a_read_struct_top:
      {
	register TAGGED Xi, str, f;
	register indx i;

	AInitCont;

	i = Get_Index_I_M(1,instruction);
	f = Get_Functor(pc);
	
	Xi = X(i);
#ifdef PARALLEL
	DerefLockSwitch(Xi,
			{
			  register indx n;
			  k = Get_Index_I(2,instruction);
			  Make_STR_Alloc(H,s,str,f);
			  PushCont(Xi);
			  PushCont(str);
			  goto write_start;
			},
			{
			  if (IsSTR(Xi)) {
			    if(GetFunctor(Xi) == f) {
			      s = GetArg(Xi,0);
			      goto read_start;
			    } else
			      goto fail;
			  } else
			    goto fail;
			});
#else
	DerefLockSwitch(Xi,
			{
			  k = Get_Index_I(2,instruction);
			  Make_STR_Alloc(H,s,str,f);
			  Bind_Unsafe(Xi,str,{goto fail;});
			  goto write_start;
			},
			{
			  if (IsSTR(Xi)) {
			    if(GetFunctor(Xi) == f) {
			      s = GetArg(Xi,0);
			      goto read_start;
			    } else
			      goto fail;
			  } else
			    goto fail;
			});
#endif /* PARALLEL */
      }
    case A_READ_LIST:
      {
	register TAGGED Ds, lst;
	
	Ds = Ref(s);
	s += VARSIZE;
#ifdef PARALLEL
	DerefLockSwitchHVA(Ds,
		        {
			  k = Get_Index_I(1,instruction);
			  Make_LST_S(H,s,lst);
			  PushCont(s);
			  PushCont(Ds);
			  PushCont(lst);
			  goto write_start;
			},
			{
			  if (IsLST(Ds)) {
			    PushCont(s);
			    s = GetCar(Ds);
			    goto read_start;
			  } else
			    goto fail;
			});
#else /* PARALLEL */
	DerefLockSwitchHVA(Ds,
		        {
			  k = Get_Index_I(1,instruction);
			  PushCont(s);
			  Make_LST_S(H,s,lst);
			  Bind_Unsafe(Ds,lst, { goto fail; });
			  goto write_start;
			},
			{
			  if (IsLST(Ds)) {
			    PushCont(s);
			    s = GetCar(Ds);
			    goto read_start;
			  } else
			    goto fail;
			});

#endif /* PARALLEL */
      }

    case A_READ_STRUCT:
      {
	register TAGGED f, Ds, str;

	f = Get_Functor(pc);

	Ds = Ref(s);
	s += VARSIZE;
#ifdef PARALLEL
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  PushCont(s);
			  Make_STR_Alloc(H,s,str,f);
			  PushCont(Ds);
			  PushCont(str);
			  goto write_start;
			},
			{
			  if (IsSTR(Ds)) {
			    PushCont(s);
			    if(GetFunctor(Ds) == f) {
			      s = GetArg(Ds,0);
			      goto read_start;
			    }
			  }
			});
#else /* PARALLEL */
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  PushCont(s);
			  Make_STR_Alloc(H,s,str,f);
			  Bind_Unsafe(Ds,str,{goto fail;});
			  goto write_start;
			},
			{
			  if (IsSTR(Ds)) {
			    PushCont(s);
			    if(GetFunctor(Ds) == f) {
			      s = GetArg(Ds,0);
			      goto read_start;
			    }
			  }
			});
#endif /* PARALLEL */			  
	goto fail;
      }
    case A_READ_LIST_TAIL:
      {
	register TAGGED Ds, lst;
	
	Ds = Ref(s);
	s += VARSIZE;
#ifdef PARALLEL
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  Make_LST_S(H,s,lst);
			  PushCont(Ds);
			  PushCont(lst);
			  goto write_start;
			},
			{
			  if (IsLST(Ds)) {
			    s = GetCar(Ds);
			    goto read_start;
			  } else
			    goto fail;
			});
#else /* PARALLEL */
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  Make_LST_S(H,s,lst);
			  Bind_Unsafe(Ds,lst,{goto fail;});
			  goto write_start;
			},
			{
			  if (IsLST(Ds)) {
			    s = GetCar(Ds);
			    goto read_start;
			  } else
			    goto fail;
			});
#endif /* PARALLEL */
      }
    case A_READ_STRUCT_TAIL:
      {
	register TAGGED f, Ds, str;
	
	f = Get_Functor(pc);
	
	Ds = Ref(s);
	s += VARSIZE;
#ifdef PARALLEL
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  Make_STR_Alloc(H,s,str,f);
			  PushCont(Ds);
			  PushCont(str);
			  goto write_start;
			},
			{
			  if (IsSTR(Ds)) {
			    if(GetFunctor(Ds) == f) {
			      s = GetArg(Ds,0);
			      goto read_start;
			    }
			  }
			});
			  
#else /* PARALLEL */
	DerefLockSwitchHVA(Ds,
			{
			  k = Get_Index_I(1,instruction);
			  Make_STR_Alloc(H,s,str,f);
			  Bind_Unsafe(Ds,str,{goto fail;});
			  goto write_start;
			},
			{
			  if (IsSTR(Ds)) {
			    if(GetFunctor(Ds) == f) {
			      s = GetArg(Ds,0);
			      goto read_start;
			    }
			  }
			});
#endif /* PARALLEL */			  
	goto fail;
      }
    case A_UNIFY_CONSTANT_UP:
      {
	register TAGGED c, Si;

	c = Get_Tagged(pc);
	
	Si = Ref(s);
	DerefLockSwitchHVA(Si,
			{
			  Bind_Unsafe_Heap(Si,c,{goto fail;});
			},
			{
			  if (Si != c)
			    goto fail;
			});
			  
	s = PopCont;
	goto read_start;
      }
    case A_UNIFY_X_VARIABLE_UP:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
      
	X(n) = *(s);
	s = PopCont;
	goto read_start;
      }
    case A_UNIFY_X_VALUE_UP:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	
	Unify(Ref(s),X(n));
	s = PopCont;
	goto read_start;
      }
    case A_UNIFY_X_LOCAL_VALUE_UP:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	
	Unify(X(n),Ref(s));
	goto read_start;
      }
    case A_UNIFY_VOID_UP:
      {
	s = PopCont;
	
	goto read_start;
      }
    case A_UNIFY_VOID:
      {
	s += Get_Index_I(1,instruction);
	
	goto read_start;
      }    
    case A_UNIFY_X_VARIABLE:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	
	X(n) = Ref(s);
	s += VARSIZE;
	goto read_start;
      }    
    case A_UNIFY_X_VALUE:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	
	Unify(Ref(s),X(n));
	s += VARSIZE;
	goto read_start;
      }
    case A_UNIFY_X_LOCAL_VALUE:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	
	Unify(X(n),Ref(s));
	s += VARSIZE;
	goto read_start;
      }
    case A_UNIFY_CONSTANT:
      { 
	register TAGGED c, Si;
	
	c = Get_Tagged(pc);
	
	Si = Ref(s);
	s += VARSIZE;
	DerefLockSwitchHVA(Si,
			{
			  Bind_Unsafe_Heap(Si,c,{goto fail;});
			},
			{
			  if (Si != c)
			    goto fail;
			});
	goto read_start;
      }
#ifdef PARALLEL
    case A_UNLOCK:
      goto read_start;
#endif /* PARALLEL */      
    case A_DONE:
      StoreHeap;
      return TRUE;
    default:
	Error("match_term: switch out of range");
    }

 write_start:

    instruction = Get_Code(pc);

    switch(Get_Instr(instruction)) {
    case A_GET_X_VARIABLE:
      goto a_get_x_variable;
    case A_GET_X_VALUE:
      goto a_get_x_value;
    case A_GET_CONSTANT:
      goto a_get_constant;
    case A_READ_LIST_TOP:
      goto a_read_list_top;
    case A_READ_STRUCT_TOP:
      goto a_read_struct_top;
    case A_READ_LIST:
      {
	PushCont(s+VARSIZE);
	Make_LST_S(H,s,*s);
	goto write_start;
      }
    case A_READ_STRUCT:
      {
	register TAGGED f;

	f = Get_Functor(pc);

	PushCont(s+VARSIZE);

	Make_STR_Alloc(H,s,*s,f);

	goto write_start;
      }
    case A_READ_LIST_TAIL:
      {
#ifdef PARALLEL
	if(k <= 0) {
	    register TAGGED x,y,lst;
	    x = (TAGGED) PopCont;
	    y = (TAGGED) PopCont;
	    Bind_Unsafe(y,x,{goto fail;});
	    InitHVA(s,x,w);
	    Make_LST_S(H,s,lst);
	    PushCont(x);
	    PushCont(lst);
	} else 
#endif
        {
	    Make_LST_S(H,s,*s);
	}
	goto write_start;
      }
    case A_READ_STRUCT_TAIL:
      {
	register TAGGED f;

	f = Get_Functor(pc);

#ifdef PARALLEL
	if(k <= 0) {
	    register TAGGED x,y,str;
	    x = (TAGGED) PopCont;
	    y = (TAGGED) PopCont;
	    Bind_Unsafe(y,x,{goto fail;});
	    InitHVA(s,x,w);
	    Make_STR_Alloc(H,s,str,f);
	    PushCont(x);
	    PushCont(str);
	} else 
#endif /* PARALELL */
	{
	    Make_STR_Alloc(H,s,*s,f);
	}
	goto write_start;
      }
    case A_UNIFY_CONSTANT_UP:
      { 
	register TAGGED c;
	
	c = Get_Tagged(pc);
	
	*(s) = c;

	ADispatchUp(k--);
      }
	
    case A_UNIFY_X_VARIABLE_UP:
      {
	register indx n;

	n = Get_Index_I(1,instruction);

	LoadHVA(s,X(n),w);

	ADispatchUp(k--);
      }
    case A_UNIFY_X_VALUE_UP:
      {
	register indx n;

	n = Get_Index_I(1,instruction);

	*(s) = X(n);

	ADispatchUp(k--);
      }
    case A_UNIFY_X_LOCAL_VALUE_UP:
      {
	register indx n;
	
	n = Get_Index_I(1,instruction);
	
	WriteLocalValue(s,X(n));

	ADispatchUp(k--);
      }
    case A_UNIFY_VOID_UP:
      {
	register indx n;

	n = Get_Index_I(1,instruction); 

	do {CreateHVA(s,w);} while(--n);

	ADispatchUp(k--);
      }
    case A_UNIFY_VOID:
      {
	register indx n;

	n = Get_Index_I(1,instruction); 

	do {CreateHVA(s,w);} while(--n);

	goto write_start;
      }
    case A_UNIFY_X_VARIABLE:
      {
	register indx n;

	n = Get_Index_I(1,instruction);

	LoadHVA(s,X(n),w);

	goto write_start;
      }
    case A_UNIFY_X_VALUE:
      {
	register indx n;
	n = Get_Index_I(1,instruction);
	PushOnHeap(s,X(n));
	goto write_start;
      }
    case A_UNIFY_X_LOCAL_VALUE:
      {
	register indx n;
	
	n = Get_Index_I(1,instruction);
	
	WriteLocalValue(s,X(n));

	goto write_start;
      }
    case A_UNIFY_CONSTANT:
      {
	register TAGGED c;
	
	c = Get_Tagged(pc);
	
	PushOnHeap(s,c);

	goto write_start;
      }
#ifdef PARALLEL
    case A_UNLOCK:
      {
	  register TAGGED x,y;
	  x = (TAGGED) PopCont;
	  y = (TAGGED) PopCont;
	  Bind_Unsafe(y,x,{goto fail;});
	  goto write_start;
      }
#endif /* PARALLEL */      
    case A_DONE:
      StoreHeap;
      return TRUE;
    default:
	Error("match_term: switch out of range");
    }

  fail:
    StoreHeap;
    return FALSE;
}

code *compile_clause(Head,Body,w)
    TAGGED Head, Body;
    worker *w;
{
    TAGGED *save;
    int freg, k;
    code *start = w->global->code_current;

    if(start > w->global->code_end)
      {
	FatalError("code space exhausted");
      }

    save = w->trail_top;
    freg = 2;

    k = compile_head(Head, 0, &freg,w);
    if (k == -1) goto barf;

    k = compile_head(Body, 1, &freg,w);
    if (k == -1) goto barf;

    EmitOp(A_DONE);

    UndoForward(save);
    return start;

 barf:
    UndoForward(save);
    return (code *) NULL;
}

int compile_head(term, reg, freg,w)
    TAGGED term;
    int reg, *freg;
    worker *w;
{

    DerefNLL(term,term);

    switch(LowTagOf(term)) {
    case HVA_LO:
#ifdef CONSTR 
    case CVA_LO:
	Error("compile_head: can't compile CVA");
	return -1;
#endif
    case SVA_LO:
      { indx n;
	n = NextFreeReg(freg);
	EmitOp2(A_GET_X_VARIABLE,n,reg);
	SetForward(term,n);
	return 0;
      }
#ifdef LOCKING
    case LCK_LO:  
	return -1;
#endif
    case NUM_LO:
      if(IsForward(term)) {
	  EmitOp2(A_GET_X_VALUE,reg,GetForward(term));
	  return 0;
      } else {
	  EmitOp1(A_GET_CONSTANT,reg);
	  EmitNumber(term);
	  return 0;
      }

    case FLT_LO:
      EmitOp1(A_GET_CONSTANT,reg);
      EmitUnsafeFLT(term);
      return 0;

    case ATM_LO:
      EmitOp1(A_GET_CONSTANT,reg);
      EmitAtom(term);
      return 0;

    case LST_LO:
      { code *p = w->global->code_current;
	int k;

	EmitOp1(A_READ_LIST_TOP,reg);
	
	k = compile_head_str(GetCar(term),2,0,freg,w);

	if(k == -1) return -1;

	ZapIndex(p,2,k);

#ifdef PARALLEL
	EmitOp(A_UNLOCK);
#endif /* PARALLEL */

	return 0;
      }
	  
    case STR_LO:
      { code *p = w->global->code_current;
	int k;
	TAGGED f;

	EmitOp1(A_READ_STRUCT_TOP,reg);
	f = GetFunctor(term);
	EmitFunctor(f);

	k = compile_head_str(GetArg(term,0),ArityOf(f),0,freg,w);
	
	if(k == -1) return -1;

	ZapIndex(p,2,k);
#ifdef PARALLEL
	EmitOp(A_UNLOCK);
#endif /* PARALLEL */

	return 0;
      }
      
    case GEN_LO:
      Error("compile_head: can't compile generic object");
      return -1;

    default:
      Error("compile_head: switch out of range");
      return -1;
    }
}


int compile_head_str(term,arity,d,freg,w)
    TAGGED *term;
    int arity,d,*freg;
    worker *w;
{
    TAGGED t;
    int k;

    if(w->global->code_current > w->global->code_end)
      {
	FatalError("code space exhausted");
      }


    k = 0;

    while((arity--) > 1) {

        DerefNLL(t,Ref(term));
	term += VARSIZE;

	switch(LowTagOf(t)) {
	case HVA_LO:
#ifdef CONSTR
	  { indx n;
	    n = NextFreeReg(freg);
	    EmitOp1(A_UNIFY_X_VARIABLE,n);
	    SetForward(t,n);
	    break;
	  }
        case CVA_LO:
	  Error("compile_head_str: cant compile CVA");  
          return -1;
#endif
	case SVA_LO:
	  { indx n;
	    n = NextFreeReg(freg);
	    EmitOp1(A_UNIFY_X_VARIABLE,n);
	    SetForward(t,n);
	    break;
	  }

#ifdef LOCKING
        case LCK_LO:
	  return -1;
#endif
	case NUM_LO:
	  if(IsForward(t)) {
	    EmitOp1(A_UNIFY_X_VALUE,GetForward(t));
	    break;
	  } else {
	    EmitOp(A_UNIFY_CONSTANT);
	    EmitNumber(t);
	    break;
	  }

	case FLT_LO:
	  EmitOp(A_UNIFY_CONSTANT);
	  EmitUnsafeFLT(t);
	  break;

	case ATM_LO:
	    EmitOp(A_UNIFY_CONSTANT);
	    EmitAtom(t);
	    break;

	case LST_LO:
	  { code *p = w->global->code_current;
	    int k1;

	    EmitOp(A_READ_LIST);

	    k1 = compile_head_str(GetCar(t),2,1,freg,w);

	    if(k1 == -1) return -1;
	    
	    ZapIndex(p,1,k1);

	    k += k1 + 1;
	    
	    break;
	  }

	case STR_LO:
	  { code *p = w->global->code_current;
	    int k1;
	    TAGGED f;

	    EmitOp(A_READ_STRUCT);
	    f = GetFunctor(t);
	    EmitFunctor(f);

	    k1 = compile_head_str(GetArg(t,0),ArityOf(f),1,freg,w);

	    if(k1 == -1) return -1;
	    
	    ZapIndex(p,1,k1);

	    k += k1 + 1;
	    
	    break;
	  }
	case GEN_LO:
	  Error("compile_head_str: can't compile generic objects");
	  return -1;
	default:
	  Error("compile_head_str: no such term type");
	  return -1;
	}
    }

    DerefNLL(t,Ref(term));
    
    switch(LowTagOf(t)) {
    case HVA_LO:
#ifdef CONSTR
      { indx n;
	n = NextFreeReg(freg);
	if(d) {
	  EmitOp1(A_UNIFY_X_VARIABLE_UP,n);
	} else {
	  EmitOp1(A_UNIFY_X_VARIABLE,n);
	}
	SetForward(t,n);
	break;
      }
    case CVA_LO:
      Error("compile_head_str: can't compile CVA");
      return -1;
#endif
    case SVA_LO:
      { indx n;
	n = NextFreeReg(freg);
	if(d) {
	  EmitOp1(A_UNIFY_X_VARIABLE_UP,n);
	} else {
	  EmitOp1(A_UNIFY_X_VARIABLE,n);
	}
	SetForward(t,n);
	break;
      }
#ifdef LOCKING
    case LCK_LO:
      return -1;
#endif      
    case NUM_LO:
      if(IsForward(t)) {
	if(d) {
	  EmitOp1(A_UNIFY_X_VALUE_UP,GetForward(t));
	} else {
	  EmitOp1(A_UNIFY_X_VALUE,GetForward(t));
	}
	break;
      } else {
	if(d) {
	  EmitOp(A_UNIFY_CONSTANT_UP);
	} else {
	  EmitOp(A_UNIFY_CONSTANT);
	}
	EmitNumber(t);
	break;
      }
      
    case FLT_LO:
      if(d) {
	EmitOp(A_UNIFY_CONSTANT_UP);
      } else {
	EmitOp(A_UNIFY_CONSTANT);
      }
      EmitUnsafeFLT(t);
      break;
      
    case ATM_LO:
      if(d) {
	EmitOp(A_UNIFY_CONSTANT_UP);
      } else {
	EmitOp(A_UNIFY_CONSTANT);
      }
      EmitAtom(t);
      break;
      
    case LST_LO:
      { code *p = w->global->code_current;
	int k1;
	
	EmitOp(A_READ_LIST_TAIL);
	
	k1 = compile_head_str(GetCar(t),2,d,freg,w);
	
	if(k1 == -1) return -1;
	
	ZapIndex(p,1,k1);
	
	k += k1;
	
	break;
      }
      
    case STR_LO:
      { code *p = w->global->code_current;
	int k1;
	TAGGED f;
	
	EmitOp(A_READ_STRUCT_TAIL);
	f = GetFunctor(t);
	EmitFunctor(f);
	
	k1 = compile_head_str(GetArg(t,0),ArityOf(f),d,freg,w);
	
	if(k1 == -1) return -1;
	
	ZapIndex(p,1,k1);
	
	k += k1;
	
	break;
      }

    case GEN_LO:
      Error("compile_head_str: can't compile generic objects");
      return -1;

    default:
      Error("compile_head_str: switch out of range");
      return -1;
    }

    return k;
}
	
