/* ******************************************************************** */
/*  structs.h        Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Basic definitions of tags and structures                             */
/* ******************************************************************** */

/*
 * Change Log:
 *   Version 1, April 1989
 *   added a little support for classes RJB
 *   hacked it about a bit KJP
 *   added semaphores KJP
 */

#ifndef STRUCTS_H
#define STRUCTS_H

#include <stdio.h>

#ifdef WITH_BIGNUMS
#include "BigZ.h"
#endif
#undef BIGNUM

#ifndef SETJMP_H
#define SETJMP_H
#include <setjmp.h>
#endif

/* Load system types... */

#include "system_t.h"

/* Type types */
/* bits meaning
 * 1-2 number of extend bits
 * 3-4 ignore/GC/mark-compact/compact e0
 * 5-6 ignore/GC/mark-compact/compact e1
 * 7-8 ignore/GC/mark-compact/compact e2
 * last field is (if it exists) always collected
 */
#define GC_IGNORE 0
#define GC_GC 1
#define GC_COMPACT 2
#define GC_COMPACTGC 4

typedef struct value_struct
{
  int size;
  LispObject base;
} *value_box;

typedef union lispword_union
{
  LispObject obj;
  int value;
  value_box values;
} lispword;

/* special cases */

typedef struct object_structure
{
  short gc;
  short type;
  LispObject class;
} Object;

struct cons_structure
{
  Object header;
  LispObject car,cdr;
};

struct integer_structure
{
  Object header;
  int value;
};
  
struct float_structure
{
  Object header;
  double fvalue;
};

struct string_structure
{
  Object header;
  values base;
  int len;
};
  
struct vector_structure
{
  Object header;
  values base;
};

/* template */
struct lispob_structure  
{
  Object header;
  lispword val0;
  lispword val1;
  lispword val2;
  lispword val3;
};

struct env_value_struct
{
  LispObject variable;
  LispObject next;
  LispObject value;
  LispObject mutable;
};

struct bignum_value_struct 
{
#ifdef WITH_BIGNUMS
  BigZ          value;
#endif

  int *         bnum;
};


struct complex_structure {
  Object header;
  LispObject	real;
  LispObject	imaginary;
};

struct ratio_structure {
  Object header;
  LispObject	numerator;
  LispObject	denominator;
};
  
struct character_structure
{
  Object header;
  unsigned char	font;
  unsigned char	code;
};

struct symbol_value_structure {
  LispObject    lmodule;  /* Module lookup cache for the interpreter */
  LispObject	lvalue;   /* Part II */
  LispObject	gvalue;   /* Dynamic global value */
  LispObject	plist;
  LispObject name;        /* a string */

  struct symbol_structure* left;
  struct symbol_structure* right;
};


struct table_structure {
  short		type;
  short		gc;
  LispObject	class;
  LispObject	(*comparator)(/*+:Env,:+*/ LispObject, LispObject);
  LispObject    lisp_comparator;
  LispObject	tree;
};

