/* 
  * Definition of Bytevector functions
  *
*/

/* External interface */
#ifdef BCI

LispObject apply_nary_bytefunction(LispObject */*stacktop*/, int args, LispObject fn);
void add_boot_module(LispObject);

/* Internal reperesentation */
#define N_SLOTS_IN_BYTEFUNCTION  4

/* represented as: module #, offset */
/* better would be codevector, offset, static vector ? */

#define bytefunction_env(bvf)		slotref(bvf,0)
#define bytefunction_offset(bvf)	slotref(bvf,1)
#define bytefunction_codenum(bvf)	slotref(bvf,2)
#define bytefunction_nargs(bvf)		slotref(bvf,3)

#endif
