;; Eulisp Module
;; Author: pab
;; File: fn-docs.em
;; Date: Wed Jul  7 13:22:54 1993
;;
;; Project:
;; Description: 
;;

(defmodule fn-docs
  (eulisp0         
   )
  ()
  
  ;; File format is:
  ;; <directory-offset>
  ;; docs...
  ;; directory
  ;; EOF
  ;; A directory entry looks like:
  ;; <position>
  ;; docs are:
  ;;  name.
  ;;  docs (terminated by a line containing only a full-stop). 
  
  (export make-directory make-info read-entry finalise-dbase output-record
	  read-name)

  ;; used to ensure all numbers are the same length 
  
  (defconstant *fudge* 100000000)
  (defconstant *entry-size* 10)

  (defstruct fn-info ()
    ((name initarg name reader fn-info-name)
     (docs initarg docs reader fn-info-docs))
    constructor (make-info name docs))

  (defstruct directory-file ()
    ((stream initarg stream reader output-stream)
     (records initform nil accessor directory-records))
    )
  
  (defun output-record (file info)
    ((setter directory-records) file 
     (nconc (directory-records file) 
	    (list (stream-position (output-stream file)))))
    (write (fn-info-name info) (output-stream file))
    (newline (output-stream file))
    (print (fn-info-docs info) (output-stream file))
    (print "." (output-stream file)))
    

  (defun initialize-dbase (stream)
    (print "          " (output-stream stream))
    (print "WARNING: DO NOT EDIT THIS FILE!" (output-stream stream)))
    
  (defun finalise-dbase (stream)
    (let ((pos (stream-position (output-stream stream))))
      ((setter stream-position) (output-stream stream) 0)
      (prin pos (output-stream stream))
      ((setter stream-position) (output-stream stream) pos)
      (mapc (lambda (ent)
	      (format (output-stream stream) "~d " (+ ent *fudge*)))
	    (directory-records stream))
      (close (output-stream stream))))

  (defun make-directory (name)
    (let ((new (make directory-file 
		     'stream (open name 'output t))))
      (initialize-dbase new)
      new))

  ;; other side...
  (defun find-file-pos (file entry)
    ((setter stream-position) file 0)
    (let ((lst (scan file "~d~%")))
      ((setter stream-position) file (+ (car lst)
					(* *entry-size* entry)))
      (- (car (scan file "~d")) *fudge*)))

  (defun read-entry (file entry)
    (let ((offset (find-file-pos file entry)))
      ((setter stream-position) file offset)
      (let* ((name (make-symbol (car (scan file "~s~%"))))
	     (docs (read-docs file)))
	(cons name docs))))

  (defun read-name (file entry)
    (let ((offset (find-file-pos file entry)))
      ((setter stream-position) file offset)
      (make-symbol (car (scan file "~s~%")))))

  (defun read-docs (file)
    (labels ((aux (s)
		  (let ((next (read-line file)))
		    (if (eq (string-ref next 0) #\.)
			s
		      (aux (string-append s next))))))
	    (aux "")))

  ;; end module
  )

(setq x (make-directory "foo"))
(output-record x (make-fn-info 'zzz "this does good things"))
(output-record x (make-fn-info 'xxx "this does bad things"))
(output-record x (make-fn-info 'wibble "this does newline
 things"))
(output-record x (make-fn-info 'bar "args are:
1: this does good things
"))
(output-record x (make-fn-info 'blank ""))
(finalise-dbase x)
