;; Eulisp Module
;; Author: pab
;; File: vector.em
;; Date: Tue Jun 29 22:07:58 1993
;;
;; Project:
;; Description: 
;;

(defmodule vector
  (gens
   defs
   extras0
   init
   macros0
   )
  ()


;;; ----------
;;; p121
;;; default methods for initial-state, next-state, current-element and
;;; (setter current-element) work for <vector>

  (defmethod element ((v <vector>) (s <fixint>)) (vector-ref v s))

  (defmethod (setter element) ((c <vector>) (s <fixint>) v)
    ((setter vector-ref) c s v))

  (defmethod current-key ((c <vector>) (s <fixint>)) s)

  (defmethod clone ((x <vector>))
    (make <vector> 'size (size x)))
  
  (defmethod allocate ((x <vector-class>) args)
    (let ((size (scan-args 'size args required-argument))
	  (fill (scan-args 'fill args null-argument)))
    (make-vector size fill)))

;;; ----------
;;; specified methods

  (defconstant vector make-initialized-vector)

  (export vector)

;;; ----------
;;; additional methods

  (defmethod size ((c <vector>)) (length c))
  
  (defmethod allocate ((x <vector-class>) args)
    (let ((size (scan-args 'size args required-argument))
	  (fill (scan-args 'fill args null-argument)))
      (make-vector size fill)))

  ;; end module
  )
