;; Eulisp Module
;; Author: pab
;; File: gens.em
;; Date: Tue Jun 29 20:59:56 1993
;;
;; Project:
;; Description: 
;;   All generic functions defined in the standard 
;;   that have not yet been defined go here.

(defmodule gens
  (init
   defs
   extras0
   macros0
   )
  ()
       
  

;; ----------
;; functions for collections

(defgeneric size (o))
(export  size  emptyp  member  gf-member  do  gf-do  anyp
	 gf-any  map  gf-map  accumulate  accumulate1  fill
	 concatenate  gf-concatenate  concatenate-as  
	 gf-concatenate-as  deep-copy  shallow-copy reverse clone)

(defgeneric emptyp (o))

(defun member (v c . f) (gf-member v c (if f (car f) eq)))

(defgeneric gf-member (v c f))

(defun do (f c . cs) (gf-do f c cs))

(defgeneric gf-do (f c cs))


(defun anyp (f c . cs) (gf-any f c cs))

(defgeneric gf-any (f c cs))

(defun map (f c . cs) (gf-map f c cs))

(defgeneric gf-map (f c cs))

(defgeneric accumulate (f i c))

(defgeneric accumulate1 (f c))

(defgeneric fill (mc v start end))

(defun concatenate (sequence . more-sequences)
  (gf-concatenate sequence more-sequences))

(defgeneric gf-concatenate (sequence more-sequences))

(defun concatenate-as (class sequence . more-sequences)
  (gf-concatenate-as class sequence more-sequences))

(defgeneric gf-concatenate-as (class sequence more-sequences))

(defgeneric deep-copy (x))

(defgeneric shallow-copy (x))

(defgeneric clone (x))

(defgeneric reverse (sequence))

;; ----------
;; p123

(defgeneric element (c s))

(defgeneric (setter element) (c s v))

(defgeneric current-key (c s))

(defgeneric key-sequence (c))

(export element current-key key-sequence)

  ;; Iteration protocol

(defgeneric initial-state (c))

(defmethod initial-state (c) (if (= 0 (size c)) () 0))

(defgeneric next-state (c s))

(defmethod next-state (c s) (if (< (+ s 1) (size c)) (+ s 1) ()))

(defgeneric final-state (c))

(defmethod final-state (c) (if (= 0 (size c)) () (- (size c) 1)))

(defgeneric previous-state (c s))

(defmethod previous-state (c s) (if (= s 0) () (- s 1)))

(defgeneric current-element (c s))

(defmethod current-element (c s) (element c s))

(defgeneric (setter current-element) (c s v))

(defmethod (setter current-element) (c s v) ((setter element) c s v))

(defgeneric copy-state (c s))

(defmethod copy-state (c s) s)

(export initial-state next-state final-state previous-state
	current-element copy-state)

  ;; end module
)
