;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: fpi -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: module fpint
-----------------------------------------------------------------------------------
File:    fpint.em
Version: 
State:   

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:
In Franz Allegro (Unix) the class <fpint> must be mapped to the CL-class
INTEGER, because a class FIXNUM doesn't exists

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
 
-----------------------------------------------------------------------------------
|#

#module fpi
(import
 (eulisp-kernel
  (only (fixnump) ccl)
  #+(and :ALLEGRO :FRANZ-INC)
  (only (find-class class-name) common-lisp)
  #+:cmu
  (only (find-class class-name) pcl)
  )

 export 
 (fixed-precision-integer-p
  #+(or :cmu (and :ALLEGRO :FRANZ-INC))
  <fixed-precision-integer>
  #+(or :cmu (and :ALLEGRO :FRANZ-INC))
  <fpi>
  )

 expose 
 ((only (evenp oddp)
    common-lisp)
  number)

 syntax
 (eulisp-kernel))




#-(or :cmu (and :ALLEGRO :FRANZ-INC))
(progn
  (make-eulisp-class fpi fixnum) 
; the alias with a short namemust appear before the following assignment, to
; rename the CL-class to fixed-precision-integer and not to fpi
  (make-eulisp-class fixed-precision-integer fixnum)
)

;#+(or :cmu (and :ALLEGRO :FRANZ-INC))
;(progn 
;  (export <fixed-precision-integer>) 
;  (export <fpi>)
;  (defconstant <fixed-precision-integer> (find-class 'cl:integer))
;  (defconstant <fpi> (find-class 'cl:integer))
;  (setf (find-class '<fixed-precision-integer>) <fixed-precision-integer>)
;  (setf (find-class '<fpi>) <fpi>)
;)


#+(or :cmu (and :ALLEGRO :FRANZ-INC))
(progn  
  (defconstant <fixed-precision-integer> (find-class 'cl:integer))
  (defconstant <fpi> (find-class 'cl:integer))
  (setf (find-class '<fixed-precision-integer>) <fixed-precision-integer>)
  (setf (find-class '<fpi>) <fpi>)
)


(defun fixed-precision-integer-p (x) 
  (fixnump x))


#module-end
