;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el-conditions -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: el-conditions in cl
-----------------------------------------------------------------------------------
File:    el-conditions.em
Version: 2.0 (last modification on Tue Jun 21 13:37:57 1994)
State:   proposed

DESCRIPTION:
fake of the EL-Condition system

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
system rised conditions cannot have a continuation
here one can only accept a condition
Error and cerror not exported because of package conflicts in n-1 files
AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/el-conditions.em[2.0]:
  el-conditions because of name clash with cmucl
[1.1] Thu Sep  2 14:55:01 1993 ukriegel@isst published
  [Thu Sep  2 14:53:42 1993] Intention for change:
[1.2] Fri Feb  4 15:53:42 1994 ukriegel@isst published
  [Fri Feb  4 13:19:44 1994] Intention for change:
  syntax and export
  signal
[1.3] Tue Jun 21 13:38:12 1994 ukriegel@isst proposed
  [Tue Jun 21 13:34:41 1994] Intention for change:
  subtypep.
  signal
[2.0] Tue Jun 21 13:38:12 1994 ukriegel@isst proposed
  [Tue Jun 21 13:34:41 1994] Intention for change:
  subtypep.
  signal

-----------------------------------------------------------------------------------
|#

#module el-conditions
(import
(eulisp-kernel
 el-conditions-0)
 
syntax
(eulisp-kernel el-conditions-0)



expose ((only (defcondition with-handled-conditions  let/cc) el-conditions-0))
export ( signal
        condition-message
        <condition>
        <execution-condition>
        <invalid-operator>
        <bad-apply-argument>
        <cannot-update-setter>
        <no-setter> 
        <improper-unquote-splice>
        <environment-condition>
        <arithmetic-condition> 
        <division-by-zero> 
        <conversion-condition> 
        <no-converter>
        <stream-condition> 
        <syntax-error> 
        <thread-condition> 
        <telos-condition>
        <no-next-method> 
        <no-congruent-lambda-list>
        <incompatible-method-signature> 
        <no-applicable-method>))


;;definitions and init-forms



;;; -----------------------------------------------------------------------------------
;;; Definition of EL level-0-condition classes
;;; -----------------------------------------------------------------------------------

(defcondition <condition>
  ()
  ((continuation :accessor   condition-continuation 
                 :initarg :continuation)
   (message :accessor condition-message :initarg message)))

(defcondition <execution-condition>(<condition>)())
(defcondition <invalid-operator>(<execution-condition>)())
(defcondition <bad-apply-argument>(<execution-condition>)())
(defcondition <cannot-update-setter>(<execution-condition>)())
(defcondition <no-setter>(<execution-condition>)())
(defcondition <improper-unquote-splice>(<execution-condition>)())
(defcondition <environment-condition>(<condition>)())
(defcondition <arithmetic-condition>(<condition>)())
(defcondition <division-by-zero> (<arithmetic-condition>)())
(defcondition <conversion-condition>(<condition>)())
(defcondition <no-converter>(<conversion-condition>)())
(defcondition <stream-condition>(<condition>)())
(defcondition <syntax-error>(<condition>)())
(defcondition <thread-condition>(<condition>)())
(defcondition <telos-condition>(<condition>)())
(defcondition <no-next-method>(<telos-condition>)())
(defcondition <no-congruent-lambda-list>(<telos-condition>)())
(defcondition <incompatible-method-signature>(<telos-condition>)())
(defcondition <no-applicable-method>(<telos-condition>)())

(defun signal (condition continuation)
  (if(cl:subtypep (cl:class-of condition) <condition>)
    (setf (condition-continuation condition) continuation)
    ())
  (cl:signal condition))
                

#module-end



