/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: interface thread -- mm-system and thread -- Lisp
--------------------------------------------------------------------------------File:    thread.h
Version: 1.2 (last modification on Tue Jul  5 14:06:54 1994)
State:   proposed


DESCRIPTION:
   This file is included by both the memory management (if compiled for threads)
   and the eu2c generated c file (if it contains thread primitives)

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/thread.h[1.2]:
  header file for threads to be included by mm and user programs
[1.1] Tue Apr  5 09:32:18 1994 jbimberg@isst proposed
  [Mon Mar 28 14:11:17 1994] Intention for change:
  enable multiple fsl's
[1.2] Tue Jul  5 14:07:07 1994 jbimberg@isst proposed
  [Tue Jul  5 14:05:43 1994] Intention for change:
  mv preemptive -> ! nopreemptive 

--------------------------------------------------------------------------------
*/

#ifndef thread_h
#define thread_h

#ifndef NOTHREADS

typedef void * m_thread;

extern volatile int thread_schedule;

#ifndef NOPREEMPTIVE
/* if preemptive scheduling is allowed, xalloc may be interrupted and 
   then multiple allocs of the same memory location are possible. Thus
   a mechanism to avoid this is necessary. the most simple thing is 
   setting and resetting a variable, which in turn is checked by the 
   scheduler. 
*/
#define ENABLE_SCHEDULE()	thread_schedule = 1
#define DISABLE_SCHEDULE()	thread_schedule = 0
#else
#define ENABLE_SCHEDULE()
#define DISABLE_SCHEDULE()
#endif

m_thread m_thread_init();

m_thread m_thread_create(m_thread (*fun)(), void * args);

void m_thread_yield(m_thread dest);

void m_thread_mark(void (*mark_range)(void *, void *), void * mainstack);

#else

#define ENABLE_SCHEDULE()
#define DISABLE_SCHEDULE()

#endif
#endif
