;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: whc-basic-data-types -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: macros and aux functions to read in the basic data types
-----------------------------------------------------------------------------------
File:    whc-basic-data-types.em
Version: 2.0 (last modification on Wed Feb 16 14:45:08 1994)
State:   proposed

DESCRIPTION:
macros and aux functions to read in the basic data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
here with define-tail for the aux-data-types too

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/whc-basic-data-types.em[2.0]:
  macros and functions for building up the machine data types and basic data types
[1.1] Tue Mar 16 08:54:56 1993 wheick@isst saved
  
[1.2] Tue Mar 16 09:13:45 1993 wheick@isst saved
  new types inserted
[1.3] Tue Mar 16 14:30:28 1993 wheick@isst saved
  insert slot allocation and representation
[1.4] Tue Mar 23 11:23:13 1993 wheick@isst saved
  export new classes 
[1.5] Wed Mar 24 16:40:57 1993 wheick@isst saved
  
[1.6] Wed Mar 24 17:00:12 1993 wheick@isst saved
  
[1.7] Mon Mar 29 17:18:47 1993 wheick@isst proposed
  
[1.8] Fri Apr  2 13:51:22 1993 wheick@isst proposed
  [Fri Apr  2 13:46:22 1993] Intention for change:
  delete :allocation and :mm-type
[1.9] Wed Apr 14 16:06:02 1993 wheick@isst saved
  [Mon Apr  5 11:35:18 1993] Intention for change:
  --- no intent expressed ---replace in define-aux-data-types define-tail with define-singleton-apply-class
[1.10] Wed Apr 14 17:03:20 1993 imohr@isst proposed
  + expose of class-ext
[1.11] Tue Apr 20 09:28:31 1993 wheick@isst published
  
[1.12] Mon Sep 27 11:11:32 1993 imohr@isst proposed
  [Fri Sep 24 16:18:28 1993] Intention for change:
  cycle inmachine-description removed
[1.13] Tue Oct 12 13:06:27 1993 ukriegel@isst published
  [Tue Oct 12 11:28:28 1993] Intention for change:
  clean up
  cleaned
[1.14] Fri Nov  5 15:43:30 1993 ukriegel@isst saved
  special-sys-funs, machine descr.
[1.15] Fri Nov  5 16:05:28 1993 ukriegel@isst saved
  machine-descr.
[1.16] Mon Nov  8 11:55:35 1993 ukriegel@isst proposed
  [Fri Nov  5 16:18:52 1993] Intention for change:
  get-option
  new machine description, ~vector-class-instance-lengt ~vector-class-instance-length-literal
[1.17] Wed Nov 24 11:07:45 1993 ukriegel@isst published
  [Wed Nov 24 08:45:03 1993] Intention for change:
  clean up
[1.18] Thu Feb 17 10:42:56 1994 wheick@isst proposed
  [Wed Feb 16 08:55:20 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Thu Feb 17 10:42:56 1994 wheick@isst proposed
  [Wed Feb 16 08:55:20 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#


;;; -----------------------------------------------------------------------------------
;;; functions for Building up the machine data types and basic data types
;;; 


;;;first the machine data types of the machine, 
;;;define-machine-data-types reads in the list of machine data types 
;;;(from the machine-file) 
;;;and set these to the Constant machine-dates


#module whc-basic-data-types

(import
 (representation
  lzs
  eulisp1
  (only (get-option)option-lists)
  (only (<tail-class-def>) lzs-mop)
  (only (dolist assoc cadr make-instance mapcan intern setf) common-lisp)
  class-ext
  whc-aux)

 syntax
 (eulisp1 
  apply-standard
  (only (setf) common-lisp)
  el2lzs       ; only define-tail is needed
  )

 export 
 (<basic-class-def>
  <%integer>
  <%signed>
  <%unsigned>
  <%float>

  <%pointer>
  <%pointer-to-struct>
  <%pointer-to-vector>
  <%pointer-to-void>
  <%aux-type>
  <%representation>
  <%machine-type>
  <%direct>
  )

 export
 (define-machine-data-types 
   define-aux-data-types   ;data types whithout export
   define-tail-sys-functions ;tail functions with export
   define-tail-aux-sys-functions;tail aux functions without export
   define-special-sys-funs ; taken from rr-md-read
   )
 )



;;;       #########################
(defmacro define-machine-data-types  machine-datas 
;;;       #########################
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(setq ,(car li) 
                            (make-instance <%machine-type>                                      
                              :byte-length ,(get-option :byte-length (cdr li) ())
                            :alignment ,(get-option :alignment (cdr li) ())
                            ))))
          machine-datas))
  `(progn ,@classes)))


     
;define-basic-data-types takes the predifined basic-data-types from
;the machine file, generates for each data type a class (there are the
;classes %unsigned-word-integer) and makes for this class one
;instance. This instance is set to value of the class name (the value
;%unsigned-word-integer is a instance of the class %unsigned-word-integer)  

;define-basic-data-types like in TAIL


;;;read-in the tail functions like %ref... 
;;;in define-tail with export export (like the real data types)

(defun make-instance-symbol (sym) 
  (intern (string-append "$" (symbol-name sym))))


;;;       #########################
(defmacro define-tail-sys-functions funs
;;;       #########################
  (let (progbody)
    (dolist (fun funs)
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      export
                      (special-sys-fun)
                      :protocol-type nil
                      :arg-num nil
                      :match-list nil
                      :inline nil)
                   progbody))
      )
     `(progn ,@progbody)))


;;;       #############################
(defmacro define-tail-aux-sys-functions funs
;;;       #############################
  (let (progbody)
    (dolist (fun funs)
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      nil
                      (special-sys-fun)
                      :protocol-type nil
                      :arg-num nil
                      :match-list nil
                      :inline nil)
                   progbody))
      )
     `(progn ,@progbody)))


;;;       #######################
(defmacro define-basic-data-types  basic-data-types 
;;;       #######################
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(define-tail ,(car li) 
                        export (basic-class-def)
                        :representation ,(get-option :machine-type (cdr li) ())
                        ))) 
                  basic-data-types))
    `(progn ,@classes)))


;;;       #######################
(defmacro define-special-sys-funs  description-list 
;;;       #######################
  (let ((funs  (mapcan (lambda (li)
                             (list
                              `(define-tail ,(car li) 
                                 export (special-sys-fun)
                                 :arg-num ,(get-option :arg-num (cdr li) ())
                                 :inline ()
                                 )
                              
                              )) 
                           description-list)))
    
    `(progn ,@funs)))



#module-end

;;; eof machine data types and basic data types
